/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.config;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.fory.config.CompatibleMode;
import org.apache.fory.config.ForyBuilder;
import org.apache.fory.config.Language;
import org.apache.fory.config.LongEncoding;
import org.apache.fory.meta.MetaCompressor;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.util.Preconditions;

public class Config
implements Serializable {
    private final String name;
    private final Language language;
    private final boolean trackingRef;
    private final boolean basicTypesRefIgnored;
    private final boolean stringRefIgnored;
    private final boolean timeRefIgnored;
    private final boolean copyRef;
    private final boolean codeGenEnabled;
    private final boolean checkClassVersion;
    private final CompatibleMode compatibleMode;
    private final boolean checkJdkClassSerializable;
    private final Class<? extends Serializer> defaultJDKStreamSerializerType;
    private final boolean compressString;
    private final boolean writeNumUtf16BytesForUtf8Encoding;
    private final boolean compressInt;
    private final boolean compressLong;
    private final LongEncoding longEncoding;
    private final boolean requireClassRegistration;
    private final boolean suppressClassRegistrationWarnings;
    private final boolean registerGuavaTypes;
    private final boolean metaShareEnabled;
    private final boolean scopedMetaShareEnabled;
    private final MetaCompressor metaCompressor;
    private final boolean asyncCompilationEnabled;
    private final boolean deserializeNonexistentClass;
    private final boolean scalaOptimizationEnabled;
    private transient int configHash;
    private final boolean deserializeNonexistentEnumValueAsNull;
    private final boolean serializeEnumByName;
    private final int bufferSizeLimitBytes;
    private final int maxDepth;
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final ConcurrentMap<Config, Integer> configIdMap = new ConcurrentHashMap<Config, Integer>();

    public Config(ForyBuilder builder) {
        this.name = builder.name;
        this.language = builder.language;
        this.trackingRef = builder.trackingRef;
        this.basicTypesRefIgnored = !this.trackingRef || builder.basicTypesRefIgnored;
        this.stringRefIgnored = !this.trackingRef || builder.stringRefIgnored;
        this.timeRefIgnored = !this.trackingRef || builder.timeRefIgnored;
        this.copyRef = builder.copyRef;
        this.compressString = builder.compressString;
        this.writeNumUtf16BytesForUtf8Encoding = builder.writeNumUtf16BytesForUtf8Encoding;
        this.compressInt = builder.compressInt;
        this.longEncoding = builder.longEncoding;
        this.compressLong = this.longEncoding != LongEncoding.LE_RAW_BYTES;
        this.requireClassRegistration = builder.requireClassRegistration;
        this.suppressClassRegistrationWarnings = builder.suppressClassRegistrationWarnings;
        this.registerGuavaTypes = builder.registerGuavaTypes;
        this.codeGenEnabled = builder.codeGenEnabled;
        this.checkClassVersion = builder.checkClassVersion;
        this.compatibleMode = builder.compatibleMode;
        this.checkJdkClassSerializable = builder.checkJdkClassSerializable;
        this.defaultJDKStreamSerializerType = builder.defaultJDKStreamSerializerType;
        this.metaShareEnabled = builder.metaShareEnabled;
        this.scopedMetaShareEnabled = builder.scopedMetaShareEnabled;
        this.metaCompressor = builder.metaCompressor;
        this.deserializeNonexistentClass = builder.deserializeNonexistentClass;
        if (this.deserializeNonexistentClass) {
            Preconditions.checkArgument(this.metaShareEnabled || this.compatibleMode == CompatibleMode.COMPATIBLE, "Configuration error: deserializeNonexistentClass=true requires either metaShareEnabled=true to access type information OR compatibleMode=COMPATIBLE to automatically resolve class schemas.");
        }
        this.asyncCompilationEnabled = builder.asyncCompilationEnabled;
        this.scalaOptimizationEnabled = builder.scalaOptimizationEnabled;
        this.deserializeNonexistentEnumValueAsNull = builder.deserializeNonexistentEnumValueAsNull;
        this.serializeEnumByName = builder.serializeEnumByName;
        this.bufferSizeLimitBytes = builder.bufferSizeLimitBytes;
        this.maxDepth = builder.maxDepth;
    }

    public String getName() {
        return this.name;
    }

    public Language getLanguage() {
        return this.language;
    }

    public boolean trackingRef() {
        return this.trackingRef;
    }

    public boolean copyRef() {
        return this.copyRef;
    }

    public boolean isBasicTypesRefIgnored() {
        return this.basicTypesRefIgnored;
    }

    public boolean isStringRefIgnored() {
        return this.stringRefIgnored;
    }

    public boolean deserializeNonexistentEnumValueAsNull() {
        return this.deserializeNonexistentEnumValueAsNull;
    }

    public boolean serializeEnumByName() {
        return this.serializeEnumByName;
    }

    public boolean isTimeRefIgnored() {
        return this.timeRefIgnored;
    }

    public boolean checkClassVersion() {
        return this.checkClassVersion;
    }

    public CompatibleMode getCompatibleMode() {
        return this.compatibleMode;
    }

    public boolean checkJdkClassSerializable() {
        return this.checkJdkClassSerializable;
    }

    public boolean compressString() {
        return this.compressString;
    }

    public boolean writeNumUtf16BytesForUtf8Encoding() {
        return this.writeNumUtf16BytesForUtf8Encoding;
    }

    public boolean compressInt() {
        return this.compressInt;
    }

    public boolean compressLong() {
        return this.compressLong;
    }

    public LongEncoding longEncoding() {
        return this.longEncoding;
    }

    public int bufferSizeLimitBytes() {
        return this.bufferSizeLimitBytes;
    }

    public boolean requireClassRegistration() {
        return this.requireClassRegistration;
    }

    public boolean suppressClassRegistrationWarnings() {
        return this.suppressClassRegistrationWarnings;
    }

    public boolean registerGuavaTypes() {
        return this.registerGuavaTypes;
    }

    public Class<? extends Serializer> getDefaultJDKStreamSerializerType() {
        return this.defaultJDKStreamSerializerType;
    }

    public boolean isMetaShareEnabled() {
        return this.metaShareEnabled;
    }

    public boolean isScopedMetaShareEnabled() {
        return this.scopedMetaShareEnabled;
    }

    public MetaCompressor getMetaCompressor() {
        return this.metaCompressor;
    }

    public boolean deserializeNonexistentClass() {
        return this.deserializeNonexistentClass;
    }

    public boolean isCodeGenEnabled() {
        return this.codeGenEnabled;
    }

    public boolean isAsyncCompilationEnabled() {
        return this.asyncCompilationEnabled;
    }

    public boolean isScalaOptimizationEnabled() {
        return this.scalaOptimizationEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        return this.name == config.name && this.trackingRef == config.trackingRef && this.basicTypesRefIgnored == config.basicTypesRefIgnored && this.stringRefIgnored == config.stringRefIgnored && this.timeRefIgnored == config.timeRefIgnored && this.copyRef == config.copyRef && this.codeGenEnabled == config.codeGenEnabled && this.checkClassVersion == config.checkClassVersion && this.checkJdkClassSerializable == config.checkJdkClassSerializable && this.compressString == config.compressString && this.writeNumUtf16BytesForUtf8Encoding == config.writeNumUtf16BytesForUtf8Encoding && this.compressInt == config.compressInt && this.compressLong == config.compressLong && this.bufferSizeLimitBytes == config.bufferSizeLimitBytes && this.requireClassRegistration == config.requireClassRegistration && this.suppressClassRegistrationWarnings == config.suppressClassRegistrationWarnings && this.registerGuavaTypes == config.registerGuavaTypes && this.metaShareEnabled == config.metaShareEnabled && this.scopedMetaShareEnabled == config.scopedMetaShareEnabled && Objects.equals(this.metaCompressor, config.metaCompressor) && this.asyncCompilationEnabled == config.asyncCompilationEnabled && this.deserializeNonexistentClass == config.deserializeNonexistentClass && this.scalaOptimizationEnabled == config.scalaOptimizationEnabled && this.language == config.language && this.compatibleMode == config.compatibleMode && Objects.equals(this.defaultJDKStreamSerializerType, config.defaultJDKStreamSerializerType) && this.longEncoding == config.longEncoding;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.language, this.trackingRef, this.basicTypesRefIgnored, this.stringRefIgnored, this.timeRefIgnored, this.copyRef, this.codeGenEnabled, this.checkClassVersion, this.compatibleMode, this.checkJdkClassSerializable, this.defaultJDKStreamSerializerType, this.compressString, this.writeNumUtf16BytesForUtf8Encoding, this.compressInt, this.compressLong, this.longEncoding, this.bufferSizeLimitBytes, this.requireClassRegistration, this.suppressClassRegistrationWarnings, this.registerGuavaTypes, this.metaShareEnabled, this.scopedMetaShareEnabled, this.metaCompressor, this.asyncCompilationEnabled, this.deserializeNonexistentClass, this.scalaOptimizationEnabled});
    }

    public int getConfigHash() {
        if (this.configHash == 0) {
            this.configHash = configIdMap.computeIfAbsent(this, k -> counter.incrementAndGet());
        }
        return this.configHash;
    }

    public int maxDepth() {
        return this.maxDepth;
    }
}

