/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.resolver;

import java.util.Arrays;
import org.apache.fory.annotation.Internal;
import org.apache.fory.memory.LittleEndian;
import org.apache.fory.memory.Platform;
import org.apache.fory.meta.MetaString;
import org.apache.fory.meta.MetaStringDecoder;
import org.apache.fory.util.MurmurHash3;

@Internal
public final class MetaStringBytes {
    static final short DEFAULT_DYNAMIC_WRITE_STRING_ID = -1;
    public static final MetaStringBytes EMPTY = MetaStringBytes.of(MetaString.EMPTY);
    private static final int HEADER_MASK = 255;
    final byte[] bytes;
    final long hashCode;
    final MetaString.Encoding encoding;
    final long first8Bytes;
    final long second8Bytes;
    short dynamicWriteStringId = (short)-1;

    MetaStringBytes(byte[] bytes, long hashCode) {
        assert (hashCode != 0L);
        this.bytes = bytes;
        this.hashCode = hashCode;
        int header = (int)(hashCode & 0xFFL);
        this.encoding = MetaString.Encoding.fromInt(header);
        byte[] data = bytes;
        if (bytes.length < 16) {
            data = new byte[16];
            System.arraycopy(bytes, 0, data, 0, bytes.length);
        }
        this.first8Bytes = LittleEndian.getInt64(data, Platform.BYTE_ARRAY_OFFSET);
        this.second8Bytes = LittleEndian.getInt64(data, Platform.BYTE_ARRAY_OFFSET + 8);
    }

    static MetaStringBytes of(MetaString metaString) {
        byte[] bytes = metaString.getBytes();
        long hashCode = MurmurHash3.murmurhash3_x64_128(bytes, 0, bytes.length, 47)[0];
        if ((hashCode = Math.abs(hashCode)) == 0L) {
            hashCode += 256L;
        }
        hashCode &= 0xFFFFFFFFFFFFFF00L;
        MetaString.Encoding encoding = metaString.getEncoding();
        int header = encoding.getValue() & 0xFF;
        return new MetaStringBytes(bytes, hashCode |= (long)header);
    }

    public String decode(char specialChar1, char specialChar2) {
        return this.decode(new MetaStringDecoder(specialChar1, specialChar2));
    }

    public String decode(MetaStringDecoder decoder) {
        return decoder.decode(this.bytes, this.encoding);
    }

    public boolean equals(Object o) {
        MetaStringBytes that = (MetaStringBytes)o;
        return this.hashCode == that.hashCode;
    }

    public int hashCode() {
        return (int)(this.hashCode >> 1);
    }

    public String toString() {
        return "MetaStringBytes{hashCode=" + this.hashCode + ", size=" + this.bytes.length + ", bytes=" + Arrays.toString(this.bytes) + '}';
    }
}

