/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.resolver;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.fory.Fory;
import org.apache.fory.builder.Generated;
import org.apache.fory.collection.IdentityMap;
import org.apache.fory.collection.IdentityObjectIntMap;
import org.apache.fory.collection.LongMap;
import org.apache.fory.collection.ObjectMap;
import org.apache.fory.config.Config;
import org.apache.fory.exception.ClassUnregisteredException;
import org.apache.fory.exception.SerializerUnregisteredException;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.meta.ClassDef;
import org.apache.fory.meta.Encoders;
import org.apache.fory.meta.MetaString;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.reflect.TypeRef;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.ClassInfoHolder;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.resolver.MetaContext;
import org.apache.fory.resolver.MetaStringBytes;
import org.apache.fory.resolver.MetaStringResolver;
import org.apache.fory.resolver.TypeNameBytes;
import org.apache.fory.resolver.TypeResolver;
import org.apache.fory.serializer.ArraySerializers;
import org.apache.fory.serializer.EnumSerializer;
import org.apache.fory.serializer.LazySerializer;
import org.apache.fory.serializer.NonexistentClass;
import org.apache.fory.serializer.NonexistentClassSerializers;
import org.apache.fory.serializer.ObjectSerializer;
import org.apache.fory.serializer.SerializationUtils;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.Serializers;
import org.apache.fory.serializer.collection.CollectionLikeSerializer;
import org.apache.fory.serializer.collection.CollectionSerializer;
import org.apache.fory.serializer.collection.CollectionSerializers;
import org.apache.fory.serializer.collection.MapLikeSerializer;
import org.apache.fory.serializer.collection.MapSerializer;
import org.apache.fory.serializer.collection.MapSerializers;
import org.apache.fory.type.GenericType;
import org.apache.fory.type.Generics;
import org.apache.fory.type.TypeUtils;
import org.apache.fory.util.Preconditions;

public class XtypeResolver
implements TypeResolver {
    private static final Logger LOG = LoggerFactory.getLogger(XtypeResolver.class);
    private static final float loadFactor = 0.5f;
    private static final int MAX_TYPE_ID = 4096;
    private final Config config;
    private final Fory fory;
    private final ClassResolver classResolver;
    private final ClassInfoHolder classInfoCache = new ClassInfoHolder(ClassResolver.NIL_CLASS_INFO);
    private final MetaStringResolver metaStringResolver;
    private final IdentityMap<Class<?>, ClassInfo> classInfoMap = new IdentityMap(64, 0.5f);
    private final ObjectMap<TypeNameBytes, ClassInfo> compositeClassNameBytes2ClassInfo = new ObjectMap(16, 0.5f);
    private final ObjectMap<String, ClassInfo> qualifiedType2ClassInfo = new ObjectMap(16, 0.5f);
    private final Map<Class<?>, ClassDef> classDefMap = new HashMap();
    private final boolean shareMeta;
    private int xtypeIdGenerator = 64;
    private final LongMap<ClassInfo> xtypeIdToClassMap = new LongMap(8, 0.5f);
    private final Set<Integer> registeredTypeIds = new HashSet<Integer>();
    private final Generics generics;

    public XtypeResolver(Fory fory) {
        this.config = fory.getConfig();
        this.fory = fory;
        this.classResolver = fory.getClassResolver();
        this.classResolver.xtypeResolver = this;
        this.shareMeta = fory.getConfig().isMetaShareEnabled();
        this.generics = fory.getGenerics();
        this.metaStringResolver = fory.getMetaStringResolver();
    }

    @Override
    public void initialize() {
        this.registerDefaultTypes();
    }

    public void register(Class<?> type) {
        while (this.registeredTypeIds.contains(this.xtypeIdGenerator)) {
            ++this.xtypeIdGenerator;
        }
        this.register(type, this.xtypeIdGenerator++);
    }

    public void register(Class<?> type, int typeId) {
        Preconditions.checkArgument(typeId < 4096, "Too big type id %s", typeId, new Object[0]);
        ClassInfo classInfo = this.classInfoMap.get(type);
        if (type.isArray()) {
            this.buildClassInfo(type);
            return;
        }
        Serializer<?> serializer = null;
        if (classInfo != null) {
            serializer = classInfo.serializer;
            if (classInfo.xtypeId != 0) {
                throw new IllegalArgumentException(String.format("Type %s has been registered with id %s", type, classInfo.xtypeId));
            }
            String prevNamespace = classInfo.decodeNamespace();
            String prevTypeName = classInfo.decodeTypeName();
            if (!type.getSimpleName().equals(prevTypeName)) {
                throw new IllegalArgumentException(String.format("Type %s has been registered with namespace %s type %s", type, prevNamespace, prevTypeName));
            }
        }
        int xtypeId = typeId;
        if (type.isEnum()) {
            xtypeId = (xtypeId << 8) + 13;
        } else if (serializer != null) {
            xtypeId = this.isStructType(serializer) ? (xtypeId << 8) + 15 : (xtypeId << 8) + 19;
        }
        this.register(type, serializer, ReflectionUtils.getPackage(type), ReflectionUtils.getClassNameWithoutPackage(type), xtypeId);
    }

    public void register(Class<?> type, String namespace, String typeName) {
        Preconditions.checkArgument(!typeName.contains("."), "Typename %s should not contains `.`, please put it into namespace", typeName, new Object[0]);
        ClassInfo classInfo = this.classInfoMap.get(type);
        Serializer<?> serializer = null;
        if (classInfo != null) {
            serializer = classInfo.serializer;
            if (classInfo.typeNameBytes != null) {
                String prevNamespace = classInfo.decodeNamespace();
                String prevTypeName = classInfo.decodeTypeName();
                if (!namespace.equals(prevNamespace) || typeName.equals(prevTypeName)) {
                    throw new IllegalArgumentException(String.format("Type %s has been registered with namespace %s type %s", type, prevNamespace, prevTypeName));
                }
            }
        }
        int xtypeId = serializer != null ? (this.isStructType(serializer) ? 17 : (serializer instanceof EnumSerializer ? 14 : 20)) : (type.isEnum() ? 14 : 17);
        this.register(type, serializer, namespace, typeName, xtypeId);
    }

    private void register(Class<?> type, Serializer<?> serializer, String namespace, String typeName, int xtypeId) {
        ClassInfo classInfo = this.newClassInfo(type, serializer, namespace, typeName, (short)xtypeId);
        this.qualifiedType2ClassInfo.put(TypeUtils.qualifiedName(namespace, typeName), classInfo);
        if (serializer == null) {
            classInfo.serializer = type.isEnum() ? new EnumSerializer(this.fory, type) : new LazySerializer.LazyObjectSerializer(this.fory, type, () -> new ObjectSerializer(this.fory, type));
        }
        this.classInfoMap.put(type, classInfo);
        this.registeredTypeIds.add(xtypeId);
        this.xtypeIdToClassMap.put(xtypeId, classInfo);
    }

    private boolean isStructType(Serializer serializer) {
        if (serializer instanceof ObjectSerializer || serializer instanceof Generated.GeneratedSerializer) {
            return true;
        }
        return serializer instanceof LazySerializer.LazyObjectSerializer;
    }

    private ClassInfo newClassInfo(Class<?> type, Serializer<?> serializer, short xtypeId) {
        return this.newClassInfo(type, serializer, ReflectionUtils.getPackage(type), ReflectionUtils.getClassNameWithoutPackage(type), xtypeId);
    }

    private ClassInfo newClassInfo(Class<?> type, Serializer<?> serializer, String namespace, String typeName, short xtypeId) {
        MetaStringBytes fullClassNameBytes = this.metaStringResolver.getOrCreateMetaStringBytes(Encoders.GENERIC_ENCODER.encode(type.getName(), MetaString.Encoding.UTF_8));
        MetaStringBytes nsBytes = this.metaStringResolver.getOrCreateMetaStringBytes(Encoders.encodePackage(namespace));
        MetaStringBytes classNameBytes = this.metaStringResolver.getOrCreateMetaStringBytes(Encoders.encodeTypeName(typeName));
        return new ClassInfo(type, fullClassNameBytes, nsBytes, classNameBytes, false, serializer, 0, xtypeId);
    }

    public <T> void registerSerializer(Class<T> type, Class<? extends Serializer> serializerClass) {
        ClassInfo classInfo = this.checkClassRegistration(type);
        if (!serializerClass.getPackage().getName().startsWith("org.apache.fory")) {
            SerializationUtils.validate(type, serializerClass);
        }
        classInfo.serializer = Serializers.newSerializer(this.fory, type, serializerClass);
    }

    public void registerSerializer(Class<?> type, Serializer<?> serializer) {
        ClassInfo classInfo = this.checkClassRegistration(type);
        if (!serializer.getClass().getPackage().getName().startsWith("org.apache.fory")) {
            SerializationUtils.validate(type, serializer.getClass());
        }
        classInfo.serializer = serializer;
    }

    private ClassInfo checkClassRegistration(Class<?> type) {
        ClassInfo classInfo = this.classInfoMap.get(type);
        Preconditions.checkArgument(classInfo != null && (classInfo.xtypeId != 0 || !type.getSimpleName().equals(classInfo.decodeTypeName())), "Type %s should be registered with id or namespace+typename before register serializer", type, new Object[0]);
        return classInfo;
    }

    @Override
    public boolean isRegistered(Class<?> cls) {
        return this.classInfoMap.get(cls) != null;
    }

    @Override
    public boolean isRegisteredById(Class<?> cls) {
        ClassInfo classInfo = this.classInfoMap.get(cls);
        if (classInfo == null) {
            return false;
        }
        byte xtypeId = (byte)classInfo.xtypeId;
        if (xtypeId <= 0) {
            return false;
        }
        switch (xtypeId) {
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isRegisteredByName(Class<?> cls) {
        ClassInfo classInfo = this.classInfoMap.get(cls);
        if (classInfo == null) {
            return false;
        }
        byte xtypeId = (byte)classInfo.xtypeId;
        if (xtypeId <= 0) {
            return false;
        }
        switch (xtypeId) {
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isMonomorphic(Class<?> clz) {
        return this.classResolver.isMonomorphic(clz);
    }

    @Override
    public ClassInfo getClassInfo(Class<?> cls) {
        ClassInfo classInfo = this.classInfoMap.get(cls);
        if (classInfo == null) {
            classInfo = this.buildClassInfo(cls);
        }
        return classInfo;
    }

    @Override
    public ClassInfo getClassInfo(Class<?> cls, boolean createIfAbsent) {
        if (createIfAbsent) {
            return this.getClassInfo(cls);
        }
        return this.classInfoMap.get(cls);
    }

    @Override
    public ClassInfo getClassInfo(Class<?> cls, ClassInfoHolder classInfoHolder) {
        ClassInfo classInfo = classInfoHolder.classInfo;
        if (classInfo.getCls() != cls) {
            classInfo = this.classInfoMap.get(cls);
            if (classInfo == null) {
                classInfo = this.buildClassInfo(cls);
            }
            classInfoHolder.classInfo = classInfo;
        }
        assert (classInfo.serializer != null);
        return classInfo;
    }

    public ClassInfo getXtypeInfo(int typeId) {
        return this.xtypeIdToClassMap.get(typeId);
    }

    public ClassInfo getUserTypeInfo(String namespace, String typeName) {
        String name = TypeUtils.qualifiedName(namespace, typeName);
        return (ClassInfo)this.qualifiedType2ClassInfo.get(name);
    }

    public ClassInfo getUserTypeInfo(int userTypeId) {
        Preconditions.checkArgument((byte)userTypeId < 63);
        return this.xtypeIdToClassMap.get(userTypeId);
    }

    @Override
    public boolean needToWriteRef(TypeRef<?> typeRef) {
        ClassInfo classInfo = this.classInfoMap.get(typeRef.getRawType());
        if (classInfo == null) {
            return this.fory.trackingRef();
        }
        return classInfo.serializer.needToWriteRef();
    }

    @Override
    public GenericType buildGenericType(TypeRef<?> typeRef) {
        return this.classResolver.buildGenericType(typeRef);
    }

    @Override
    public GenericType buildGenericType(Type type) {
        return this.classResolver.buildGenericType(type);
    }

    private ClassInfo buildClassInfo(Class<?> cls) {
        int xtypeId;
        Serializer serializer;
        if (this.classResolver.isSet(cls)) {
            if (cls.isAssignableFrom(HashSet.class)) {
                cls = HashSet.class;
                serializer = new CollectionSerializers.HashSetSerializer(this.fory);
            } else {
                serializer = this.getCollectionSerializer(cls);
            }
            xtypeId = 22;
        } else if (this.classResolver.isCollection(cls)) {
            if (cls.isAssignableFrom(ArrayList.class)) {
                cls = ArrayList.class;
                serializer = new CollectionSerializers.ArrayListSerializer(this.fory);
            } else {
                serializer = this.getCollectionSerializer(cls);
            }
            xtypeId = 21;
        } else if (cls.isArray() && !cls.getComponentType().isPrimitive()) {
            serializer = new ArraySerializers.ObjectArraySerializer(this.fory, (Class<T[]>)cls);
            xtypeId = 21;
        } else if (this.classResolver.isMap(cls)) {
            if (cls.isAssignableFrom(HashMap.class)) {
                cls = HashMap.class;
                serializer = new MapSerializers.HashMapSerializer(this.fory);
            } else {
                ClassInfo classInfo = this.classResolver.getClassInfo(cls, false);
                serializer = classInfo != null && classInfo.serializer != null ? (classInfo.serializer instanceof MapLikeSerializer && ((MapLikeSerializer)classInfo.serializer).supportCodegenHook() ? classInfo.serializer : new MapSerializer<Object>(this.fory, cls)) : new MapSerializer<Object>(this.fory, cls);
            }
            xtypeId = 23;
        } else {
            Class<?> enclosingClass = cls.getEnclosingClass();
            if (enclosingClass != null && enclosingClass.isEnum()) {
                serializer = new EnumSerializer(this.fory, (Class<Enum>)cls);
                xtypeId = this.getClassInfo(enclosingClass).xtypeId;
            } else {
                throw new ClassUnregisteredException(cls);
            }
        }
        ClassInfo info = this.newClassInfo(cls, serializer, (short)xtypeId);
        this.classInfoMap.put(cls, info);
        return info;
    }

    private Serializer<?> getCollectionSerializer(Class<?> cls) {
        ClassInfo classInfo = this.classResolver.getClassInfo(cls, false);
        if (classInfo != null && classInfo.serializer != null && classInfo.serializer instanceof CollectionLikeSerializer && ((CollectionLikeSerializer)classInfo.serializer).supportCodegenHook()) {
            return classInfo.serializer;
        }
        return new CollectionSerializer(this.fory, cls);
    }

    private void registerDefaultTypes() {
        this.registerDefaultTypes(1, Boolean.class, Boolean.TYPE, AtomicBoolean.class);
        this.registerDefaultTypes(2, Byte.class, Byte.TYPE);
        this.registerDefaultTypes(3, Short.class, Short.TYPE);
        this.registerDefaultTypes(4, Integer.class, Integer.TYPE, AtomicInteger.class);
        this.registerDefaultTypes(6, Long.class, Long.TYPE, AtomicLong.class);
        this.registerDefaultTypes(10, Float.class, Float.TYPE);
        this.registerDefaultTypes(11, Double.class, Double.TYPE);
        this.registerDefaultTypes(12, String.class, StringBuilder.class, StringBuffer.class);
        this.registerDefaultTypes(24, Duration.class, new Class[0]);
        this.registerDefaultTypes(25, Instant.class, java.util.Date.class, Date.class, Timestamp.class, LocalDateTime.class);
        this.registerDefaultTypes(27, BigDecimal.class, BigInteger.class);
        this.registerDefaultTypes(28, byte[].class, Platform.HEAP_BYTE_BUFFER_CLASS, Platform.DIRECT_BYTE_BUFFER_CLASS);
        this.registerDefaultTypes(30, boolean[].class, new Class[0]);
        this.registerDefaultTypes(32, short[].class, new Class[0]);
        this.registerDefaultTypes(33, int[].class, new Class[0]);
        this.registerDefaultTypes(34, long[].class, new Class[0]);
        this.registerDefaultTypes(36, float[].class, new Class[0]);
        this.registerDefaultTypes(37, double[].class, new Class[0]);
        this.registerDefaultTypes(21, ArrayList.class, Object[].class);
        this.registerDefaultTypes(22, HashSet.class, LinkedHashSet.class);
        this.registerDefaultTypes(23, HashMap.class, LinkedHashMap.class);
        this.registerDefaultTypes(26, LocalDate.class, new Class[0]);
    }

    private void registerDefaultTypes(int xtypeId, Class<?> defaultType, Class<?> ... otherTypes) {
        ClassInfo classInfo = this.newClassInfo(defaultType, this.classResolver.getSerializer(defaultType), (short)xtypeId);
        this.classInfoMap.put(defaultType, classInfo);
        this.xtypeIdToClassMap.put(xtypeId, classInfo);
        for (Class<?> otherType : otherTypes) {
            classInfo = this.newClassInfo(otherType, this.classResolver.getSerializer(otherType), (short)xtypeId);
            this.classInfoMap.put(otherType, classInfo);
        }
    }

    public ClassInfo writeClassInfo(MemoryBuffer buffer, Object obj) {
        ClassInfo classInfo = this.getClassInfo(obj.getClass(), this.classInfoCache);
        this.writeClassInfo(buffer, classInfo);
        return classInfo;
    }

    @Override
    public void writeClassInfo(MemoryBuffer buffer, ClassInfo classInfo) {
        int xtypeId = classInfo.getXtypeId();
        byte internalTypeId = (byte)xtypeId;
        buffer.writeVarUint32Small7(xtypeId);
        switch (internalTypeId) {
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                if (this.shareMeta) {
                    this.writeSharedClassMeta(buffer, classInfo);
                    return;
                }
                assert (classInfo.namespaceBytes != null);
                this.metaStringResolver.writeMetaStringBytes(buffer, classInfo.namespaceBytes);
                assert (classInfo.typeNameBytes != null);
                this.metaStringResolver.writeMetaStringBytes(buffer, classInfo.typeNameBytes);
                break;
            }
        }
    }

    public void writeSharedClassMeta(MemoryBuffer buffer, ClassInfo classInfo) {
        MetaContext metaContext = this.fory.getSerializationContext().getMetaContext();
        assert (metaContext != null) : "Meta context must be set before serialization, please set meta context by SerializationContext.setMetaContext";
        IdentityObjectIntMap<Class<?>> classMap = metaContext.classMap;
        int newId = classMap.size;
        int id = classMap.putOrGet(classInfo.cls, newId);
        if (id >= 0) {
            buffer.writeVarUint32(id);
        } else {
            buffer.writeVarUint32(newId);
            ClassDef classDef = classInfo.classDef;
            if (classDef == null) {
                classDef = this.buildClassDef(classInfo);
            }
            metaContext.writingClassDefs.add(classDef);
        }
    }

    private ClassDef buildClassDef(ClassInfo classInfo) {
        ClassDef classDef;
        classInfo.classDef = classDef = this.classDefMap.computeIfAbsent(classInfo.cls, cls -> ClassDef.buildClassDef(this.fory, cls));
        return classDef;
    }

    @Override
    public <T> Serializer<T> getSerializer(Class<T> cls) {
        return this.getClassInfo(cls).serializer;
    }

    @Override
    public ClassInfo nilClassInfo() {
        return this.classResolver.nilClassInfo();
    }

    @Override
    public ClassInfoHolder nilClassInfoHolder() {
        return this.classResolver.nilClassInfoHolder();
    }

    @Override
    public ClassInfo readClassInfo(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
        return this.readClassInfo(buffer);
    }

    @Override
    public ClassInfo readClassInfo(MemoryBuffer buffer, ClassInfo classInfoCache) {
        return this.readClassInfo(buffer);
    }

    public ClassInfo readClassInfo(MemoryBuffer buffer) {
        long xtypeId = buffer.readVarUint32Small14();
        byte internalTypeId = (byte)xtypeId;
        switch (internalTypeId) {
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                if (this.shareMeta) {
                    return this.readSharedClassMeta(buffer);
                }
                MetaStringBytes packageBytes = this.metaStringResolver.readMetaStringBytes(buffer);
                MetaStringBytes simpleClassNameBytes = this.metaStringResolver.readMetaStringBytes(buffer);
                return this.loadBytesToClassInfo(internalTypeId, packageBytes, simpleClassNameBytes);
            }
            case 21: {
                return this.getListClassInfo();
            }
            case 25: {
                return this.getGenericClassInfo();
            }
        }
        ClassInfo classInfo = this.xtypeIdToClassMap.get(xtypeId);
        if (classInfo == null) {
            this.throwUnexpectTypeIdException(xtypeId);
        }
        return classInfo;
    }

    private ClassInfo readSharedClassMeta(MemoryBuffer buffer) {
        MetaContext metaContext = this.fory.getSerializationContext().getMetaContext();
        assert (metaContext != null) : "Meta context must be set before serialization, please set meta context by SerializationContext.setMetaContext";
        int id = buffer.readVarUint32Small14();
        ClassInfo classInfo = metaContext.readClassInfos.get(id);
        if (classInfo == null) {
            classInfo = this.classResolver.readClassInfoWithMetaShare(metaContext, id);
        }
        return classInfo;
    }

    private void throwUnexpectTypeIdException(long xtypeId) {
        throw new IllegalStateException(String.format("Type id %s not registered", xtypeId));
    }

    private ClassInfo getListClassInfo() {
        this.fory.incReadDepth();
        GenericType genericType = this.generics.nextGenericType();
        this.fory.decDepth();
        if (genericType != null) {
            return this.getOrBuildClassInfo(genericType.getCls());
        }
        return this.xtypeIdToClassMap.get(21L);
    }

    private ClassInfo getGenericClassInfo() {
        this.fory.incReadDepth();
        GenericType genericType = this.generics.nextGenericType();
        this.fory.decDepth();
        if (genericType != null) {
            return this.getOrBuildClassInfo(genericType.getCls());
        }
        return this.xtypeIdToClassMap.get(25L);
    }

    private ClassInfo getOrBuildClassInfo(Class<?> cls) {
        ClassInfo classInfo = this.classInfoMap.get(cls);
        if (classInfo == null) {
            classInfo = this.buildClassInfo(cls);
            this.classInfoMap.put(cls, classInfo);
        }
        return classInfo;
    }

    private ClassInfo loadBytesToClassInfo(int internalTypeId, MetaStringBytes packageBytes, MetaStringBytes simpleClassNameBytes) {
        TypeNameBytes typeNameBytes = new TypeNameBytes(packageBytes.hashCode, simpleClassNameBytes.hashCode);
        ClassInfo classInfo = (ClassInfo)this.compositeClassNameBytes2ClassInfo.get(typeNameBytes);
        if (classInfo == null) {
            classInfo = this.populateBytesToClassInfo(internalTypeId, typeNameBytes, packageBytes, simpleClassNameBytes);
        }
        return classInfo;
    }

    private ClassInfo populateBytesToClassInfo(int typeId, TypeNameBytes typeNameBytes, MetaStringBytes packageBytes, MetaStringBytes simpleClassNameBytes) {
        String typeName;
        String namespace = packageBytes.decode(Encoders.PACKAGE_DECODER);
        String qualifiedName = TypeUtils.qualifiedName(namespace, typeName = simpleClassNameBytes.decode(Encoders.TYPE_NAME_DECODER));
        ClassInfo classInfo = (ClassInfo)this.qualifiedType2ClassInfo.get(qualifiedName);
        if (classInfo == null) {
            String msg = String.format("Class %s not registered", qualifiedName);
            Class<?> type = null;
            if (this.config.deserializeNonexistentClass()) {
                LOG.warn(msg);
                switch (typeId) {
                    case 14: 
                    case 17: 
                    case 18: {
                        type = NonexistentClass.getNonexistentClass(qualifiedName, this.isEnum(typeId), 0, this.config.isMetaShareEnabled());
                        break;
                    }
                    case 20: {
                        throw new SerializerUnregisteredException(qualifiedName);
                    }
                }
            } else {
                throw new ClassUnregisteredException(qualifiedName);
            }
            MetaStringBytes fullClassNameBytes = this.metaStringResolver.getOrCreateMetaStringBytes(Encoders.PACKAGE_ENCODER.encode(qualifiedName, MetaString.Encoding.UTF_8));
            classInfo = new ClassInfo(type, fullClassNameBytes, packageBytes, simpleClassNameBytes, false, null, 0, 0);
            if (NonexistentClass.class.isAssignableFrom(TypeUtils.getComponentIfArray(type))) {
                classInfo.serializer = NonexistentClassSerializers.getSerializer(this.fory, qualifiedName, type);
            }
        }
        this.compositeClassNameBytes2ClassInfo.put(typeNameBytes, classInfo);
        return classInfo;
    }

    private boolean isEnum(int internalTypeId) {
        return internalTypeId == 13 || internalTypeId == 14;
    }

    @Override
    public Fory getFory() {
        return this.fory;
    }
}

