/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.exception;

import org.apache.seata.common.exception.ResourceBundleUtil;

public enum ErrorCode {
    ERR_CONFIG(ErrorType.Config, 1),
    ERR_DESERIALIZATION_SECURITY(ErrorType.Security, 110),
    ERROR_SQL(ErrorType.Datasource, 129);

    private int code;
    private ErrorType type;

    private ErrorCode(ErrorType type, int code) {
        this.code = code;
        this.type = type;
    }

    public int getCode() {
        return this.code;
    }

    public String getType() {
        return this.type.name();
    }

    public String getMessage(String ... params) {
        return ResourceBundleUtil.getInstance().getMessage(this.name(), this.getCode(), this.getType(), params);
    }

    static enum ErrorType {
        Config,
        Network,
        TM,
        RM,
        TC,
        Datasource,
        Security,
        Other;

    }
}

