/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.iotdb.common.rpc.thrift.TPipeHeartbeatResp;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.concurrent.IoTThreadFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.WrappedThreadPoolExecutor;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MetaProgressIndex;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.pipe.agent.task.PipeTask;
import org.apache.iotdb.commons.pipe.agent.task.PipeTaskAgent;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeType;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeName;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.agent.task.PipeDataNodeTask;
import org.apache.iotdb.db.pipe.agent.task.builder.PipeDataNodeBuilder;
import org.apache.iotdb.db.pipe.agent.task.builder.PipeDataNodeTaskBuilder;
import org.apache.iotdb.db.pipe.extractor.dataregion.DataRegionListeningFilter;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.listener.PipeInsertionDataNodeListener;
import org.apache.iotdb.db.pipe.extractor.schemaregion.SchemaRegionListeningFilter;
import org.apache.iotdb.db.pipe.metric.overview.PipeDataNodeSinglePipeMetrics;
import org.apache.iotdb.db.pipe.metric.overview.PipeTsFileToTabletsMetrics;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeOperateSchemaQueueNode;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.mpp.rpc.thrift.TDataNodeHeartbeatResp;
import org.apache.iotdb.mpp.rpc.thrift.TPipeHeartbeatReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaRespExceptionMessage;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeDataNodeTaskAgent
extends PipeTaskAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeDataNodeTaskAgent.class);
    protected static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final ExecutorService pipeExecutor = new WrappedThreadPoolExecutor(0, IoTDBDescriptor.getInstance().getConfig().getPipeTaskThreadCount(), 0L, TimeUnit.SECONDS, new ArrayBlockingQueue(IoTDBDescriptor.getInstance().getConfig().getPipeTaskThreadCount()), new IoTThreadFactory(ThreadName.PIPE_PARALLEL_EXECUTION_POOL.getName()), ThreadName.PIPE_PARALLEL_EXECUTION_POOL.getName(), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());

    protected boolean isShutdown() {
        return PipeDataNodeAgent.runtime().isShutdown();
    }

    protected Map<Integer, PipeTask> buildPipeTasks(PipeMeta pipeMetaFromConfigNode) throws IllegalPathException {
        return new PipeDataNodeBuilder(pipeMetaFromConfigNode).build();
    }

    protected void createPipeTask(int consensusGroupId, PipeStaticMeta pipeStaticMeta, PipeTaskMeta pipeTaskMeta) throws IllegalPathException {
        if (pipeTaskMeta.getLeaderNodeId() == CONFIG.getDataNodeId()) {
            boolean needConstructSchemaRegionTask;
            PipeParameters extractorParameters = pipeStaticMeta.getExtractorParameters();
            DataRegionId dataRegionId = new DataRegionId(consensusGroupId);
            boolean needConstructDataRegionTask = StorageEngine.getInstance().getAllDataRegionIds().contains(dataRegionId) && DataRegionListeningFilter.shouldDataRegionBeListened(extractorParameters, dataRegionId);
            boolean bl = needConstructSchemaRegionTask = SchemaEngine.getInstance().getAllSchemaRegionIds().contains(new SchemaRegionId(consensusGroupId)) && !SchemaRegionListeningFilter.parseListeningPlanTypeSet(extractorParameters).isEmpty();
            if (needConstructDataRegionTask || needConstructSchemaRegionTask) {
                PipeDataNodeTask pipeTask = new PipeDataNodeTaskBuilder(pipeStaticMeta, consensusGroupId, pipeTaskMeta).build();
                pipeTask.create();
                this.pipeTaskManager.addPipeTask(pipeStaticMeta, consensusGroupId, (PipeTask)pipeTask);
            }
        }
        this.pipeMetaKeeper.getPipeMeta(pipeStaticMeta.getPipeName()).getRuntimeMeta().getConsensusGroupId2TaskMetaMap().put(consensusGroupId, pipeTaskMeta);
    }

    public List<TPushPipeMetaRespExceptionMessage> handlePipeMetaChangesInternal(List<PipeMeta> pipeMetaListFromCoordinator) {
        if (this.isShutdown()) {
            return Collections.emptyList();
        }
        List exceptionMessages = super.handlePipeMetaChangesInternal(pipeMetaListFromCoordinator);
        try {
            Set<Integer> validSchemaRegionIds = this.clearSchemaRegionListeningQueueIfNecessary(pipeMetaListFromCoordinator);
            this.closeSchemaRegionListeningQueueIfNecessary(validSchemaRegionIds, exceptionMessages);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to clear/close the schema region listening queue, because {}. Will wait until success or the region's state machine is stopped.", (Object)e.getMessage());
            exceptionMessages.add(new TPushPipeMetaRespExceptionMessage("", e.getMessage(), System.currentTimeMillis()));
        }
        return exceptionMessages;
    }

    private Set<Integer> clearSchemaRegionListeningQueueIfNecessary(List<PipeMeta> pipeMetaListFromCoordinator) throws IllegalPathException {
        HashMap<Integer, Long> schemaRegionId2ListeningQueueNewFirstIndex = new HashMap<Integer, Long>();
        for (PipeMeta pipeMetaFromCoordinator : pipeMetaListFromCoordinator) {
            if (SchemaRegionListeningFilter.parseListeningPlanTypeSet(pipeMetaFromCoordinator.getStaticMeta().getExtractorParameters()).isEmpty()) continue;
            ConcurrentMap groupId2TaskMetaMap = pipeMetaFromCoordinator.getRuntimeMeta().getConsensusGroupId2TaskMetaMap();
            for (SchemaRegionId regionId : SchemaEngine.getInstance().getAllSchemaRegionIds()) {
                int id = regionId.getId();
                PipeTaskMeta pipeTaskMeta = (PipeTaskMeta)groupId2TaskMetaMap.get(id);
                if (pipeTaskMeta == null) continue;
                ProgressIndex progressIndex = pipeTaskMeta.getProgressIndex();
                if (progressIndex instanceof MetaProgressIndex) {
                    if (((MetaProgressIndex)progressIndex).getIndex() + 1L >= schemaRegionId2ListeningQueueNewFirstIndex.getOrDefault(id, Long.MAX_VALUE)) continue;
                    schemaRegionId2ListeningQueueNewFirstIndex.put(id, ((MetaProgressIndex)progressIndex).getIndex() + 1L);
                    continue;
                }
                schemaRegionId2ListeningQueueNewFirstIndex.put(id, 0L);
            }
        }
        schemaRegionId2ListeningQueueNewFirstIndex.forEach((schemaRegionId, listeningQueueNewFirstIndex) -> PipeDataNodeAgent.runtime().schemaListener(new SchemaRegionId(schemaRegionId.intValue())).removeBefore((long)listeningQueueNewFirstIndex));
        return schemaRegionId2ListeningQueueNewFirstIndex.keySet();
    }

    private void closeSchemaRegionListeningQueueIfNecessary(Set<Integer> validSchemaRegionIds, List<TPushPipeMetaRespExceptionMessage> exceptionMessages) {
        if (!exceptionMessages.isEmpty()) {
            return;
        }
        PipeDataNodeAgent.runtime().listeningSchemaRegionIds().stream().filter(schemaRegionId -> !validSchemaRegionIds.contains(schemaRegionId.getId()) && PipeDataNodeAgent.runtime().isSchemaLeaderReady((SchemaRegionId)schemaRegionId)).forEach(schemaRegionId -> {
            try {
                SchemaRegionConsensusImpl.getInstance().write((ConsensusGroupId)schemaRegionId, (IConsensusRequest)new PipeOperateSchemaQueueNode(new PlanNodeId(""), false));
            }
            catch (ConsensusException e) {
                throw new PipeException("Failed to close listening queue for SchemaRegion " + schemaRegionId + ", because " + e.getMessage(), (Throwable)e);
            }
        });
    }

    protected void thawRate(String pipeName, long creationTime) {
        PipeDataNodeSinglePipeMetrics.getInstance().thawRate(pipeName + "_" + creationTime);
    }

    protected void freezeRate(String pipeName, long creationTime) {
        PipeDataNodeSinglePipeMetrics.getInstance().freezeRate(pipeName + "_" + creationTime);
    }

    protected boolean dropPipe(String pipeName, long creationTime) {
        if (!super.dropPipe(pipeName, creationTime)) {
            return false;
        }
        String taskId = pipeName + "_" + creationTime;
        PipeTsFileToTabletsMetrics.getInstance().deregister(taskId);
        PipeDataNodeSinglePipeMetrics.getInstance().deregister(taskId);
        return true;
    }

    protected boolean dropPipe(String pipeName) {
        Map pipeTaskMap;
        PipeMeta pipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        boolean hasPipeTasks = Objects.nonNull(pipeMeta) ? Objects.nonNull(pipeTaskMap = this.pipeTaskManager.getPipeTasks(pipeMeta.getStaticMeta())) && !pipeTaskMap.isEmpty() : false;
        if (!super.dropPipe(pipeName)) {
            return false;
        }
        if (Objects.nonNull(pipeMeta)) {
            long creationTime = pipeMeta.getStaticMeta().getCreationTime();
            String taskId = pipeName + "_" + creationTime;
            PipeTsFileToTabletsMetrics.getInstance().deregister(taskId);
            PipeDataNodeSinglePipeMetrics.getInstance().deregister(taskId);
            if (!hasPipeTasks && PipeStaticMeta.isSubscriptionPipe((String)pipeName)) {
                String topicName = pipeMeta.getStaticMeta().getConnectorParameters().getString("sink.topic");
                String consumerGroupId = pipeMeta.getStaticMeta().getConnectorParameters().getString("sink.consumer-group");
                SubscriptionAgent.broker().updateCompletedTopicNames(consumerGroupId, topicName);
            }
        }
        return true;
    }

    public void stopAllPipesWithCriticalException() {
        super.stopAllPipesWithCriticalException(CONFIG.getDataNodeId());
    }

    public void collectPipeMetaList(TDataNodeHeartbeatResp resp) throws TException {
        if (!this.tryReadLockWithTimeOut((long)CommonDescriptor.getInstance().getConfig().getDnConnectionTimeoutInMS() * 2L / 3L)) {
            return;
        }
        try {
            this.collectPipeMetaListInternal(resp);
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void collectPipeMetaListInternal(TDataNodeHeartbeatResp resp) throws TException {
        if (PipeDataNodeAgent.runtime().isShutdown()) {
            return;
        }
        Optional logger = PipeDataNodeResourceManager.log().schedule(PipeDataNodeTaskAgent.class, PipeConfig.getInstance().getPipeMetaReportMaxLogNumPerRound(), PipeConfig.getInstance().getPipeMetaReportMaxLogIntervalRounds(), this.pipeMetaKeeper.getPipeMetaCount());
        Set dataRegionIds = StorageEngine.getInstance().getAllDataRegionIds().stream().map(ConsensusGroupId::getId).collect(Collectors.toSet());
        ArrayList<ByteBuffer> pipeMetaBinaryList = new ArrayList<ByteBuffer>();
        ArrayList<Boolean> pipeCompletedList = new ArrayList<Boolean>();
        ArrayList<Long> pipeRemainingEventCountList = new ArrayList<Long>();
        ArrayList<Double> pipeRemainingTimeList = new ArrayList<Double>();
        try {
            for (PipeMeta pipeMeta : this.pipeMetaKeeper.getPipeMetaList()) {
                pipeMetaBinaryList.add(pipeMeta.serialize());
                PipeStaticMeta staticMeta = pipeMeta.getStaticMeta();
                Map pipeTaskMap = this.pipeTaskManager.getPipeTasks(staticMeta);
                boolean isAllDataRegionCompleted = pipeTaskMap == null || pipeTaskMap.entrySet().stream().filter(entry -> dataRegionIds.contains(entry.getKey())).allMatch(entry -> ((PipeDataNodeTask)entry.getValue()).isCompleted());
                String extractorModeValue = pipeMeta.getStaticMeta().getExtractorParameters().getStringOrDefault(Arrays.asList("extractor.mode", "source.mode"), "live");
                boolean includeDataAndNeedDrop = (Boolean)DataRegionListeningFilter.parseInsertionDeletionListeningOptionPair(pipeMeta.getStaticMeta().getExtractorParameters()).getLeft() != false && (extractorModeValue.equalsIgnoreCase("query") || extractorModeValue.equalsIgnoreCase("snapshot"));
                boolean isCompleted = isAllDataRegionCompleted && includeDataAndNeedDrop;
                Pair<Long, Double> remainingEventAndTime = PipeDataNodeSinglePipeMetrics.getInstance().getRemainingEventAndTime(staticMeta.getPipeName(), staticMeta.getCreationTime());
                pipeCompletedList.add(isCompleted);
                pipeRemainingEventCountList.add((Long)remainingEventAndTime.getLeft());
                pipeRemainingTimeList.add((Double)remainingEventAndTime.getRight());
                logger.ifPresent(l -> l.info("Reporting pipe meta: {}, isCompleted: {}, remainingEventCount: {}, estimatedRemainingTime: {}", new Object[]{pipeMeta.coreReportMessage(), isCompleted, remainingEventAndTime.getLeft(), remainingEventAndTime.getRight()}));
            }
            logger.ifPresent(l -> l.info("Reported {} pipe metas.", (Object)pipeMetaBinaryList.size()));
        }
        catch (IOException | IllegalPathException e) {
            throw new TException(e);
        }
        resp.setPipeMetaList(pipeMetaBinaryList);
        resp.setPipeCompletedList(pipeCompletedList);
        resp.setPipeRemainingEventCountList(pipeRemainingEventCountList);
        resp.setPipeRemainingTimeList(pipeRemainingTimeList);
        PipeInsertionDataNodeListener.getInstance().listenToHeartbeat(true);
    }

    protected void collectPipeMetaListInternal(TPipeHeartbeatReq req, TPipeHeartbeatResp resp) throws TException {
        if (PipeDataNodeAgent.runtime().isShutdown() && req.heartbeatId != Long.MIN_VALUE) {
            return;
        }
        Optional logger = PipeDataNodeResourceManager.log().schedule(PipeDataNodeTaskAgent.class, PipeConfig.getInstance().getPipeMetaReportMaxLogNumPerRound(), PipeConfig.getInstance().getPipeMetaReportMaxLogIntervalRounds(), this.pipeMetaKeeper.getPipeMetaCount());
        LOGGER.debug("Received pipe heartbeat request {} from config node.", (Object)req.heartbeatId);
        Set dataRegionIds = StorageEngine.getInstance().getAllDataRegionIds().stream().map(ConsensusGroupId::getId).collect(Collectors.toSet());
        ArrayList<ByteBuffer> pipeMetaBinaryList = new ArrayList<ByteBuffer>();
        ArrayList<Boolean> pipeCompletedList = new ArrayList<Boolean>();
        ArrayList<Long> pipeRemainingEventCountList = new ArrayList<Long>();
        ArrayList<Double> pipeRemainingTimeList = new ArrayList<Double>();
        try {
            for (PipeMeta pipeMeta : this.pipeMetaKeeper.getPipeMetaList()) {
                pipeMetaBinaryList.add(pipeMeta.serialize());
                PipeStaticMeta staticMeta = pipeMeta.getStaticMeta();
                Map pipeTaskMap = this.pipeTaskManager.getPipeTasks(staticMeta);
                boolean isAllDataRegionCompleted = pipeTaskMap == null || pipeTaskMap.entrySet().stream().filter(entry -> dataRegionIds.contains(entry.getKey())).allMatch(entry -> ((PipeDataNodeTask)entry.getValue()).isCompleted());
                String extractorModeValue = pipeMeta.getStaticMeta().getExtractorParameters().getStringOrDefault(Arrays.asList("extractor.mode", "source.mode"), "live");
                boolean includeDataAndNeedDrop = (Boolean)DataRegionListeningFilter.parseInsertionDeletionListeningOptionPair(pipeMeta.getStaticMeta().getExtractorParameters()).getLeft() != false && (extractorModeValue.equalsIgnoreCase("query") || extractorModeValue.equalsIgnoreCase("snapshot"));
                boolean isCompleted = isAllDataRegionCompleted && includeDataAndNeedDrop;
                Pair<Long, Double> remainingEventAndTime = PipeDataNodeSinglePipeMetrics.getInstance().getRemainingEventAndTime(staticMeta.getPipeName(), staticMeta.getCreationTime());
                pipeCompletedList.add(isCompleted);
                pipeRemainingEventCountList.add((Long)remainingEventAndTime.getLeft());
                pipeRemainingTimeList.add((Double)remainingEventAndTime.getRight());
                logger.ifPresent(l -> l.info("Reporting pipe meta: {}, isCompleted: {}, remainingEventCount: {}, estimatedRemainingTime: {}", new Object[]{pipeMeta.coreReportMessage(), isCompleted, remainingEventAndTime.getLeft(), remainingEventAndTime.getRight()}));
            }
            logger.ifPresent(l -> l.info("Reported {} pipe metas.", (Object)pipeMetaBinaryList.size()));
        }
        catch (IOException | IllegalPathException e) {
            throw new TException(e);
        }
        resp.setPipeMetaList(pipeMetaBinaryList);
        resp.setPipeCompletedList(pipeCompletedList);
        resp.setPipeRemainingEventCountList(pipeRemainingEventCountList);
        resp.setPipeRemainingTimeList(pipeRemainingTimeList);
        PipeInsertionDataNodeListener.getInstance().listenToHeartbeat(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCompleted(String pipeName, int regionId) {
        this.acquireWriteLock();
        try {
            PipeDataNodeTask pipeDataNodeTask;
            if (this.pipeMetaKeeper.containsPipeMeta(pipeName) && Objects.nonNull(pipeDataNodeTask = (PipeDataNodeTask)this.pipeTaskManager.getPipeTask(this.pipeMetaKeeper.getPipeMeta(pipeName).getStaticMeta(), regionId))) {
                pipeDataNodeTask.markCompleted();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public Set<Integer> getPipeTaskRegionIdSet(String pipeName, long creationTime) {
        PipeMeta pipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        return pipeMeta == null || pipeMeta.getStaticMeta().getCreationTime() != creationTime ? Collections.emptySet() : pipeMeta.getRuntimeMeta().getConsensusGroupId2TaskMetaMap().keySet();
    }

    public boolean hasPipeReleaseRegionRelatedResource(int consensusGroupId) {
        if (!this.tryReadLockWithTimeOut(10L)) {
            LOGGER.warn("Failed to check if pipe has release region related resource with consensus group id: {}.", (Object)consensusGroupId);
            return false;
        }
        try {
            boolean bl = !this.pipeTaskManager.hasPipeTaskInConsensusGroup(consensusGroupId);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void runPipeTasks(Collection<PipeTask> pipeTasks, Consumer<PipeTask> runSingle) {
        HashSet pipeFuture = new HashSet();
        pipeTasks.forEach(pipeTask -> pipeFuture.add(this.pipeExecutor.submit(() -> runSingle.accept((PipeTask)pipeTask))));
        for (Future future : pipeFuture) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.warn("Exception occurs when executing pipe task: ", (Throwable)e);
                throw new PipeException(e.toString());
            }
        }
    }

    public void persistAllProgressIndex() {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TPipeHeartbeatResp resp = new TPipeHeartbeatResp();
            this.collectPipeMetaList(new TPipeHeartbeatReq(Long.MIN_VALUE), resp);
            TSStatus result = configNodeClient.pushHeartbeat(IoTDBDescriptor.getInstance().getConfig().getDataNodeId(), resp);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != result.getCode()) {
                LOGGER.warn("Failed to persist progress index to configNode, status: {}", (Object)result);
            } else {
                LOGGER.info("Successfully persisted all pipe's info to configNode.");
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressIndex getPipeTaskProgressIndex(String pipeName, int consensusGroupId) {
        if (!this.tryReadLockWithTimeOut(10L)) {
            throw new PipeException(String.format("Failed to get pipe task progress index with pipe name: %s, consensus group id %s.", pipeName, consensusGroupId));
        }
        try {
            if (!this.pipeMetaKeeper.containsPipeMeta(pipeName)) {
                throw new PipeException("Pipe meta not found: " + pipeName);
            }
            ProgressIndex progressIndex = ((PipeTaskMeta)this.pipeMetaKeeper.getPipeMeta(pipeName).getRuntimeMeta().getConsensusGroupId2TaskMetaMap().get(consensusGroupId)).getProgressIndex();
            return progressIndex;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public Map<ConsensusPipeName, PipeStatus> getAllConsensusPipe() {
        if (!this.tryReadLockWithTimeOut(10L)) {
            throw new PipeException("Failed to get all consensus pipe.");
        }
        try {
            Map map = (Map)StreamSupport.stream(this.pipeMetaKeeper.getPipeMetaList().spliterator(), false).filter(pipeMeta -> PipeType.CONSENSUS.equals((Object)pipeMeta.getStaticMeta().getPipeType())).collect(ImmutableMap.toImmutableMap(pipeMeta -> new ConsensusPipeName(pipeMeta.getStaticMeta().getPipeName()), pipeMeta -> (PipeStatus)pipeMeta.getRuntimeMeta().getStatus().get()));
            return map;
        }
        finally {
            this.releaseReadLock();
        }
    }

    protected void calculateMemoryUsage(PipeParameters extractorParameters, PipeParameters processorParameters, PipeParameters connectorParameters) {
        if (!PipeConfig.getInstance().isPipeEnableMemoryCheck()) {
            return;
        }
        this.calculateInsertNodeQueueMemory(extractorParameters, processorParameters, connectorParameters);
        long needMemory = 0L;
        needMemory += this.calculateTsFileParserMemory(extractorParameters, processorParameters, connectorParameters);
        needMemory += this.calculateSinkBatchMemory(extractorParameters, processorParameters, connectorParameters);
        PipeMemoryManager pipeMemoryManager = PipeDataNodeResourceManager.memory();
        long freeMemorySizeInBytes = pipeMemoryManager.getFreeMemorySizeInBytes();
        long reservedMemorySizeInBytes = (long)((double)PipeMemoryManager.getTotalMemorySizeInBytes() * PipeConfig.getInstance().getReservedMemoryPercentage());
        if (freeMemorySizeInBytes < (needMemory += this.calculateSendTsFileReadBufferMemory(extractorParameters, processorParameters, connectorParameters)) + reservedMemorySizeInBytes) {
            String message = String.format("%s Need memory: %d bytes, free memory: %d bytes, reserved memory: %d bytes, total memory: %d bytes", "Not enough memory for pipe.", needMemory, freeMemorySizeInBytes, freeMemorySizeInBytes, PipeMemoryManager.getTotalMemorySizeInBytes());
            LOGGER.warn(message);
            throw new PipeException(message);
        }
    }

    private void calculateInsertNodeQueueMemory(PipeParameters extractorParameters, PipeParameters processorParameters, PipeParameters connectorParameters) {
        if (!extractorParameters.getBooleanOrDefault(Arrays.asList("extractor.realtime.enable", "source.realtime.enable"), true)) {
            return;
        }
        String realtimeMode = extractorParameters.getStringByKeys(new String[]{"extractor.realtime.mode", "source.realtime.mode"});
        if ("batch".equals(realtimeMode) || "file".equals(realtimeMode)) {
            return;
        }
        long allocatedMemorySizeInBytes = this.getAllFloatingMemoryUsageInByte();
        long remainingMemory = PipeMemoryManager.getTotalFloatingMemorySizeInBytes() - allocatedMemorySizeInBytes;
        if (remainingMemory < PipeConfig.getInstance().PipeInsertNodeQueueMemory()) {
            String message = String.format("%s Need Floating memory: %d  bytes, free Floating memory: %d bytes", "Not enough memory for pipe.", PipeConfig.getInstance().PipeInsertNodeQueueMemory(), remainingMemory);
            LOGGER.warn(message);
            throw new PipeException(message);
        }
    }

    private long calculateTsFileParserMemory(PipeParameters extractorParameters, PipeParameters processorParameters, PipeParameters connectorParameters) {
        boolean isExtractorHistory = extractorParameters.getBooleanOrDefault("__system.restart", false) || extractorParameters.getBooleanOrDefault(Arrays.asList("extractor.history.enable", "source.history.enable"), true);
        boolean isTSFileParser = isExtractorHistory && extractorParameters.hasAnyAttributes(new String[]{"extractor.history.start-time", "source.history.start-time"});
        isTSFileParser = isTSFileParser || isExtractorHistory && extractorParameters.hasAnyAttributes(new String[]{"extractor.history.end-time", "source.history.end-time"});
        isTSFileParser = isTSFileParser || extractorParameters.hasAnyAttributes(new String[]{"source.start-time", "extractor.start-time"});
        isTSFileParser = isTSFileParser || extractorParameters.hasAnyAttributes(new String[]{"source.end-time", "extractor.end-time"});
        isTSFileParser = isTSFileParser || extractorParameters.hasAnyAttributes(new String[]{"extractor.pattern", "source.pattern"});
        isTSFileParser = isTSFileParser || extractorParameters.hasAnyAttributes(new String[]{"extractor.path", "source.path"});
        boolean bl = isTSFileParser = isTSFileParser || !"hybrid".equals(connectorParameters.getStringOrDefault(Arrays.asList("connector.format", "sink.format"), "hybrid"));
        if (!isTSFileParser) {
            return 0L;
        }
        return PipeConfig.getInstance().getTsFileParserMemory();
    }

    private long calculateSinkBatchMemory(PipeParameters extractorParameters, PipeParameters processorParameters, PipeParameters connectorParameters) {
        boolean needUseBatch = "tsfile".equals(connectorParameters.getStringOrDefault(Arrays.asList("connector.format", "sink.format"), "hybrid"));
        if (needUseBatch) {
            return PipeConfig.getInstance().getSinkBatchMemoryTsFile();
        }
        needUseBatch = connectorParameters.getBooleanOrDefault(Arrays.asList("connector.batch.enable", "sink.batch.enable"), true);
        if (!needUseBatch) {
            return 0L;
        }
        return PipeConfig.getInstance().getSinkBatchMemoryInsertNode();
    }

    private long calculateSendTsFileReadBufferMemory(PipeParameters extractorParameters, PipeParameters processorParameters, PipeParameters connectorParameters) {
        boolean needTransferTsFile = extractorParameters.getBooleanOrDefault("__system.restart", false) || extractorParameters.getBooleanOrDefault(Arrays.asList("extractor.history.enable", "source.history.enable"), true);
        String format = connectorParameters.getStringOrDefault(Arrays.asList("connector.format", "sink.format"), "hybrid");
        boolean bl = needTransferTsFile = needTransferTsFile || "hybrid".equals(format) || "tsfile".equals(format);
        if (!needTransferTsFile) {
            return 0L;
        }
        return PipeConfig.getInstance().getSendTsFileReadBuffer();
    }
}

