/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.Optional;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.util.annotations.Description;

public class StatusCodes {
    private static final ImmutableMap<Long, String[]> DESCRIPTIONS;
    @Description(value="An unexpected error occurred.")
    public static final long Bad_UnexpectedError = 0x80010000L;
    @Description(value="An internal error occurred as a result of a programming or configuration error.")
    public static final long Bad_InternalError = 0x80020000L;
    @Description(value="Not enough memory to complete the operation.")
    public static final long Bad_OutOfMemory = 0x80030000L;
    @Description(value="An operating system resource is not available.")
    public static final long Bad_ResourceUnavailable = 0x80040000L;
    @Description(value="A low level communication error occurred.")
    public static final long Bad_CommunicationError = 0x80050000L;
    @Description(value="Encoding halted because of invalid data in the objects being serialized.")
    public static final long Bad_EncodingError = 0x80060000L;
    @Description(value="Decoding halted because of invalid data in the stream.")
    public static final long Bad_DecodingError = 0x80070000L;
    @Description(value="The message encoding/decoding limits imposed by the stack have been exceeded.")
    public static final long Bad_EncodingLimitsExceeded = 0x80080000L;
    @Description(value="The request message size exceeds limits set by the server.")
    public static final long Bad_RequestTooLarge = 0x80B80000L;
    @Description(value="The response message size exceeds limits set by the client.")
    public static final long Bad_ResponseTooLarge = 2159607808L;
    @Description(value="An unrecognized response was received from the server.")
    public static final long Bad_UnknownResponse = 0x80090000L;
    @Description(value="The operation timed out.")
    public static final long Bad_Timeout = 0x800A0000L;
    @Description(value="The server does not support the requested service.")
    public static final long Bad_ServiceUnsupported = 0x800B0000L;
    @Description(value="The operation was cancelled because the application is shutting down.")
    public static final long Bad_Shutdown = 0x800C0000L;
    @Description(value="The operation could not complete because the client is not connected to the server.")
    public static final long Bad_ServerNotConnected = 0x800D0000L;
    @Description(value="The server has stopped and cannot process any requests.")
    public static final long Bad_ServerHalted = 0x800E0000L;
    @Description(value="There was nothing to do because the client passed a list of operations with no elements.")
    public static final long Bad_NothingToDo = 0x800F0000L;
    @Description(value="The request could not be processed because it specified too many operations.")
    public static final long Bad_TooManyOperations = 0x80100000L;
    @Description(value="The request could not be processed because there are too many monitored items in the subscription.")
    public static final long Bad_TooManyMonitoredItems = 2161836032L;
    @Description(value="The extension object cannot be (de)serialized because the data type id is not recognized.")
    public static final long Bad_DataTypeIdUnknown = 0x80110000L;
    @Description(value="The certificate provided as a parameter is not valid.")
    public static final long Bad_CertificateInvalid = 2148663296L;
    @Description(value="An error occurred verifying security.")
    public static final long Bad_SecurityChecksFailed = 2148728832L;
    @Description(value="The Certificate has expired or is not yet valid.")
    public static final long Bad_CertificateTimeInvalid = 2148794368L;
    @Description(value="An Issuer Certificate has expired or is not yet valid.")
    public static final long Bad_CertificateIssuerTimeInvalid = 2148859904L;
    @Description(value="The HostName used to connect to a Server does not match a HostName in the Certificate.")
    public static final long Bad_CertificateHostNameInvalid = 2148925440L;
    @Description(value="The URI specified in the ApplicationDescription does not match the URI in the Certificate.")
    public static final long Bad_CertificateUriInvalid = 2148990976L;
    @Description(value="The Certificate may not be used for the requested operation.")
    public static final long Bad_CertificateUseNotAllowed = 0x80180000L;
    @Description(value="The Issuer Certificate may not be used for the requested operation.")
    public static final long Bad_CertificateIssuerUseNotAllowed = 2149122048L;
    @Description(value="The Certificate is not trusted.")
    public static final long Bad_CertificateUntrusted = 2149187584L;
    @Description(value="It was not possible to determine if the Certificate has been revoked.")
    public static final long Bad_CertificateRevocationUnknown = 2149253120L;
    @Description(value="It was not possible to determine if the Issuer Certificate has been revoked.")
    public static final long Bad_CertificateIssuerRevocationUnknown = 2149318656L;
    @Description(value="The certificate has been revoked.")
    public static final long Bad_CertificateRevoked = 2149384192L;
    @Description(value="The issuer certificate has been revoked.")
    public static final long Bad_CertificateIssuerRevoked = 2149449728L;
    @Description(value="The certificate chain is incomplete.")
    public static final long Bad_CertificateChainIncomplete = 2165112832L;
    @Description(value="User does not have permission to perform the requested operation.")
    public static final long Bad_UserAccessDenied = 2149515264L;
    @Description(value="The user identity token is not valid.")
    public static final long Bad_IdentityTokenInvalid = 0x80200000L;
    @Description(value="The user identity token is valid but the server has rejected it.")
    public static final long Bad_IdentityTokenRejected = 2149646336L;
    @Description(value="The specified secure channel is no longer valid.")
    public static final long Bad_SecureChannelIdInvalid = 0x80220000L;
    @Description(value="The timestamp is outside the range allowed by the server.")
    public static final long Bad_InvalidTimestamp = 2149777408L;
    @Description(value="The nonce does appear to be not a random value or it is not the correct length.")
    public static final long Bad_NonceInvalid = 2149842944L;
    @Description(value="The session id is not valid.")
    public static final long Bad_SessionIdInvalid = 2149908480L;
    @Description(value="The session was closed by the client.")
    public static final long Bad_SessionClosed = 2149974016L;
    @Description(value="The session cannot be used because ActivateSession has not been called.")
    public static final long Bad_SessionNotActivated = 2150039552L;
    @Description(value="The subscription id is not valid.")
    public static final long Bad_SubscriptionIdInvalid = 0x80280000L;
    @Description(value="The header for the request is missing or invalid.")
    public static final long Bad_RequestHeaderInvalid = 2150236160L;
    @Description(value="The timestamps to return parameter is invalid.")
    public static final long Bad_TimestampsToReturnInvalid = 2150301696L;
    @Description(value="The request was cancelled by the client.")
    public static final long Bad_RequestCancelledByClient = 2150367232L;
    @Description(value="Too many arguments were provided.")
    public static final long Bad_TooManyArguments = 2162491392L;
    @Description(value="The subscription was transferred to another session.")
    public static final long Good_SubscriptionTransferred = 0x2D0000L;
    @Description(value="The processing will complete asynchronously.")
    public static final long Good_CompletesAsynchronously = 0x2E0000L;
    @Description(value="Sampling has slowed down due to resource limitations.")
    public static final long Good_Overload = 0x2F0000L;
    @Description(value="The value written was accepted but was clamped.")
    public static final long Good_Clamped = 0x300000L;
    @Description(value="Communication with the data source is defined, but not established, and there is no last known value available.")
    public static final long Bad_NoCommunication = 2150694912L;
    @Description(value="Waiting for the server to obtain values from the underlying data source.")
    public static final long Bad_WaitingForInitialData = 2150760448L;
    @Description(value="The syntax of the node id is not valid.")
    public static final long Bad_NodeIdInvalid = 0x80330000L;
    @Description(value="The node id refers to a node that does not exist in the server address space.")
    public static final long Bad_NodeIdUnknown = 2150891520L;
    @Description(value="The attribute is not supported for the specified Node.")
    public static final long Bad_AttributeIdInvalid = 2150957056L;
    @Description(value="The syntax of the index range parameter is invalid.")
    public static final long Bad_IndexRangeInvalid = 2151022592L;
    @Description(value="No data exists within the range of indexes specified.")
    public static final long Bad_IndexRangeNoData = 2151088128L;
    @Description(value="The data encoding is invalid.")
    public static final long Bad_DataEncodingInvalid = 0x80380000L;
    @Description(value="The server does not support the requested data encoding for the node.")
    public static final long Bad_DataEncodingUnsupported = 2151219200L;
    @Description(value="The access level does not allow reading or subscribing to the Node.")
    public static final long Bad_NotReadable = 2151284736L;
    @Description(value="The access level does not allow writing to the Node.")
    public static final long Bad_NotWritable = 2151350272L;
    @Description(value="The value was out of range.")
    public static final long Bad_OutOfRange = 2151415808L;
    @Description(value="The requested operation is not supported.")
    public static final long Bad_NotSupported = 2151481344L;
    @Description(value="A requested item was not found or a search operation ended without success.")
    public static final long Bad_NotFound = 2151546880L;
    @Description(value="The object cannot be used because it has been deleted.")
    public static final long Bad_ObjectDeleted = 2151612416L;
    @Description(value="Requested operation is not implemented.")
    public static final long Bad_NotImplemented = 0x80400000L;
    @Description(value="The monitoring mode is invalid.")
    public static final long Bad_MonitoringModeInvalid = 2151743488L;
    @Description(value="The monitoring item id does not refer to a valid monitored item.")
    public static final long Bad_MonitoredItemIdInvalid = 2151809024L;
    @Description(value="The monitored item filter parameter is not valid.")
    public static final long Bad_MonitoredItemFilterInvalid = 2151874560L;
    @Description(value="The server does not support the requested monitored item filter.")
    public static final long Bad_MonitoredItemFilterUnsupported = 0x80440000L;
    @Description(value="A monitoring filter cannot be used in combination with the attribute specified.")
    public static final long Bad_FilterNotAllowed = 2152005632L;
    @Description(value="A mandatory structured parameter was missing or null.")
    public static final long Bad_StructureMissing = 2152071168L;
    @Description(value="The event filter is not valid.")
    public static final long Bad_EventFilterInvalid = 2152136704L;
    @Description(value="The content filter is not valid.")
    public static final long Bad_ContentFilterInvalid = 0x80480000L;
    @Description(value="An unregognized operator was provided in a filter.")
    public static final long Bad_FilterOperatorInvalid = 2160132096L;
    @Description(value="A valid operator was provided.")
    public static final long Bad_FilterOperatorUnsupported = 2160197632L;
    @Description(value="The number of operands provided for the filter operator was less then expected for the operand provided.")
    public static final long Bad_FilterOperandCountMismatch = 2160263168L;
    @Description(value="The operand used in a content filter is not valid.")
    public static final long Bad_FilterOperandInvalid = 2152267776L;
    @Description(value="The referenced element is not a valid element in the content filter.")
    public static final long Bad_FilterElementInvalid = 2160328704L;
    @Description(value="The referenced literal is not a valid value.")
    public static final long Bad_FilterLiteralInvalid = 2160394240L;
    @Description(value="The continuation point provide is longer valid.")
    public static final long Bad_ContinuationPointInvalid = 2152333312L;
    @Description(value="The operation could not be processed because all continuation points have been allocated.")
    public static final long Bad_NoContinuationPoints = 2152398848L;
    @Description(value="The reference type id does not refer to a valid reference type node.")
    public static final long Bad_ReferenceTypeIdInvalid = 2152464384L;
    @Description(value="The browse direction is not valid.")
    public static final long Bad_BrowseDirectionInvalid = 2152529920L;
    @Description(value="The node is not part of the view.")
    public static final long Bad_NodeNotInView = 2152595456L;
    @Description(value="The ServerUri is not a valid URI.")
    public static final long Bad_ServerUriInvalid = 2152660992L;
    @Description(value="No ServerName was specified.")
    public static final long Bad_ServerNameMissing = 0x80500000L;
    @Description(value="No DiscoveryUrl was specified.")
    public static final long Bad_DiscoveryUrlMissing = 2152792064L;
    @Description(value="The semaphore file specified by the client is not valid.")
    public static final long Bad_SempahoreFileMissing = 2152857600L;
    @Description(value="The security token request type is not valid.")
    public static final long Bad_RequestTypeInvalid = 2152923136L;
    @Description(value="The security mode does not meet the requirements set by the Server.")
    public static final long Bad_SecurityModeRejected = 2152988672L;
    @Description(value="The security policy does not meet the requirements set by the Server.")
    public static final long Bad_SecurityPolicyRejected = 0x80550000L;
    @Description(value="The server has reached its maximum number of sessions.")
    public static final long Bad_TooManySessions = 2153119744L;
    @Description(value="The user token signature is missing or invalid.")
    public static final long Bad_UserSignatureInvalid = 2153185280L;
    @Description(value="The signature generated with the client certificate is missing or invalid.")
    public static final long Bad_ApplicationSignatureInvalid = 0x80580000L;
    @Description(value="The client did not provide at least one software certificate that is valid and meets the profile requirements for the server.")
    public static final long Bad_NoValidCertificates = 2153316352L;
    @Description(value="The Server does not support changing the user identity assigned to the session.")
    public static final long Bad_IdentityChangeNotSupported = 2160459776L;
    @Description(value="The request was cancelled by the client with the Cancel service.")
    public static final long Bad_RequestCancelledByRequest = 2153381888L;
    @Description(value="The parent node id does not to refer to a valid node.")
    public static final long Bad_ParentNodeIdInvalid = 2153447424L;
    @Description(value="The reference could not be created because it violates constraints imposed by the data model.")
    public static final long Bad_ReferenceNotAllowed = 2153512960L;
    @Description(value="The requested node id was reject because it was either invalid or server does not allow node ids to be specified by the client.")
    public static final long Bad_NodeIdRejected = 2153578496L;
    @Description(value="The requested node id is already used by another node.")
    public static final long Bad_NodeIdExists = 2153644032L;
    @Description(value="The node class is not valid.")
    public static final long Bad_NodeClassInvalid = 2153709568L;
    @Description(value="The browse name is invalid.")
    public static final long Bad_BrowseNameInvalid = 0x80600000L;
    @Description(value="The browse name is not unique among nodes that share the same relationship with the parent.")
    public static final long Bad_BrowseNameDuplicated = 2153840640L;
    @Description(value="The node attributes are not valid for the node class.")
    public static final long Bad_NodeAttributesInvalid = 2153906176L;
    @Description(value="The type definition node id does not reference an appropriate type node.")
    public static final long Bad_TypeDefinitionInvalid = 2153971712L;
    @Description(value="The source node id does not reference a valid node.")
    public static final long Bad_SourceNodeIdInvalid = 2154037248L;
    @Description(value="The target node id does not reference a valid node.")
    public static final long Bad_TargetNodeIdInvalid = 2154102784L;
    @Description(value="The reference type between the nodes is already defined.")
    public static final long Bad_DuplicateReferenceNotAllowed = 0x80660000L;
    @Description(value="The server does not allow this type of self reference on this node.")
    public static final long Bad_InvalidSelfReference = 2154233856L;
    @Description(value="The reference type is not valid for a reference to a remote server.")
    public static final long Bad_ReferenceLocalOnly = 0x80680000L;
    @Description(value="The server will not allow the node to be deleted.")
    public static final long Bad_NoDeleteRights = 2154364928L;
    @Description(value="The server was not able to delete all target references.")
    public static final long Uncertain_ReferenceNotDeleted = 1086062592L;
    @Description(value="The server index is not valid.")
    public static final long Bad_ServerIndexInvalid = 2154430464L;
    @Description(value="The view id does not refer to a valid view node.")
    public static final long Bad_ViewIdUnknown = 2154496000L;
    @Description(value="The view timestamp is not available or not supported.")
    public static final long Bad_ViewTimestampInvalid = 2160656384L;
    @Description(value="The view parameters are not consistent with each other.")
    public static final long Bad_ViewParameterMismatch = 2160721920L;
    @Description(value="The view version is not available or not supported.")
    public static final long Bad_ViewVersionInvalid = 2160787456L;
    @Description(value="The list of references may not be complete because the underlying system is not available.")
    public static final long Uncertain_NotAllNodesAvailable = 0x40C00000L;
    @Description(value="The server should have followed a reference to a node in a remote server but did not. The result set may be incomplete.")
    public static final long Good_ResultsMayBeIncomplete = 0xBA0000L;
    @Description(value="The provided Nodeid was not a type definition nodeid.")
    public static final long Bad_NotTypeDefinition = 0x80C80000L;
    @Description(value="One of the references to follow in the relative path references to a node in the address space in another server.")
    public static final long Uncertain_ReferenceOutOfServer = 1080819712L;
    @Description(value="The requested operation has too many matches to return.")
    public static final long Bad_TooManyMatches = 2154627072L;
    @Description(value="The requested operation requires too many resources in the server.")
    public static final long Bad_QueryTooComplex = 2154692608L;
    @Description(value="The requested operation has no match to return.")
    public static final long Bad_NoMatch = 2154758144L;
    @Description(value="The max age parameter is invalid.")
    public static final long Bad_MaxAgeInvalid = 0x80700000L;
    @Description(value="The operation is not permitted over the current secure channel.")
    public static final long Bad_SecurityModeInsufficient = 2162556928L;
    @Description(value="The history details parameter is not valid.")
    public static final long Bad_HistoryOperationInvalid = 2154889216L;
    @Description(value="The server does not support the requested operation.")
    public static final long Bad_HistoryOperationUnsupported = 2154954752L;
    @Description(value="The defined timestamp to return was invalid.")
    public static final long Bad_InvalidTimestampArgument = 2159869952L;
    @Description(value="The server not does support writing the combination of value.")
    public static final long Bad_WriteNotSupported = 2155020288L;
    @Description(value="The value supplied for the attribute is not of the same type as the attribute's value.")
    public static final long Bad_TypeMismatch = 2155085824L;
    @Description(value="The method id does not refer to a method for the specified object.")
    public static final long Bad_MethodInvalid = 2155151360L;
    @Description(value="The client did not specify all of the input arguments for the method.")
    public static final long Bad_ArgumentsMissing = 2155216896L;
    @Description(value="The server has reached its maximum number of subscriptions.")
    public static final long Bad_TooManySubscriptions = 0x80770000L;
    @Description(value="The server has reached the maximum number of queued publish requests.")
    public static final long Bad_TooManyPublishRequests = 0x80780000L;
    @Description(value="There is no subscription available for this session.")
    public static final long Bad_NoSubscription = 2155413504L;
    @Description(value="The sequence number is unknown to the server.")
    public static final long Bad_SequenceNumberUnknown = 2155479040L;
    @Description(value="The requested notification message is no longer available.")
    public static final long Bad_MessageNotAvailable = 2155544576L;
    @Description(value="The Client of the current Session does not support one or more Profiles that are necessary for the Subscription.")
    public static final long Bad_InsufficientClientProfile = 2155610112L;
    @Description(value="The sub-state machine is not currently active.")
    public static final long Bad_StateNotActive = 2160001024L;
    @Description(value="The server cannot process the request because it is too busy.")
    public static final long Bad_TcpServerTooBusy = 2155675648L;
    @Description(value="The type of the message specified in the header invalid.")
    public static final long Bad_TcpMessageTypeInvalid = 2155741184L;
    @Description(value="The SecureChannelId and/or TokenId are not currently in use.")
    public static final long Bad_TcpSecureChannelUnknown = 2155806720L;
    @Description(value="The size of the message specified in the header is too large.")
    public static final long Bad_TcpMessageTooLarge = 0x80800000L;
    @Description(value="There are not enough resources to process the request.")
    public static final long Bad_TcpNotEnoughResources = 0x80810000L;
    @Description(value="An internal error occurred.")
    public static final long Bad_TcpInternalError = 0x80820000L;
    @Description(value="The Server does not recognize the QueryString specified.")
    public static final long Bad_TcpEndpointUrlInvalid = 0x80830000L;
    @Description(value="The request could not be sent because of a network interruption.")
    public static final long Bad_RequestInterrupted = 0x80840000L;
    @Description(value="Timeout occurred while processing the request.")
    public static final long Bad_RequestTimeout = 0x80850000L;
    @Description(value="The secure channel has been closed.")
    public static final long Bad_SecureChannelClosed = 0x80860000L;
    @Description(value="The token has expired or is not recognized.")
    public static final long Bad_SecureChannelTokenUnknown = 0x80870000L;
    @Description(value="The sequence number is not valid.")
    public static final long Bad_SequenceNumberInvalid = 0x80880000L;
    @Description(value="The applications do not have compatible protocol versions.")
    public static final long Bad_ProtocolVersionUnsupported = 2159935488L;
    @Description(value="There is a problem with the configuration that affects the usefulness of the value.")
    public static final long Bad_ConfigurationError = 0x80890000L;
    @Description(value="The variable should receive its value from another variable.")
    public static final long Bad_NotConnected = 0x808A0000L;
    @Description(value="There has been a failure in the device/data source that generates the value that has affected the value.")
    public static final long Bad_DeviceFailure = 0x808B0000L;
    @Description(value="There has been a failure in the sensor from which the value is derived by the device/data source.")
    public static final long Bad_SensorFailure = 0x808C0000L;
    @Description(value="The source of the data is not operational.")
    public static final long Bad_OutOfService = 0x808D0000L;
    @Description(value="The deadband filter is not valid.")
    public static final long Bad_DeadbandFilterInvalid = 0x808E0000L;
    @Description(value="Communication to the data source has failed. The variable value is the last value that had a good quality.")
    public static final long Uncertain_NoCommunicationLastUsableValue = 1083113472L;
    @Description(value="Whatever was updating this value has stopped doing so.")
    public static final long Uncertain_LastUsableValue = 0x40900000L;
    @Description(value="The value is an operational value that was manually overwritten.")
    public static final long Uncertain_SubstituteValue = 1083244544L;
    @Description(value="The value is an initial value for a variable that normally receives its value from another variable.")
    public static final long Uncertain_InitialValue = 1083310080L;
    @Description(value="The value is at one of the sensor limits.")
    public static final long Uncertain_SensorNotAccurate = 1083375616L;
    @Description(value="The value is outside of the range of values defined for this parameter.")
    public static final long Uncertain_EngineeringUnitsExceeded = 0x40940000L;
    @Description(value="The value is derived from multiple sources and has less than the required number of Good sources.")
    public static final long Uncertain_SubNormal = 1083506688L;
    @Description(value="The value has been overridden.")
    public static final long Good_LocalOverride = 0x960000L;
    @Description(value="This Condition refresh failed.")
    public static final long Bad_RefreshInProgress = 2157379584L;
    @Description(value="This condition has already been disabled.")
    public static final long Bad_ConditionAlreadyDisabled = 0x80980000L;
    @Description(value="This condition has already been enabled.")
    public static final long Bad_ConditionAlreadyEnabled = 0x80CC0000L;
    @Description(value="Property not available.")
    public static final long Bad_ConditionDisabled = 0x80990000L;
    @Description(value="The specified event id is not recognized.")
    public static final long Bad_EventIdUnknown = 2157576192L;
    @Description(value="The event cannot be acknowledged.")
    public static final long Bad_EventNotAcknowledgeable = 0x80BB0000L;
    @Description(value="The dialog condition is not active.")
    public static final long Bad_DialogNotActive = 2160918528L;
    @Description(value="The response is not valid for the dialog.")
    public static final long Bad_DialogResponseInvalid = 2160984064L;
    @Description(value="The condition branch has already been acknowledged.")
    public static final long Bad_ConditionBranchAlreadyAcked = 2161049600L;
    @Description(value="The condition branch has already been confirmed.")
    public static final long Bad_ConditionBranchAlreadyConfirmed = 0x80D00000L;
    @Description(value="The condition has already been shelved.")
    public static final long Bad_ConditionAlreadyShelved = 2161180672L;
    @Description(value="The condition is not currently shelved.")
    public static final long Bad_ConditionNotShelved = 2161246208L;
    @Description(value="The shelving time not within an acceptable range.")
    public static final long Bad_ShelvingTimeOutOfRange = 2161311744L;
    @Description(value="No data exists for the requested time range or event filter.")
    public static final long Bad_NoData = 2157641728L;
    @Description(value="No data found to provide upper or lower bound value.")
    public static final long Bad_BoundNotFound = 2161573888L;
    @Description(value="The server cannot retrieve a bound for the variable.")
    public static final long Bad_BoundNotSupported = 0x80D80000L;
    @Description(value="Data is missing due to collection started/stopped/lost.")
    public static final long Bad_DataLost = 2157772800L;
    @Description(value="Expected data is unavailable for the requested time range due to an un-mounted volume.")
    public static final long Bad_DataUnavailable = 2157838336L;
    @Description(value="The data or event was not successfully inserted because a matching entry exists.")
    public static final long Bad_EntryExists = 2157903872L;
    @Description(value="The data or event was not successfully updated because no matching entry exists.")
    public static final long Bad_NoEntryExists = 0x80A00000L;
    @Description(value="The client requested history using a timestamp format the server does not support (i.e requested ServerTimestamp when server only supports SourceTimestamp).")
    public static final long Bad_TimestampNotSupported = 2158034944L;
    @Description(value="The data or event was successfully inserted into the historical database.")
    public static final long Good_EntryInserted = 0xA20000L;
    @Description(value="The data or event field was successfully replaced in the historical database.")
    public static final long Good_EntryReplaced = 0xA30000L;
    @Description(value="The value is derived from multiple values and has less than the required number of Good values.")
    public static final long Uncertain_DataSubNormal = 0x40A40000L;
    @Description(value="No data exists for the requested time range or event filter.")
    public static final long Good_NoData = 0xA50000L;
    @Description(value="The data or event field was successfully replaced in the historical database.")
    public static final long Good_MoreData = 0xA60000L;
    @Description(value="The requested number of Aggregates does not match the requested number of NodeIds.")
    public static final long Bad_AggregateListMismatch = 2161377280L;
    @Description(value="The requested Aggregate is not support by the server.")
    public static final long Bad_AggregateNotSupported = 2161442816L;
    @Description(value="The aggregate value could not be derived due to invalid data inputs.")
    public static final long Bad_AggregateInvalidInputs = 2161508352L;
    @Description(value="The aggregate configuration is not valid for specified node.")
    public static final long Bad_AggregateConfigurationRejected = 2161770496L;
    @Description(value="The request pecifies fields which are not valid for the EventType or cannot be saved by the historian.")
    public static final long Good_DataIgnored = 0xD90000L;
    @Description(value="The request was rejected by the server because it did not meet the criteria set by the server.")
    public static final long Bad_RequestNotAllowed = 2162425856L;
    @Description(value="The value does not come from the real source and has been edited by the server.")
    public static final long Good_Edited = 0xDC0000L;
    @Description(value="There was an error in execution of these post-actions.")
    public static final long Good_PostActionFailed = 0xDD0000L;
    @Description(value="The related EngineeringUnit has been changed but the Variable Value is still provided based on the previous unit.")
    public static final long Uncertain_DominantValueChanged = 1088290816L;
    @Description(value="A dependent value has been changed but the change has not been applied to the device.")
    public static final long Good_DependentValueChanged = 0xE00000L;
    @Description(value="The related EngineeringUnit has been changed but this change has not been applied to the device. The Variable Value is still dependent on the previous unit but its status is currently Bad.")
    public static final long Bad_DominantValueChanged = 2162229248L;
    @Description(value="A dependent value has been changed but the change has not been applied to the device. The quality of the dominant variable is uncertain.")
    public static final long Uncertain_DependentValueChanged = 1088552960L;
    @Description(value="A dependent value has been changed but the change has not been applied to the device. The quality of the dominant variable is Bad.")
    public static final long Bad_DependentValueChanged = 2162360320L;
    @Description(value="The communication layer has raised an event.")
    public static final long Good_CommunicationEvent = 0xA70000L;
    @Description(value="The system is shutting down.")
    public static final long Good_ShutdownEvent = 0xA80000L;
    @Description(value="The operation is not finished and needs to be called again.")
    public static final long Good_CallAgain = 0xA90000L;
    @Description(value="A non-critical timeout occurred.")
    public static final long Good_NonCriticalTimeout = 0xAA0000L;
    @Description(value="One or more arguments are invalid.")
    public static final long Bad_InvalidArgument = 2158690304L;
    @Description(value="Could not establish a network connection to remote server.")
    public static final long Bad_ConnectionRejected = 2158755840L;
    @Description(value="The server has disconnected from the client.")
    public static final long Bad_Disconnect = 2158821376L;
    @Description(value="The network connection has been closed.")
    public static final long Bad_ConnectionClosed = 2158886912L;
    @Description(value="The operation cannot be completed because the object is closed.")
    public static final long Bad_InvalidState = 2158952448L;
    @Description(value="Cannot move beyond end of the stream.")
    public static final long Bad_EndOfStream = 0x80B00000L;
    @Description(value="No data is currently available for reading from a non-blocking stream.")
    public static final long Bad_NoDataAvailable = 2159083520L;
    @Description(value="The asynchronous operation is waiting for a response.")
    public static final long Bad_WaitingForResponse = 2159149056L;
    @Description(value="The asynchronous operation was abandoned by the caller.")
    public static final long Bad_OperationAbandoned = 2159214592L;
    @Description(value="The stream did not return all data requested (possibly because it is a non-blocking stream).")
    public static final long Bad_ExpectedStreamToBlock = 2159280128L;
    @Description(value="Non blocking behaviour is required and the operation would block.")
    public static final long Bad_WouldBlock = 2159345664L;
    @Description(value="A value had an invalid syntax.")
    public static final long Bad_SyntaxError = 2159411200L;
    @Description(value="The operation could not be finished because all available connections are in use.")
    public static final long Bad_MaxConnectionsReached = 2159476736L;

    public static Optional<String[]> lookup(long code) {
        String[] desc = (String[])DESCRIPTIONS.get((Object)(code & 0xFFFFFFFFFFFF0000L));
        return Optional.ofNullable(desc);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Field f : StatusCodes.class.getFields()) {
            if (!f.isAnnotationPresent(Description.class)) continue;
            try {
                long code = f.getLong(null);
                String name = f.getName();
                String desc = f.getAnnotation(Description.class).value();
                builder.put((Object)code, (Object)new String[]{name, desc});
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        builder.put((Object)StatusCode.GOOD.getValue(), (Object)new String[]{"Good", "Good; unspecified."});
        builder.put((Object)StatusCode.BAD.getValue(), (Object)new String[]{"Bad", "Bad; unspecified."});
        DESCRIPTIONS = builder.build();
    }
}

