/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.utils.fileTimeIndexCache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import org.apache.iotdb.db.utils.writelog.ILogWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTimeIndexCacheWriter
implements ILogWriter {
    private static final Logger logger = LoggerFactory.getLogger(FileTimeIndexCacheWriter.class);
    private final File logFile;
    private FileOutputStream fileOutputStream;
    private FileChannel channel;
    private final boolean forceEachWrite;

    public FileTimeIndexCacheWriter(File logFile, boolean forceEachWrite) throws FileNotFoundException {
        this.logFile = logFile;
        this.forceEachWrite = forceEachWrite;
        this.fileOutputStream = new FileOutputStream(logFile, true);
        this.channel = this.fileOutputStream.getChannel();
    }

    @Override
    public void write(ByteBuffer logBuffer) throws IOException {
        try {
            if (!this.logFile.exists()) {
                return;
            }
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.write(logBuffer);
                if (this.forceEachWrite) {
                    this.channel.force(true);
                }
            }
        }
        catch (ClosedChannelException ignored) {
            logger.warn("someone interrupt current thread, so no need to do write for io safety");
        }
    }

    @Override
    public void force() throws IOException {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.force(true);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            if (this.channel.isOpen()) {
                this.channel.force(false);
            }
            this.fileOutputStream.close();
            this.fileOutputStream = null;
            this.channel.close();
            this.channel = null;
        }
    }

    public void clearFile() throws IOException {
        this.close();
        Files.delete(this.logFile.toPath());
        if (!this.logFile.createNewFile()) {
            logger.warn("Partition log file has existed\uff0cfilePath:{}", (Object)this.logFile.getAbsolutePath());
        }
        this.fileOutputStream = new FileOutputStream(this.logFile, true);
        this.channel = this.fileOutputStream.getChannel();
    }

    public String toString() {
        return "LogWriter{logFile=" + this.logFile + '}';
    }

    public File getLogFile() {
        return this.logFile;
    }
}

