/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.subscriptions;

import io.moquette.broker.subscriptions.SubscriptionIdentifier;
import io.moquette.broker.subscriptions.Topic;
import io.netty.handler.codec.mqtt.MqttSubscriptionOption;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public final class Subscription
implements Serializable,
Comparable<Subscription> {
    private static final long serialVersionUID = -3383457629635732794L;
    private final MqttSubscriptionOption option;
    final String clientId;
    final Topic topicFilter;
    final String shareName;
    private final Optional<SubscriptionIdentifier> subscriptionId;

    public Subscription(String clientId, Topic topicFilter, MqttSubscriptionOption options) {
        this(clientId, topicFilter, options, "");
    }

    public Subscription(String clientId, Topic topicFilter, MqttSubscriptionOption options, SubscriptionIdentifier subscriptionId) {
        this(clientId, topicFilter, options, "", subscriptionId);
    }

    public Subscription(String clientId, Topic topicFilter, MqttSubscriptionOption options, String shareName) {
        this(clientId, topicFilter, options, shareName, null);
    }

    public Subscription(String clientId, Topic topicFilter, MqttSubscriptionOption options, String shareName, SubscriptionIdentifier subscriptionId) {
        this.clientId = clientId;
        this.topicFilter = topicFilter;
        this.shareName = shareName;
        this.subscriptionId = Optional.ofNullable(subscriptionId);
        this.option = options;
    }

    public Subscription(Subscription orig) {
        this.clientId = orig.clientId;
        this.topicFilter = orig.topicFilter;
        this.shareName = orig.shareName;
        this.subscriptionId = orig.subscriptionId;
        this.option = orig.option;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Topic getTopicFilter() {
        return this.topicFilter;
    }

    public boolean qosLessThan(Subscription sub) {
        return this.option.qos().value() < sub.option.qos().value();
    }

    public boolean hasSubscriptionIdentifier() {
        return this.subscriptionId.isPresent();
    }

    public SubscriptionIdentifier getSubscriptionIdentifier() {
        return this.subscriptionId.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription that = (Subscription)o;
        return Objects.equals(this.clientId, that.clientId) && Objects.equals(this.shareName, that.shareName) && Objects.equals(this.topicFilter, that.topicFilter);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.shareName, this.topicFilter);
    }

    public String toString() {
        return String.format("[filter:%s, clientID: %s, options: %s - shareName: %s]", this.topicFilter, this.clientId, this.option, this.shareName);
    }

    public Subscription clone() {
        try {
            return (Subscription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public int compareTo(Subscription o) {
        int compare = this.clientId.compareTo(o.clientId);
        if (compare != 0) {
            return compare;
        }
        compare = this.shareName.compareTo(o.shareName);
        if (compare != 0) {
            return compare;
        }
        return this.topicFilter.compareTo(o.topicFilter);
    }

    public String clientAndShareName() {
        return this.clientId + (this.shareName.isEmpty() ? "" : "-" + this.shareName);
    }

    public boolean hasShareName() {
        return this.shareName != null;
    }

    public String getShareName() {
        return this.shareName;
    }

    public MqttSubscriptionOption option() {
        return this.option;
    }
}

