/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.snapshot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotLogAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotLogAnalyzer.class);
    private final File snapshotLogFile;
    private final BufferedReader reader;
    private String snapshotId;
    private boolean complete;
    private Set<String> fileInfoSet = new HashSet<String>();

    public SnapshotLogAnalyzer(File snapshotLogFile) throws IOException {
        this.snapshotLogFile = snapshotLogFile;
        this.reader = new BufferedReader(new FileReader(snapshotLogFile));
        this.analyze();
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            LOGGER.error("Exception occurs when closing log analyzer", (Throwable)e);
        }
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public int getTotalFileCountInSnapshot() throws IOException {
        return this.fileInfoSet.size();
    }

    public Set<String> getFileInfoSet() {
        return this.fileInfoSet;
    }

    private void analyze() throws IOException {
        try {
            String line;
            this.snapshotId = this.reader.readLine();
            while ((line = this.reader.readLine()) != null && !line.equals("END")) {
                this.fileInfoSet.add(line);
            }
            this.complete = line != null;
        }
        finally {
            this.reader.close();
        }
    }

    public boolean isSnapshotComplete() throws IOException {
        return this.complete;
    }
}

