/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.ObjectName;
import org.apache.ratis.protocol.RaftId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServerMXBean;
import org.apache.ratis.server.impl.LeaderStateImpl;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.util.JmxRegister;

class RaftServerJmxAdapter
extends JmxRegister
implements RaftServerMXBean {
    private final RaftServerImpl server;

    static boolean registerMBean(String id, String groupId, RaftServerMXBean mBean, JmxRegister jmx) {
        String prefix = "Ratis:service=RaftServer,group=" + groupId + ",id=";
        String registered = jmx.register((Object)mBean, Arrays.asList(() -> prefix + id, () -> prefix + ObjectName.quote(id)));
        return registered != null;
    }

    RaftServerJmxAdapter(RaftServerImpl server) {
        this.server = server;
    }

    boolean registerMBean() {
        return RaftServerJmxAdapter.registerMBean(this.getId(), this.getGroupId(), this, this);
    }

    public String getId() {
        return this.server.getId().toString();
    }

    public String getLeaderId() {
        RaftPeerId leaderId = this.server.getState().getLeaderId();
        if (leaderId != null) {
            return leaderId.toString();
        }
        return null;
    }

    public long getCurrentTerm() {
        return this.server.getState().getCurrentTerm();
    }

    public String getGroupId() {
        return this.server.getMemberId().getGroupId().toString();
    }

    public String getRole() {
        return this.server.getRole().toString();
    }

    public List<String> getFollowers() {
        return this.server.getRole().getLeaderState().map(LeaderStateImpl::getFollowers).orElseGet(Stream::empty).map(RaftPeer::toString).collect(Collectors.toList());
    }

    public List<String> getGroups() {
        return this.server.getRaftServer().getGroupIds().stream().map(RaftId::toString).collect(Collectors.toList());
    }
}

