/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import org.apache.tsfile.encoding.encoder.GorillaEncoderV2;
import org.apache.tsfile.file.metadata.enums.TSEncoding;

public class IntChimpEncoder
extends GorillaEncoderV2 {
    private static final int PREVIOUS_VALUES = 64;
    private static final int PREVIOUS_VALUES_LOG2 = (int)(Math.log(64.0) / Math.log(2.0));
    private static final int THRESHOLD = 5 + PREVIOUS_VALUES_LOG2;
    private static final int SET_LSB = (int)Math.pow(2.0, (double)THRESHOLD + 1.0) - 1;
    private static final int CASE_ZERO_METADATA_LENGTH = PREVIOUS_VALUES_LOG2 + 2;
    private static final int CASE_ONE_METADATA_LENGTH = PREVIOUS_VALUES_LOG2 + 10;
    protected static final short[] LEADING_REPRESENTATION = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    protected static final short[] LEADING_ROUND = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 12, 12, 12, 12, 16, 16, 18, 18, 20, 20, 22, 22, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24};
    private int[] storedValues;
    private int[] indices;
    private int index = 0;
    private int current = 0;
    private static final int ONE_ITEM_MAX_SIZE = 6;

    public IntChimpEncoder() {
        this.setType(TSEncoding.CHIMP);
        this.indices = new int[(int)Math.pow(2.0, (double)THRESHOLD + 1.0)];
        this.storedValues = new int[64];
    }

    @Override
    public final int getOneItemMaxSize() {
        return 6;
    }

    @Override
    protected void reset() {
        super.reset();
        this.current = 0;
        this.index = 0;
        this.indices = new int[(int)Math.pow(2.0, (double)THRESHOLD + 1.0)];
        this.storedValues = new int[64];
    }

    @Override
    public void flush(ByteArrayOutputStream out) {
        this.encode(Integer.MIN_VALUE, out);
        this.bitsLeft = 0;
        this.flipByte(out);
        this.reset();
    }

    @Override
    public final void encode(int value, ByteArrayOutputStream out) {
        if (this.firstValueWasWritten) {
            this.compressValue(value, out);
        } else {
            this.writeFirst(value, out);
            this.firstValueWasWritten = true;
        }
    }

    private void writeFirst(int value, ByteArrayOutputStream out) {
        this.storedValues[this.current] = value;
        this.writeBits(value, 32, out);
        this.indices[value & IntChimpEncoder.SET_LSB] = this.index;
    }

    private void compressValue(int value, ByteArrayOutputStream out) {
        int xor;
        int previousIndex;
        int key = value & SET_LSB;
        int trailingZeros = 0;
        int currIndex = this.indices[key];
        if (this.index - currIndex < 64) {
            int tempXor = value ^ this.storedValues[currIndex % 64];
            trailingZeros = Integer.numberOfTrailingZeros(tempXor);
            if (trailingZeros > THRESHOLD) {
                previousIndex = currIndex % 64;
                xor = tempXor;
            } else {
                previousIndex = this.index % 64;
                xor = this.storedValues[previousIndex] ^ value;
            }
        } else {
            previousIndex = this.index % 64;
            xor = this.storedValues[previousIndex] ^ value;
        }
        if (xor == 0) {
            this.writeBits(previousIndex, CASE_ZERO_METADATA_LENGTH, out);
            this.storedLeadingZeros = 33;
        } else {
            int leadingZeros = LEADING_ROUND[Integer.numberOfLeadingZeros(xor)];
            if (trailingZeros > THRESHOLD) {
                int significantBits = 32 - leadingZeros - trailingZeros;
                this.writeBits(256L * (long)(64 + previousIndex) + 32L * (long)LEADING_REPRESENTATION[leadingZeros] + (long)significantBits, CASE_ONE_METADATA_LENGTH, out);
                this.writeBits(xor >>> trailingZeros, significantBits, out);
                this.storedLeadingZeros = 33;
            } else if (leadingZeros == this.storedLeadingZeros) {
                this.writeBit(out);
                this.skipBit(out);
                int significantBits = 32 - leadingZeros;
                this.writeBits(xor, significantBits, out);
            } else {
                this.storedLeadingZeros = leadingZeros;
                int significantBits = 32 - leadingZeros;
                this.writeBits(24L + (long)LEADING_REPRESENTATION[leadingZeros], 5, out);
                this.writeBits(xor, significantBits, out);
            }
        }
        this.current = (this.current + 1) % 64;
        this.storedValues[this.current] = value;
        this.indices[key] = ++this.index;
    }
}

