/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.exts.concurrent;

import com.sksamuel.exts.Logging;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.function.IntUnaryOperator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005Q3A\u0001C\u0005\u0001%!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0004\"\u0002\u001b\u0001\t\u0003)\u0004\"B\u001e\u0001\t\u0003a\u0004\"\u0002!\u0001\t\u0003a\u0004\"B!\u0001\t\u0003\u0011%!\u0003+ie>$H\u000f\\3s\u0015\tQ1\"\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001D\u0007\u0002\t\u0015DHo\u001d\u0006\u0003\u001d=\t\u0001b]6tC6,X\r\u001c\u0006\u0002!\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aE\r\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\tQ2$D\u0001\f\u0013\ta2BA\u0004M_\u001e<\u0017N\\4\u0002\u000f\r|WO\u001c;feB\u0011qdJ\u0007\u0002A)\u0011\u0011EI\u0001\u0007CR|W.[2\u000b\u0005)\u0019#B\u0001\u0013&\u0003\u0011)H/\u001b7\u000b\u0003\u0019\nAA[1wC&\u0011\u0001\u0006\t\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002\t1|7m\u001b\t\u0003W9j\u0011\u0001\f\u0006\u0003[\t\nQ\u0001\\8dWNL!a\f\u0017\u0003\t1{7m[\u0001\fSN,\u00050Z2vi&tw\r\u0005\u0002,e%\u00111\u0007\f\u0002\n\u0007>tG-\u001b;j_:\fa\u0001P5oSRtD\u0003\u0002\u001c9si\u0002\"a\u000e\u0001\u000e\u0003%AQ!\b\u0003A\u0002yAQ!\u000b\u0003A\u0002)BQ\u0001\r\u0003A\u0002E\nA\u0001Z8x]R\tQ\b\u0005\u0002\u0015}%\u0011q(\u0006\u0002\u0005+:LG/\u0001\u0002va\u0006)\u0011\r\u001d9msV\u00111I\u0012\u000b\u0003\t>\u0003\"!\u0012$\r\u0001\u0011)qi\u0002b\u0001\u0011\n\tA+\u0005\u0002J\u0019B\u0011ACS\u0005\u0003\u0017V\u0011qAT8uQ&tw\r\u0005\u0002\u0015\u001b&\u0011a*\u0006\u0002\u0004\u0003:L\bB\u0002)\b\t\u0003\u0007\u0011+\u0001\u0002g]B\u0019AC\u0015#\n\u0005M+\"\u0001\u0003\u001fcs:\fW.\u001a ")
public class Throttler
implements Logging {
    private final AtomicInteger counter;
    private final Lock lock;
    private final Condition isExecuting;
    private Logger logger;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$sksamuel$exts$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void down() {
        block0: {
            if (this.counter.updateAndGet(new IntUnaryOperator(null){

                public IntUnaryOperator compose(IntUnaryOperator x$1) {
                    return IntUnaryOperator.super.compose(x$1);
                }

                public IntUnaryOperator andThen(IntUnaryOperator x$1) {
                    return IntUnaryOperator.super.andThen(x$1);
                }

                public int applyAsInt(int operand) {
                    return operand - 1;
                }
            }) != 0) break block0;
            this.lock.lock();
            this.isExecuting.signalAll();
            this.lock.unlock();
        }
    }

    public void up() {
        this.counter.updateAndGet(new IntUnaryOperator(null){

            public IntUnaryOperator compose(IntUnaryOperator x$1) {
                return IntUnaryOperator.super.compose(x$1);
            }

            public IntUnaryOperator andThen(IntUnaryOperator x$1) {
                return IntUnaryOperator.super.andThen(x$1);
            }

            public int applyAsInt(int operand) {
                return operand + 1;
            }
        });
    }

    public <T> T apply(Function0<T> fn) {
        while (this.counter.get() > 0) {
            try {
                this.logger().debug("Throttling...");
                this.lock.lock();
                this.isExecuting.await();
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                Option option;
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof InterruptedException) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.logger().error("Error while throttling", e);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
        }
        return (T)fn.apply();
    }

    public Throttler(AtomicInteger counter, Lock lock, Condition isExecuting) {
        this.counter = counter;
        this.lock = lock;
        this.isExecuting = isExecuting;
        Logging.$init$(this);
        Statics.releaseFence();
    }
}

