/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum HealthCheckState {
    AVAILABLE("available"),
    DEGRADED("degraded"),
    UNAVAILABLE("unavailable"),
    NO_LOCAL_SERVERS("no-local-servers"),
    NO_REMOTE_SERVERS("no-remote-servers");

    @NotNull
    private final String name;

    private HealthCheckState(String name) {
        this.name = name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public static HealthCheckState forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "available": {
                return AVAILABLE;
            }
            case "degraded": {
                return DEGRADED;
            }
            case "unavailable": {
                return UNAVAILABLE;
            }
            case "nolocalservers": 
            case "no-local-servers": 
            case "no_local_servers": {
                return NO_LOCAL_SERVERS;
            }
            case "noremoteservers": 
            case "no-remote-servers": 
            case "no_remote_servers": {
                return NO_REMOTE_SERVERS;
            }
        }
        return null;
    }

    @NotNull
    public String toString() {
        return this.name;
    }
}

