/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jgroups.util.Util;

public class Delayer<T> {
    protected long timeout = 2000L;
    protected Map<T, Entry> map = new ConcurrentHashMap<T, Entry>();

    public Delayer(long timeout) {
        this.timeout = timeout;
    }

    public long timeout() {
        return this.timeout;
    }

    public Delayer<T> timeout(long t) {
        this.timeout = t;
        return this;
    }

    public int size() {
        return this.map.size();
    }

    public int done() {
        return (int)this.map.values().stream().filter(Entry::done).count();
    }

    public Delayer<T> add(T key, Predicate<T> pred, Consumer<Boolean> action) {
        this.map.computeIfAbsent(key, k -> new Entry(k, pred, action).run());
        return this;
    }

    public Delayer<T> clear() {
        this.map.values().forEach(e -> {
            if (e.f != null) {
                e.f.cancel(true);
            }
        });
        this.map.clear();
        return this;
    }

    public String toString() {
        return String.format("%d entries (%d done)", this.size(), this.done());
    }

    protected class Entry {
        protected T key;
        protected Predicate<T> pred;
        protected Consumer<Boolean> action;
        protected CompletableFuture<Void> f;

        public Entry(T key, Predicate<T> pred, Consumer<Boolean> action) {
            this.key = key;
            this.pred = pred;
            this.action = action;
        }

        public boolean done() {
            return this.f.isDone();
        }

        public Entry run() {
            this.f = CompletableFuture.supplyAsync(() -> Util.waitUntilTrue(Delayer.this.timeout, Delayer.this.timeout / 10L, () -> this.pred.test(this.key))).thenAccept(success -> {
                try {
                    this.action.accept((Boolean)success);
                }
                finally {
                    Delayer.this.map.remove(this.key);
                }
            });
            return this;
        }

        public String toString() {
            return String.format("%s: done=%b", this.key, this.done());
        }
    }
}

