/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class NodeStateEvent {
    public final NodeState oldState;
    public final NodeState newState;
    public final DefaultNode node;

    public static NodeStateEvent changed(NodeState oldState, NodeState newState, DefaultNode node) {
        Preconditions.checkNotNull((Object)((Object)oldState));
        Preconditions.checkNotNull((Object)((Object)newState));
        return new NodeStateEvent(oldState, newState, node);
    }

    public static NodeStateEvent added(DefaultNode node) {
        return new NodeStateEvent(null, NodeState.UNKNOWN, node);
    }

    public static NodeStateEvent removed(DefaultNode node) {
        return new NodeStateEvent(null, null, node);
    }

    private NodeStateEvent(NodeState oldState, NodeState newState, DefaultNode node) {
        this.node = node;
        this.oldState = oldState;
        this.newState = newState;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof NodeStateEvent) {
            NodeStateEvent that = (NodeStateEvent)other;
            return this.oldState == that.oldState && this.newState == that.newState && Objects.equals(this.node, that.node);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.oldState, this.newState, this.node});
    }

    public String toString() {
        return "NodeStateEvent(" + (Object)((Object)this.oldState) + "=>" + (Object)((Object)this.newState) + ", " + this.node + ")";
    }
}

