/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http;

import java.net.http.HttpClient;
import java.time.Duration;
import org.apache.jena.http.RegistryHttpClient;
import org.apache.jena.http.sys.RegistryRequestModifier;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.RDFFormat;

public class HttpEnv {
    public static final RDFFormat defaultTriplesFormat = RDFFormat.TURTLE_BLOCKS;
    public static final RDFFormat defaultQuadsFormat = RDFFormat.TRIG_BLOCKS;
    public static int urlLimit = 2048;
    private static HttpClient httpClient = HttpEnv.buildDftHttpClient();
    public static final String UserAgent = ARQ.VERSION.contains("devel") ? "ApacheJena" : "ApacheJena/" + ARQ.VERSION;

    public static HttpClient getDftHttpClient() {
        return httpClient;
    }

    public static void setDftHttpClient(HttpClient dftHttpClient) {
        httpClient = dftHttpClient;
    }

    public static HttpClient getHttpClient(String url, HttpClient specificHttpClient) {
        if (specificHttpClient != null) {
            return specificHttpClient;
        }
        HttpClient requestHttpClient = (HttpClient)RegistryHttpClient.get().find(url);
        if (requestHttpClient == null) {
            requestHttpClient = HttpEnv.getDftHttpClient();
        }
        return requestHttpClient;
    }

    private static HttpClient buildDftHttpClient() {
        return HttpEnv.httpClientBuilder().build();
    }

    public static HttpClient.Builder httpClientBuilder() {
        return HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).followRedirects(HttpClient.Redirect.ALWAYS);
    }

    public static void reset() {
        RegistryHttpClient.get().clear();
        RegistryRequestModifier.get().clear();
    }
}

