/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;

public class MatchNoDocsQuery
extends Query {
    private final String reason;

    public MatchNoDocsQuery() {
        this("");
    }

    public MatchNoDocsQuery(String reason) {
        this.reason = reason;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new Weight(this){

            @Override
            public Explanation explain(LeafReaderContext context2, int doc) throws IOException {
                return Explanation.noMatch(MatchNoDocsQuery.this.reason, new Explanation[0]);
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context2) throws IOException {
                return null;
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }

            @Override
            public int count(LeafReaderContext context2) {
                return 0;
            }
        };
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    @Override
    public String toString(String field) {
        return "MatchNoDocsQuery(\"" + this.reason + "\")";
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o);
    }

    @Override
    public int hashCode() {
        return this.classHash();
    }
}

