/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock;

import java.util.Map;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.lang.StateEnum;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.rest.util.UrlPath;
import org.apache.juneau.rest.util.UrlPathMatcher;

class MockPathResolver {
    private String uri;
    private String target;
    private String contextPath;
    private String servletPath;
    private String remainder;
    private String error;

    private static String fixSegment(String s, Map<String, Object> pathVars) {
        if (((String)(s = StringUtils.formatNamed(StringUtils.emptyIfNull((String)s), pathVars))).isEmpty() || ((String)s).equals("/")) {
            return "";
        }
        if (((String)(s = StringUtils.trimTrailingSlashes((String)s))).charAt(0) != '/') {
            s = "/" + (String)s;
        }
        return s;
    }

    public MockPathResolver(String target, String contextPath, String servletPath, String pathToResolve, Map<String, Object> pathVars) {
        try {
            this.init(target, contextPath, servletPath, pathToResolve, pathVars);
        }
        catch (Exception e) {
            this.error = ThrowableUtils.lm(e);
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getError() {
        return this.error;
    }

    public String getRemainder() {
        return this.remainder;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getTarget() {
        return this.target;
    }

    public String getURI() {
        return this.uri;
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a("contextPath", this.contextPath).a("error", this.error).a("remainder", this.remainder).a("servletPath", this.servletPath).a("target", this.target).a("uri", this.uri);
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    private void init(String target, String contextPath, String servletPath, String pathToResolve, Map<String, Object> pathVars) {
        UrlPathMatcher p;
        UrlPathMatcher p2;
        if ((target = StringUtils.trimTrailingSlashes(StringUtils.emptyIfNull(target))).isEmpty()) {
            target = "http://localhost";
        }
        contextPath = MockPathResolver.fixSegment(contextPath, pathVars);
        servletPath = MockPathResolver.fixSegment(servletPath, pathVars);
        if (!(pathToResolve = StringUtils.emptyIfNull(pathToResolve)).startsWith("http://") && !pathToResolve.startsWith("https://")) {
            pathToResolve = MockPathResolver.fixSegment(pathToResolve, CollectionUtils.mape());
            this.uri = target + contextPath + servletPath + pathToResolve;
            this.target = target;
            this.contextPath = contextPath;
            this.servletPath = servletPath;
            this.remainder = pathToResolve;
            return;
        }
        this.uri = pathToResolve;
        StateEnum state = StateEnum.S3;
        int cpSegments = StringUtils.countChars(contextPath, '/');
        int spSegments = StringUtils.countChars(servletPath, '/');
        this.contextPath = "";
        this.servletPath = "";
        this.remainder = "";
        int mark = 0;
        for (int i = this.uri.indexOf("://") + 3; i < this.uri.length(); ++i) {
            char c = this.uri.charAt(i);
            if (state == StateEnum.S3) {
                if (c == '/') break;
                state = StateEnum.S4;
                continue;
            }
            if (state == StateEnum.S4) {
                if (c != '/') continue;
                this.target = this.uri.substring(0, i);
                state = StateEnum.S5;
                if (contextPath.isEmpty()) {
                    state = StateEnum.S6;
                    if (servletPath.isEmpty()) {
                        state = StateEnum.S7;
                    }
                }
                mark = i;
                continue;
            }
            if (state == StateEnum.S5) {
                if (c != '/' || --cpSegments != 0) continue;
                this.contextPath = this.uri.substring(mark, i);
                mark = i;
                state = StateEnum.S6;
                if (!servletPath.isEmpty()) continue;
                state = StateEnum.S7;
                continue;
            }
            if (state != StateEnum.S6 || c != '/' || --spSegments != 0) continue;
            this.servletPath = this.uri.substring(mark, i);
            mark = i;
            state = StateEnum.S7;
        }
        if (state == StateEnum.S4) {
            this.target = this.uri;
        } else if (state == StateEnum.S5) {
            this.contextPath = this.uri.substring(mark);
        } else if (state == StateEnum.S6) {
            this.servletPath = this.uri.substring(mark);
        } else if (state == StateEnum.S7) {
            this.remainder = this.uri.substring(mark);
        } else {
            throw ThrowableUtils.rex("Invalid URI pattern encountered:  {0}", this.uri);
        }
        if (!contextPath.isEmpty() && (p2 = UrlPathMatcher.of(contextPath)).match(UrlPath.of(this.contextPath)) == null) {
            throw ThrowableUtils.rex("Context path [{0}] not found in URI:  {1}", contextPath, this.uri);
        }
        if (!servletPath.isEmpty() && (p = UrlPathMatcher.of(servletPath)).match(UrlPath.of(this.servletPath)) == null) {
            throw ThrowableUtils.rex("Servlet path [{0}] not found in URI:  {1}", servletPath, this.uri);
        }
    }
}

