/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.net.URI;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.header.BasicHeader;

public class BasicUriHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final URI value;
    private final Supplier<URI> supplier;

    public static BasicUriHeader of(String name, String value) {
        return value == null ? null : new BasicUriHeader(name, value);
    }

    public static BasicUriHeader of(String name, Supplier<URI> value) {
        return value == null ? null : new BasicUriHeader(name, value);
    }

    public static BasicUriHeader of(String name, URI value) {
        return value == null ? null : new BasicUriHeader(name, value);
    }

    public BasicUriHeader(String name, String value) {
        super(name, value);
        this.value = Utils.e((CharSequence)value) ? null : URI.create(value);
        this.supplier = null;
    }

    public BasicUriHeader(String name, Supplier<URI> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    public BasicUriHeader(String name, URI value) {
        super(name, Utils.s((Object)value));
        this.value = value;
        this.supplier = null;
    }

    public Optional<URI> asUri() {
        return Utils.opt((Object)this.value());
    }

    @Override
    public String getValue() {
        return Utils.s((Object)this.value());
    }

    public URI orElse(URI other) {
        URI x = this.value();
        return Utils.nn((Object)x) ? x : other;
    }

    public URI toUri() {
        return this.value();
    }

    private URI value() {
        if (Utils.nn(this.supplier)) {
            return this.supplier.get();
        }
        return this.value;
    }
}

