/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.resources;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.bean.LinkString;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.config.Config;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlConfig;
import org.apache.juneau.html.annotation.HtmlDocConfig;
import org.apache.juneau.html.annotation.HtmlFormat;
import org.apache.juneau.http.annotation.Content;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.response.Forbidden;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.http.response.MethodNotAllowed;
import org.apache.juneau.http.response.NotFound;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestDelete;
import org.apache.juneau.rest.annotation.RestGet;
import org.apache.juneau.rest.annotation.RestOp;
import org.apache.juneau.rest.annotation.RestPut;
import org.apache.juneau.rest.beans.SeeOtherRoot;
import org.apache.juneau.rest.servlet.BasicRestServlet;

@Rest(title={"File System Explorer"}, messages="nls/DirectoryResource", allowedMethodParams="*")
@HtmlDocConfig(navlinks={"up: request:/..", "api: servlet:/api"})
@HtmlConfig(uriAnchorText="PROPERTY_NAME")
public class DirectoryResource
extends BasicRestServlet {
    private static final long serialVersionUID = 1L;
    private static final String PREFIX = "DirectoryResource.";
    public static final String DIRECTORY_RESOURCE_rootDir = "DirectoryResource.rootDir.s";
    public static final String DIRECTORY_RESOURCE_allowViews = "DirectoryResource.allowViews.b";
    public static final String DIRECTORY_RESOURCE_allowDeletes = "DirectoryResource.allowDeletes.b";
    public static final String DIRECTORY_RESOURCE_allowUploads = "DirectoryResource.allowUploads.b";
    private final File rootDir;
    final boolean allowDeletes;
    final boolean allowUploads;
    final boolean allowViews;

    public DirectoryResource(Config c) throws Exception {
        this.rootDir = new File(c.get(DIRECTORY_RESOURCE_rootDir).orElse("."));
        this.allowViews = c.get(DIRECTORY_RESOURCE_allowViews).asBoolean().orElse(false);
        this.allowDeletes = c.get(DIRECTORY_RESOURCE_allowDeletes).asBoolean().orElse(false);
        this.allowUploads = c.get(DIRECTORY_RESOURCE_allowUploads).asBoolean().orElse(false);
    }

    @RestDelete(path={"/*"}, summary="Delete file", description={"Delete a file on the file system."})
    public RedirectToRoot deleteFile(@Path(value="/*") String path) throws MethodNotAllowed {
        this.deleteFile(this.getFile(path));
        return new RedirectToRoot();
    }

    @RestOp(method="DOWNLOAD", path={"/*"}, summary="Download file", description={"Download the contents of a file.\nContent-Type is set to 'application/octet-stream'."})
    public FileContents downloadFile(RestResponse res, @Path(value="/*") String path) throws NotFound, MethodNotAllowed {
        if (!this.allowViews) {
            throw new MethodNotAllowed("DOWNLOAD not enabled", new Object[0]);
        }
        res.setContentType("application/octet-stream");
        try {
            return new FileContents(this.getFile(path));
        }
        catch (FileNotFoundException e) {
            throw new NotFound("File not found", new Object[0]);
        }
    }

    @RestGet(path={"/*"}, summary="View information on file or directory", description={"Returns information about the specified file or directory."})
    @HtmlDocConfig(nav={"<h5>Folder:  $RA{fullPath}</h5>"})
    public FileResource getFile(RestRequest req, @Path(value="/*") String path) throws NotFound, Exception {
        File dir = this.getFile(path);
        req.setAttribute("fullPath", dir.getAbsolutePath());
        return new FileResource(dir, path, true);
    }

    @RestPut(path={"/*"}, summary="Add or replace file", description={"Add or overwrite a file on the file system."})
    public RedirectToRoot updateFile(@Content @Schema(type="string", format="binary") InputStream is, @Path(value="/*") String path) throws InternalServerError {
        if (!this.allowUploads) {
            throw new MethodNotAllowed("PUT not enabled", new Object[0]);
        }
        File f = this.getFile(path);
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));){
            IoUtils.pipe(is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new InternalServerError(e);
        }
        return new RedirectToRoot();
    }

    @RestOp(method="VIEW", path={"/*"}, summary="View contents of file", description={"View the contents of a file.\nContent-Type is set to 'text/plain'."})
    public FileContents viewFile(RestResponse res, @Path(value="/*") String path) throws NotFound, MethodNotAllowed {
        if (!this.allowViews) {
            throw new MethodNotAllowed("VIEW not enabled", new Object[0]);
        }
        res.setContentType("text/plain");
        try {
            return new FileContents(this.getFile(path));
        }
        catch (FileNotFoundException e) {
            throw new NotFound("File not found", new Object[0]);
        }
    }

    private void deleteFile(File f) {
        File[] files;
        if (!this.allowDeletes) {
            throw new MethodNotAllowed("DELETE not enabled", new Object[0]);
        }
        if (f.isDirectory() && Utils.nn(files = f.listFiles())) {
            for (File fc : files) {
                this.deleteFile(fc);
            }
        }
        if (!f.delete()) {
            throw new Forbidden("Could not delete file {0}", f.getAbsolutePath());
        }
    }

    private File getFile(String path) throws NotFound {
        if (path == null) {
            return this.rootDir;
        }
        File f = new File(this.rootDir.getAbsolutePath() + "/" + path);
        if (f.exists()) {
            return f;
        }
        throw new NotFound("File not found.", new Object[0]);
    }

    protected File getRootDir() {
        return this.rootDir;
    }

    @Response
    @Schema(description={"Redirect to root page on success"})
    static class RedirectToRoot
    extends SeeOtherRoot {
        RedirectToRoot() {
        }
    }

    @Response
    @Schema(type="string", format="binary", description={"Contents of file"})
    static class FileContents
    extends FileInputStream {
        public FileContents(File file) throws FileNotFoundException {
            super(file);
        }
    }

    @Response
    @Schema(description={"File or directory details"})
    @Bean(properties="type,name,size,lastModified,actions,files")
    public class FileResource {
        private final File f;
        private final String path;
        private final String uri;
        private final boolean includeChildren;

        public FileResource(File f, String path, boolean includeChildren) {
            this.f = f;
            this.path = path;
            this.uri = "servlet:/" + (path == null ? "" : path);
            this.includeChildren = includeChildren;
        }

        @Html(format=HtmlFormat.HTML_CDC)
        public List<Action> getActions() throws Exception {
            List<Action> l = CollectionUtils.list(new Action[0]);
            if (DirectoryResource.this.allowViews && this.f.canRead() && !this.f.isDirectory()) {
                l.add(new Action("view", this.uri + "?method=VIEW", new Object[0]));
                l.add(new Action("download", this.uri + "?method=DOWNLOAD", new Object[0]));
            }
            if (DirectoryResource.this.allowDeletes && this.f.canWrite() && !this.f.isDirectory()) {
                l.add(new Action("delete", this.uri + "?method=DELETE", new Object[0]));
            }
            return l;
        }

        public Set<FileResource> getFiles() {
            if (this.f.isFile() || !this.includeChildren) {
                return null;
            }
            TreeSet<FileResource> s = new TreeSet<FileResource>(new FileResourceComparator());
            for (File fc : this.f.listFiles()) {
                s.add(new FileResource(fc, (String)(Utils.nn(this.path) ? this.path + "/" : "") + StringUtils.urlEncode(fc.getName()), false));
            }
            return s;
        }

        public Date getLastModified() {
            return new Date(this.f.lastModified());
        }

        public LinkString getName() {
            return new LinkString(this.f.getName(), this.uri, new Object[0]);
        }

        public long getSize() {
            return this.f.isDirectory() ? (long)this.f.listFiles().length : this.f.length();
        }

        public String getType() {
            return this.f.isDirectory() ? "dir" : "file";
        }
    }

    static class FileResourceComparator
    implements Comparator<FileResource>,
    Serializable {
        private static final long serialVersionUID = 1L;

        FileResourceComparator() {
        }

        @Override
        public int compare(FileResource o1, FileResource o2) {
            int c = o1.getType().compareTo(o2.getType());
            return c != 0 ? c : o1.getName().compareTo(o2.getName());
        }
    }

    @Response
    @Schema(description={"File action"})
    public static class Action
    extends LinkString {
        public Action(String name, String uri, Object ... uriArgs) {
            super(name, uri, uriArgs);
        }

        @Override
        public Action setName(String value) {
            super.setName(value);
            return this;
        }

        @Override
        public Action setUri(URI value) {
            super.setUri(value);
            return this;
        }

        @Override
        public Action setUri(String value) {
            super.setUri(value);
            return this;
        }

        @Override
        public Action setUri(String value, Object ... args) {
            super.setUri(value, args);
            return this;
        }
    }
}

