/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.sink;

import java.util.Objects;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.header.Header;

public class SinkRecord
extends ConnectRecord<SinkRecord> {
    private final long kafkaOffset;
    private final TimestampType timestampType;
    private final String originalTopic;
    private final Integer originalKafkaPartition;
    private final long originalKafkaOffset;

    public SinkRecord(String topic, int partition, Schema keySchema, Object key, Schema valueSchema, Object value, long kafkaOffset) {
        this(topic, partition, keySchema, key, valueSchema, value, kafkaOffset, null, TimestampType.NO_TIMESTAMP_TYPE);
    }

    public SinkRecord(String topic, int partition, Schema keySchema, Object key, Schema valueSchema, Object value, long kafkaOffset, Long timestamp, TimestampType timestampType) {
        this(topic, partition, keySchema, key, valueSchema, value, kafkaOffset, timestamp, timestampType, null);
    }

    public SinkRecord(String topic, int partition, Schema keySchema, Object key, Schema valueSchema, Object value, long kafkaOffset, Long timestamp, TimestampType timestampType, Iterable<Header> headers) {
        this(topic, partition, keySchema, key, valueSchema, value, kafkaOffset, timestamp, timestampType, headers, topic, partition, kafkaOffset);
    }

    public SinkRecord(String topic, int partition, Schema keySchema, Object key, Schema valueSchema, Object value, long kafkaOffset, Long timestamp, TimestampType timestampType, Iterable<Header> headers, String originalTopic, Integer originalKafkaPartition, long originalKafkaOffset) {
        super(topic, partition, keySchema, key, valueSchema, value, timestamp, headers);
        this.kafkaOffset = kafkaOffset;
        this.timestampType = timestampType;
        this.originalTopic = originalTopic;
        this.originalKafkaPartition = originalKafkaPartition;
        this.originalKafkaOffset = originalKafkaOffset;
    }

    public long kafkaOffset() {
        return this.kafkaOffset;
    }

    public TimestampType timestampType() {
        return this.timestampType;
    }

    public String originalTopic() {
        return this.originalTopic;
    }

    public Integer originalKafkaPartition() {
        return this.originalKafkaPartition;
    }

    public long originalKafkaOffset() {
        return this.originalKafkaOffset;
    }

    @Override
    public SinkRecord newRecord(String topic, Integer kafkaPartition, Schema keySchema, Object key, Schema valueSchema, Object value, Long timestamp) {
        return this.newRecord(topic, kafkaPartition, keySchema, key, valueSchema, value, timestamp, (Iterable)this.headers().duplicate());
    }

    @Override
    public SinkRecord newRecord(String topic, Integer kafkaPartition, Schema keySchema, Object key, Schema valueSchema, Object value, Long timestamp, Iterable<Header> headers) {
        return new SinkRecord(topic, kafkaPartition, keySchema, key, valueSchema, value, this.kafkaOffset, timestamp, this.timestampType, headers, this.originalTopic, this.originalKafkaPartition, this.originalKafkaOffset);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SinkRecord that = (SinkRecord)o;
        return this.kafkaOffset == that.kafkaOffset && this.timestampType == that.timestampType && Objects.equals(this.originalTopic, that.originalTopic) && Objects.equals(this.originalKafkaPartition, that.originalKafkaPartition) && this.originalKafkaOffset == that.originalKafkaOffset;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Long.hashCode(this.kafkaOffset);
        result = 31 * result + this.timestampType.hashCode();
        result = 31 * result + this.originalTopic.hashCode();
        result = 31 * result + this.originalKafkaPartition.hashCode();
        result = 31 * result + Long.hashCode(this.originalKafkaOffset);
        return result;
    }

    @Override
    public String toString() {
        return "SinkRecord{kafkaOffset=" + this.kafkaOffset + ", timestampType=" + String.valueOf(this.timestampType) + ", originalTopic=" + this.originalTopic + ", originalKafkaPartition=" + this.originalKafkaPartition + ", originalKafkaOffset=" + this.originalKafkaOffset + "} " + super.toString();
    }
}

