/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.share.generated;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import java.util.ArrayList;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.coordinator.share.generated.ShareUpdateValue;

public class ShareUpdateValueJsonConverter {
    public static ShareUpdateValue read(JsonNode _node, short _version) {
        ShareUpdateValue _object = new ShareUpdateValue();
        JsonNode _snapshotEpochNode = _node.get("snapshotEpoch");
        if (_snapshotEpochNode == null) {
            throw new RuntimeException("ShareUpdateValue: unable to locate field 'snapshotEpoch', which is mandatory in version " + _version);
        }
        _object.snapshotEpoch = MessageUtil.jsonNodeToInt((JsonNode)_snapshotEpochNode, (String)"ShareUpdateValue");
        JsonNode _leaderEpochNode = _node.get("leaderEpoch");
        if (_leaderEpochNode == null) {
            throw new RuntimeException("ShareUpdateValue: unable to locate field 'leaderEpoch', which is mandatory in version " + _version);
        }
        _object.leaderEpoch = MessageUtil.jsonNodeToInt((JsonNode)_leaderEpochNode, (String)"ShareUpdateValue");
        JsonNode _startOffsetNode = _node.get("startOffset");
        if (_startOffsetNode == null) {
            throw new RuntimeException("ShareUpdateValue: unable to locate field 'startOffset', which is mandatory in version " + _version);
        }
        _object.startOffset = MessageUtil.jsonNodeToLong((JsonNode)_startOffsetNode, (String)"ShareUpdateValue");
        JsonNode _deliveryCompleteCountNode = _node.get("deliveryCompleteCount");
        _object.deliveryCompleteCount = _deliveryCompleteCountNode == null ? -1 : MessageUtil.jsonNodeToInt((JsonNode)_deliveryCompleteCountNode, (String)"ShareUpdateValue");
        JsonNode _stateBatchesNode = _node.get("stateBatches");
        if (_stateBatchesNode == null) {
            throw new RuntimeException("ShareUpdateValue: unable to locate field 'stateBatches', which is mandatory in version " + _version);
        }
        if (!_stateBatchesNode.isArray()) {
            throw new RuntimeException("ShareUpdateValue expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<ShareUpdateValue.StateBatch> _collection = new ArrayList<ShareUpdateValue.StateBatch>(_stateBatchesNode.size());
        _object.stateBatches = _collection;
        for (JsonNode _element : _stateBatchesNode) {
            _collection.add(StateBatchJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(ShareUpdateValue _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("snapshotEpoch", (JsonNode)new IntNode(_object.snapshotEpoch));
        _node.set("leaderEpoch", (JsonNode)new IntNode(_object.leaderEpoch));
        _node.set("startOffset", (JsonNode)new LongNode(_object.startOffset));
        if (_object.deliveryCompleteCount != -1) {
            _node.set("deliveryCompleteCount", (JsonNode)new IntNode(_object.deliveryCompleteCount));
        }
        ArrayNode _stateBatchesArray = new ArrayNode(JsonNodeFactory.instance);
        for (ShareUpdateValue.StateBatch _element : _object.stateBatches) {
            _stateBatchesArray.add(StateBatchJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("stateBatches", (JsonNode)_stateBatchesArray);
        return _node;
    }

    public static JsonNode write(ShareUpdateValue _object, short _version) {
        return ShareUpdateValueJsonConverter.write(_object, _version, true);
    }

    public static class StateBatchJsonConverter {
        public static ShareUpdateValue.StateBatch read(JsonNode _node, short _version) {
            ShareUpdateValue.StateBatch _object = new ShareUpdateValue.StateBatch();
            JsonNode _firstOffsetNode = _node.get("firstOffset");
            if (_firstOffsetNode == null) {
                throw new RuntimeException("StateBatch: unable to locate field 'firstOffset', which is mandatory in version " + _version);
            }
            _object.firstOffset = MessageUtil.jsonNodeToLong((JsonNode)_firstOffsetNode, (String)"StateBatch");
            JsonNode _lastOffsetNode = _node.get("lastOffset");
            if (_lastOffsetNode == null) {
                throw new RuntimeException("StateBatch: unable to locate field 'lastOffset', which is mandatory in version " + _version);
            }
            _object.lastOffset = MessageUtil.jsonNodeToLong((JsonNode)_lastOffsetNode, (String)"StateBatch");
            JsonNode _deliveryStateNode = _node.get("deliveryState");
            if (_deliveryStateNode == null) {
                throw new RuntimeException("StateBatch: unable to locate field 'deliveryState', which is mandatory in version " + _version);
            }
            _object.deliveryState = MessageUtil.jsonNodeToByte((JsonNode)_deliveryStateNode, (String)"StateBatch");
            JsonNode _deliveryCountNode = _node.get("deliveryCount");
            if (_deliveryCountNode == null) {
                throw new RuntimeException("StateBatch: unable to locate field 'deliveryCount', which is mandatory in version " + _version);
            }
            _object.deliveryCount = MessageUtil.jsonNodeToShort((JsonNode)_deliveryCountNode, (String)"StateBatch");
            return _object;
        }

        public static JsonNode write(ShareUpdateValue.StateBatch _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("firstOffset", (JsonNode)new LongNode(_object.firstOffset));
            _node.set("lastOffset", (JsonNode)new LongNode(_object.lastOffset));
            _node.set("deliveryState", (JsonNode)new ShortNode((short)_object.deliveryState));
            _node.set("deliveryCount", (JsonNode)new ShortNode(_object.deliveryCount));
            return _node;
        }

        public static JsonNode write(ShareUpdateValue.StateBatch _object, short _version) {
            return StateBatchJsonConverter.write(_object, _version, true);
        }
    }
}

