/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.felix.cm.NotCachablePersistenceManager;
import org.apache.felix.cm.impl.CaseInsensitiveDictionary;

public class MemoryPersistenceManager
implements NotCachablePersistenceManager {
    private final Map<String, CaseInsensitiveDictionary> cache = new HashMap<String, CaseInsensitiveDictionary>();
    private final Map<String, Set<String>> factoryConfigCache = new HashMap<String, Set<String>>();

    @Override
    public void delete(String pid) throws IOException {
        Set<String> factoryPids;
        String factoryPid;
        Dictionary props = this.cache.remove(pid);
        if (props != null && (factoryPid = (String)props.get("service.factoryPid")) != null && (factoryPids = this.factoryConfigCache.get(factoryPid)) != null) {
            factoryPids.remove(pid);
            if (factoryPids.isEmpty()) {
                this.factoryConfigCache.remove(factoryPid);
            }
        }
    }

    @Override
    public boolean exists(String pid) {
        return this.cache.containsKey(pid);
    }

    @Override
    public Enumeration getDictionaries() throws IOException {
        ArrayList<CaseInsensitiveDictionary> configs = new ArrayList<CaseInsensitiveDictionary>();
        for (Dictionary dictionary : this.cache.values()) {
            if (dictionary.get("service.pid") == null) continue;
            configs.add(new CaseInsensitiveDictionary(dictionary));
        }
        return Collections.enumeration(configs);
    }

    private final CaseInsensitiveDictionary cache(Dictionary props) {
        String pid = (String)props.get("service.pid");
        CaseInsensitiveDictionary dict = null;
        if (pid != null && (dict = this.cache.get(pid)) == null) {
            dict = new CaseInsensitiveDictionary(props);
            this.cache.put(pid, dict);
            String factoryPid = (String)props.get("service.factoryPid");
            if (factoryPid != null) {
                Set<String> factoryPids = this.factoryConfigCache.get(factoryPid);
                if (factoryPids == null) {
                    factoryPids = new HashSet<String>();
                    this.factoryConfigCache.put(factoryPid, factoryPids);
                }
                factoryPids.add(pid);
            }
        }
        return dict;
    }

    @Override
    public Dictionary load(String pid) throws IOException {
        CaseInsensitiveDictionary loaded = this.cache.get(pid);
        return loaded == null ? null : new CaseInsensitiveDictionary(loaded);
    }

    @Override
    public void store(String pid, Dictionary properties) throws IOException {
        this.cache.remove(pid);
        this.cache(properties);
    }
}

