/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jms.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import org.ops4j.pax.transx.jms.impl.JMSContextImpl;
import org.ops4j.pax.transx.jms.impl.Utils;

public final class JMSProducerImpl
implements JMSProducer {
    private final JMSContextImpl context;
    private final MessageProducer producer;
    private volatile CompletionListener completionListener;
    private String correlationId;
    private String type;
    private Destination replyTo;
    private byte[] correlationIdBytes;
    private long deliveryDelay = 0L;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private boolean disableMessageId;
    private boolean disableTimestamp;
    private final Map<String, Object> messageProperties = new HashMap<String, Object>();

    JMSProducerImpl(JMSContextImpl context, MessageProducer producer) {
        this.context = context;
        this.producer = producer;
    }

    public JMSProducer send(Destination destination, Message message) {
        try {
            this.doSend(destination, message);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
        return this;
    }

    public JMSProducer send(Destination destination, byte[] body) {
        try {
            BytesMessage message = this.context.createBytesMessage();
            message.writeBytes(body);
            this.doSend(destination, (Message)message);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
        return this;
    }

    public JMSProducer send(Destination destination, Map<String, Object> body) {
        try {
            MapMessage message = this.context.createMapMessage();
            for (Map.Entry<String, Object> entry : body.entrySet()) {
                message.setObject(entry.getKey(), entry.getValue());
            }
            this.doSend(destination, (Message)message);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
        return this;
    }

    public JMSProducer send(Destination destination, Serializable body) {
        try {
            ObjectMessage message = this.context.createObjectMessage();
            message.setObject(body);
            this.doSend(destination, (Message)message);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
        return this;
    }

    public JMSProducer send(Destination destination, String body) {
        try {
            TextMessage message = this.context.createTextMessage(body);
            this.doSend(destination, (Message)message);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
        return this;
    }

    private void doSend(Destination destination, Message message) throws JMSException {
        block9: {
            if (message == null) {
                throw new MessageFormatException("Message must not be null");
            }
            for (Map.Entry<String, Object> entry : this.messageProperties.entrySet()) {
                message.setObjectProperty(entry.getKey(), entry.getValue());
            }
            if (this.correlationId != null) {
                message.setJMSCorrelationID(this.correlationId);
            }
            if (this.correlationIdBytes != null) {
                message.setJMSCorrelationIDAsBytes(this.correlationIdBytes);
            }
            if (this.type != null) {
                message.setJMSType(this.type);
            }
            if (this.replyTo != null) {
                message.setJMSReplyTo(this.replyTo);
            }
            this.producer.setDeliveryMode(this.deliveryMode);
            this.producer.setPriority(this.priority);
            this.producer.setTimeToLive(this.timeToLive);
            this.producer.setDisableMessageID(this.disableMessageId);
            this.producer.setDisableMessageTimestamp(this.disableTimestamp);
            try {
                this.producer.send(destination, message);
                if (this.completionListener != null) {
                    this.completionListener.onCompletion(message);
                }
            }
            catch (Exception e) {
                if (this.completionListener == null) break block9;
                this.completionListener.onException(message, e);
            }
        }
    }

    public JMSProducer clearProperties() {
        this.messageProperties.clear();
        return this;
    }

    public Set<String> getPropertyNames() {
        return new HashSet<String>(this.messageProperties.keySet());
    }

    public boolean propertyExists(String name) {
        return this.messageProperties.containsKey(name);
    }

    public boolean getBooleanProperty(String name) {
        try {
            return JMSProducerImpl.convertPropertyTo(name, this.messageProperties.get(name), Boolean.class);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public byte getByteProperty(String name) {
        try {
            return JMSProducerImpl.convertPropertyTo(name, this.messageProperties.get(name), Byte.class);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public double getDoubleProperty(String name) {
        try {
            return JMSProducerImpl.convertPropertyTo(name, this.messageProperties.get(name), Double.class);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public float getFloatProperty(String name) {
        try {
            return JMSProducerImpl.convertPropertyTo(name, this.messageProperties.get(name), Float.class).floatValue();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public int getIntProperty(String name) {
        try {
            return JMSProducerImpl.convertPropertyTo(name, this.messageProperties.get(name), Integer.class);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public long getLongProperty(String name) {
        try {
            return JMSProducerImpl.convertPropertyTo(name, this.messageProperties.get(name), Long.class);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public Object getObjectProperty(String name) {
        return this.messageProperties.get(name);
    }

    public short getShortProperty(String name) {
        try {
            return JMSProducerImpl.convertPropertyTo(name, this.messageProperties.get(name), Short.class);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public String getStringProperty(String name) {
        try {
            return JMSProducerImpl.convertPropertyTo(name, this.messageProperties.get(name), String.class);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public JMSProducer setProperty(String name, boolean value) {
        return this.setObjectProperty(name, value);
    }

    public JMSProducer setProperty(String name, byte value) {
        return this.setObjectProperty(name, value);
    }

    public JMSProducer setProperty(String name, double value) {
        return this.setObjectProperty(name, value);
    }

    public JMSProducer setProperty(String name, float value) {
        return this.setObjectProperty(name, Float.valueOf(value));
    }

    public JMSProducer setProperty(String name, int value) {
        return this.setObjectProperty(name, value);
    }

    public JMSProducer setProperty(String name, long value) {
        return this.setObjectProperty(name, value);
    }

    public JMSProducer setProperty(String name, Object value) {
        return this.setObjectProperty(name, value);
    }

    public JMSProducer setProperty(String name, short value) {
        return this.setObjectProperty(name, value);
    }

    public JMSProducer setProperty(String name, String value) {
        return this.setObjectProperty(name, value);
    }

    public String getJMSCorrelationID() {
        return this.correlationId;
    }

    public JMSProducer setJMSCorrelationID(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.correlationIdBytes;
    }

    public JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationIdBytes) {
        this.correlationIdBytes = correlationIdBytes;
        return this;
    }

    public Destination getJMSReplyTo() {
        return this.replyTo;
    }

    public JMSProducer setJMSReplyTo(Destination replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public String getJMSType() {
        return this.type;
    }

    public JMSProducer setJMSType(String type) {
        this.type = type;
        return this;
    }

    public CompletionListener getAsync() {
        return this.completionListener;
    }

    public JMSProducer setAsync(CompletionListener completionListener) {
        this.completionListener = completionListener;
        return this;
    }

    public long getDeliveryDelay() {
        return this.deliveryDelay;
    }

    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        this.deliveryDelay = deliveryDelay;
        return this;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public JMSProducer setDeliveryMode(int deliveryMode) {
        switch (deliveryMode) {
            case 1: 
            case 2: {
                this.deliveryMode = deliveryMode;
                return this;
            }
        }
        throw new JMSRuntimeException(String.format("Invalid DeliveryMode specified: %d", deliveryMode));
    }

    public boolean getDisableMessageID() {
        return this.disableMessageId;
    }

    public JMSProducer setDisableMessageID(boolean disableMessageId) {
        this.disableMessageId = disableMessageId;
        return this;
    }

    public boolean getDisableMessageTimestamp() {
        return this.disableTimestamp;
    }

    public JMSProducer setDisableMessageTimestamp(boolean disableTimestamp) {
        this.disableTimestamp = disableTimestamp;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public JMSProducer setPriority(int priority) {
        if (priority < 0 || priority > 9) {
            throw new JMSRuntimeException(String.format("Priority value given {%d} is out of range (0..9)", priority));
        }
        this.priority = priority;
        return this;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public JMSProducer setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    private JMSProducer setObjectProperty(String name, Object value) {
        this.messageProperties.put(name, value);
        return this;
    }

    private static <T> T convertPropertyTo(String name, Object value, Class<T> target) throws JMSException {
        if (value == null) {
            if (Boolean.class.equals(target)) {
                return (T)Boolean.FALSE;
            }
            if (Float.class.equals(target) || Double.class.equals(target)) {
                throw new NullPointerException("property " + name + " was null");
            }
            if (Number.class.isAssignableFrom(target)) {
                throw new NumberFormatException("property " + name + " was null");
            }
            return null;
        }
        if (target.isInstance(value)) {
            return target.cast(value);
        }
        try {
            return target.getConstructor(String.class).newInstance(value.toString());
        }
        catch (Exception e) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a " + target.getName());
        }
    }
}

