/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.karaf.decanter.collector.rest;

import javax.ws.rs.*;

@Path("/")
public class TestService {

    @GET
    @Path("/echo")
    public String echo() {
        return "hello world";
    }

    @POST
    @Path("/submit")
    public String submitPost(String foo) {
        return "hello post " + foo;
    }

    @PUT
    @Path("/submit")
    public String submitPut(String foo) {
        return "hello put " + foo;
    }

    @DELETE
    @Path("/delete")
    public String delete() {
        return "deleted";
    }

    @POST
    @Path("/header")
    public String headerPost(@HeaderParam("foo") String foo) {
        return "hello header " + foo;
    }

}
