/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.impl.avl;

import java.io.IOException;
import java.net.URI;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.UuidComparator;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.core.partition.impl.btree.IndexCursorAdaptor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndex;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.impl.avl.AvlTable;

public class AvlIndex<K>
extends AbstractIndex<K, String> {
    protected Normalizer normalizer;
    protected AvlTable<K, String> forward;
    protected AvlTable<String, K> reverse;

    public AvlIndex() {
        super(true);
    }

    public AvlIndex(String attributeId) {
        super(attributeId, true);
    }

    public AvlIndex(String attributeId, boolean withReverse) {
        super(attributeId, withReverse);
    }

    public void init(SchemaManager schemaManager, AttributeType attributeType) throws LdapException {
        this.attributeType = attributeType;
        MatchingRule mr = attributeType.getEquality();
        if (mr == null) {
            mr = attributeType.getOrdering();
        }
        if (mr == null) {
            mr = attributeType.getSubstring();
        }
        this.normalizer = mr.getNormalizer();
        if (this.normalizer == null) {
            throw new LdapOtherException(I18n.err((I18n)I18n.ERR_212, (Object[])new Object[]{attributeType}));
        }
        LdapComparator comp = mr.getLdapComparator();
        this.forward = new AvlTable(attributeType.getName(), comp, UuidComparator.INSTANCE, true);
        if (this.withReverse) {
            this.reverse = attributeType.isSingleValued() ? new AvlTable(attributeType.getName(), UuidComparator.INSTANCE, comp, false) : new AvlTable(attributeType.getName(), UuidComparator.INSTANCE, comp, true);
        }
    }

    @Override
    public void add(PartitionTxn partitionTxn, K attrVal, String id) throws LdapException {
        this.forward.put(partitionTxn, attrVal, id);
        if (this.withReverse) {
            this.reverse.put(partitionTxn, id, (String)attrVal);
        }
    }

    @Override
    public void close(PartitionTxn partitionTxn) throws LdapException, IOException {
        if (this.forward != null) {
            this.forward.close(partitionTxn);
        }
        if (this.reverse != null) {
            this.reverse.close(partitionTxn);
        }
    }

    @Override
    public long count(PartitionTxn partitionTxn) throws LdapException {
        return this.forward.count(partitionTxn);
    }

    @Override
    public long count(PartitionTxn partitionTxn, K attrVal) throws LdapException {
        return this.forward.count(partitionTxn, attrVal);
    }

    @Override
    public void drop(PartitionTxn partitionTxn, String id) throws LdapException {
        if (this.withReverse) {
            if (this.isDupsEnabled()) {
                Cursor<Tuple<String, K>> cursor = this.reverse.cursor(partitionTxn, id);
                try {
                    while (cursor.next()) {
                        Tuple tuple = (Tuple)cursor.get();
                        this.forward.remove(partitionTxn, tuple.getValue(), id);
                    }
                    cursor.close();
                }
                catch (IOException | CursorException e) {
                    throw new LdapOtherException(e.getMessage(), e);
                }
            } else {
                K key = this.reverse.get(partitionTxn, id);
                this.forward.remove(partitionTxn, key);
            }
            this.reverse.remove(partitionTxn, id);
        }
    }

    @Override
    public void drop(PartitionTxn partitionTxn, K attrVal, String id) throws LdapException {
        this.forward.remove(partitionTxn, attrVal, id);
        if (this.withReverse) {
            this.reverse.remove(partitionTxn, id, (String)attrVal);
        }
    }

    @Override
    public boolean forward(PartitionTxn partitionTxn, K attrVal) throws LdapException {
        return this.forward.has(partitionTxn, attrVal);
    }

    @Override
    public boolean forward(PartitionTxn partitionTxn, K attrVal, String id) throws LdapException {
        return this.forward.has(partitionTxn, attrVal, id);
    }

    @Override
    public Cursor<IndexEntry<K, String>> forwardCursor(PartitionTxn partitionTxn) throws LdapException {
        return new IndexCursorAdaptor(partitionTxn, this.forward.cursor(), true);
    }

    @Override
    public Cursor<IndexEntry<K, String>> forwardCursor(PartitionTxn partitionTxn, K key) throws LdapException {
        return new IndexCursorAdaptor(partitionTxn, this.forward.cursor(partitionTxn, key), true);
    }

    @Override
    public String forwardLookup(PartitionTxn partitionTxn, K attrVal) throws LdapException {
        return this.forward.get(partitionTxn, attrVal);
    }

    @Override
    public Cursor<String> forwardValueCursor(PartitionTxn partitionTxn, K key) throws LdapException {
        return this.forward.valueCursor(partitionTxn, key);
    }

    @Override
    public long greaterThanCount(PartitionTxn partitionTxn, K attrVal) throws LdapException {
        return this.forward.greaterThanCount(partitionTxn, attrVal);
    }

    @Override
    public long lessThanCount(PartitionTxn partitionTxn, K attrVal) throws LdapException {
        return this.forward.lessThanCount(partitionTxn, attrVal);
    }

    @Override
    public boolean reverse(PartitionTxn partitionTxn, String id) throws LdapException {
        if (this.withReverse) {
            return this.reverse.has(partitionTxn, id);
        }
        return false;
    }

    @Override
    public boolean reverse(PartitionTxn partitionTxn, String id, K attrVal) throws LdapException {
        if (this.withReverse) {
            return this.reverse.has(partitionTxn, id, (String)attrVal);
        }
        return false;
    }

    @Override
    public K reverseLookup(PartitionTxn partitionTxn, String id) throws LdapException {
        if (this.withReverse) {
            return this.reverse.get(partitionTxn, id);
        }
        return null;
    }

    @Override
    public Cursor<K> reverseValueCursor(PartitionTxn partitionTxn, String id) throws LdapException {
        if (this.withReverse) {
            return this.reverse.valueCursor(partitionTxn, id);
        }
        return new EmptyCursor();
    }

    @Override
    public void setWkDirPath(URI wkDirPath) {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_213, (Object[])new Object[0]));
    }

    @Override
    public URI getWkDirPath() {
        return null;
    }

    @Override
    public boolean isDupsEnabled() {
        if (this.withReverse) {
            return this.reverse.isDupsEnabled();
        }
        return false;
    }
}

