/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger;

import com.cloudera.api.swagger.client.ApiCallback;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.client.ApiResponse;
import com.cloudera.api.swagger.client.Configuration;
import com.cloudera.api.swagger.client.Pair;
import com.cloudera.api.swagger.client.ProgressRequestBody;
import com.cloudera.api.swagger.client.ProgressResponseBody;
import com.cloudera.api.swagger.model.ApiAuditList;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class AuditsResourceApi {
    private ApiClient apiClient;

    public AuditsResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuditsResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call readAuditsCall(String endTime, BigDecimal maxResults, String query, BigDecimal resultOffset, String startTime, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/audits";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (endTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endTime", endTime));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        }
        if (query != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("query", query));
        }
        if (resultOffset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resultOffset", resultOffset));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startTime", startTime));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readAuditsValidateBeforeCall(String endTime, BigDecimal maxResults, String query, BigDecimal resultOffset, String startTime, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.readAuditsCall(endTime, maxResults, query, resultOffset, startTime, progressListener, progressRequestListener);
        return call;
    }

    public ApiAuditList readAudits(String endTime, BigDecimal maxResults, String query, BigDecimal resultOffset, String startTime) throws ApiException {
        ApiResponse<ApiAuditList> resp = this.readAuditsWithHttpInfo(endTime, maxResults, query, resultOffset, startTime);
        return resp.getData();
    }

    public ApiResponse<ApiAuditList> readAuditsWithHttpInfo(String endTime, BigDecimal maxResults, String query, BigDecimal resultOffset, String startTime) throws ApiException {
        Call call = this.readAuditsValidateBeforeCall(endTime, maxResults, query, resultOffset, startTime, null, null);
        Type localVarReturnType = new TypeToken<ApiAuditList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readAuditsAsync(String endTime, BigDecimal maxResults, String query, BigDecimal resultOffset, String startTime, final ApiCallback<ApiAuditList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readAuditsValidateBeforeCall(endTime, maxResults, query, resultOffset, startTime, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiAuditList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call streamAuditsCall(String endTime, BigDecimal maxResults, String query, BigDecimal resultOffset, String startTime, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/audits/stream";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (endTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endTime", endTime));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        }
        if (query != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("query", query));
        }
        if (resultOffset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resultOffset", resultOffset));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startTime", startTime));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call streamAuditsValidateBeforeCall(String endTime, BigDecimal maxResults, String query, BigDecimal resultOffset, String startTime, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.streamAuditsCall(endTime, maxResults, query, resultOffset, startTime, progressListener, progressRequestListener);
        return call;
    }

    public File streamAudits(String endTime, BigDecimal maxResults, String query, BigDecimal resultOffset, String startTime) throws ApiException {
        ApiResponse<File> resp = this.streamAuditsWithHttpInfo(endTime, maxResults, query, resultOffset, startTime);
        return resp.getData();
    }

    public ApiResponse<File> streamAuditsWithHttpInfo(String endTime, BigDecimal maxResults, String query, BigDecimal resultOffset, String startTime) throws ApiException {
        Call call = this.streamAuditsValidateBeforeCall(endTime, maxResults, query, resultOffset, startTime, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call streamAuditsAsync(String endTime, BigDecimal maxResults, String query, BigDecimal resultOffset, String startTime, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.streamAuditsValidateBeforeCall(endTime, maxResults, query, resultOffset, startTime, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

