/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.redirect;

import java.util.Optional;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.exception.http.RedirectionActionHelper;
import org.pac4j.core.redirect.RedirectionActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.profile.api.SAML2ObjectBuilder;
import org.pac4j.saml.sso.impl.SAML2AuthnRequestBuilder;
import org.pac4j.saml.transport.Pac4jSAMLResponse;

public class SAML2RedirectionActionBuilder
implements RedirectionActionBuilder {
    protected SAML2ObjectBuilder<AuthnRequest> saml2ObjectBuilder;
    private final SAML2Client client;

    public SAML2RedirectionActionBuilder(SAML2Client client) {
        CommonHelper.assertNotNull((String)"client", (Object)((Object)client));
        this.client = client;
        SAML2Configuration cfg = client.getConfiguration();
        this.saml2ObjectBuilder = new SAML2AuthnRequestBuilder(cfg);
    }

    public Optional<RedirectionAction> getRedirectionAction(WebContext wc) {
        SAML2MessageContext context = this.client.getContextProvider().buildContext(wc);
        String relayState = this.client.getStateGenerator().generateValue(wc);
        AuthnRequest authnRequest = this.saml2ObjectBuilder.build(context);
        this.client.getProfileHandler().send(context, authnRequest, relayState);
        Pac4jSAMLResponse adapter = context.getProfileRequestContextOutboundMessageTransportResponse();
        String bindingType = this.client.getConfiguration().getAuthnRequestBindingType();
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equalsIgnoreCase(bindingType) || "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign".equalsIgnoreCase(bindingType)) {
            String content = adapter.getOutgoingContent();
            return Optional.of(RedirectionActionHelper.buildFormPostContentAction((WebContext)wc, (String)content));
        }
        String location = adapter.getRedirectUrl();
        return Optional.of(RedirectionActionHelper.buildRedirectUrlAction((WebContext)wc, (String)location));
    }
}

