/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter.configure;

import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.timelimiter.configuration.TimeLimiterConfigCustomizer;
import io.github.resilience4j.common.timelimiter.configuration.TimeLimiterConfigurationProperties;
import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.ContextAwareScheduledThreadPoolExecutor;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.registry.CompositeRegistryEventConsumer;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.fallback.FallbackDecorators;
import io.github.resilience4j.spelresolver.SpelResolver;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.github.resilience4j.timelimiter.configure.ReactorTimeLimiterAspectExt;
import io.github.resilience4j.timelimiter.configure.RxJava2TimeLimiterAspectExt;
import io.github.resilience4j.timelimiter.configure.TimeLimiterAspect;
import io.github.resilience4j.timelimiter.configure.TimeLimiterAspectExt;
import io.github.resilience4j.timelimiter.configure.TimeLimiterConfigurationProperties;
import io.github.resilience4j.timelimiter.event.TimeLimiterEvent;
import io.github.resilience4j.utils.AspectJOnClasspathCondition;
import io.github.resilience4j.utils.ReactorOnClasspathCondition;
import io.github.resilience4j.utils.RxJava2OnClasspathCondition;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class TimeLimiterConfiguration {
    @Bean
    @Qualifier(value="compositeTimeLimiterCustomizer")
    public CompositeCustomizer<TimeLimiterConfigCustomizer> compositeTimeLimiterCustomizer(@Autowired(required=false) List<TimeLimiterConfigCustomizer> customizers) {
        return new CompositeCustomizer(customizers);
    }

    @Bean
    public TimeLimiterRegistry timeLimiterRegistry(TimeLimiterConfigurationProperties timeLimiterConfigurationProperties, EventConsumerRegistry<TimeLimiterEvent> timeLimiterEventConsumerRegistry, RegistryEventConsumer<TimeLimiter> timeLimiterRegistryEventConsumer, @Qualifier(value="compositeTimeLimiterCustomizer") CompositeCustomizer<TimeLimiterConfigCustomizer> compositeTimeLimiterCustomizer) {
        TimeLimiterRegistry timeLimiterRegistry = TimeLimiterConfiguration.createTimeLimiterRegistry(timeLimiterConfigurationProperties, timeLimiterRegistryEventConsumer, compositeTimeLimiterCustomizer);
        TimeLimiterConfiguration.registerEventConsumer(timeLimiterRegistry, timeLimiterEventConsumerRegistry, timeLimiterConfigurationProperties);
        this.initTimeLimiterRegistry(timeLimiterRegistry, timeLimiterConfigurationProperties, compositeTimeLimiterCustomizer);
        return timeLimiterRegistry;
    }

    @Bean
    @Primary
    public RegistryEventConsumer<TimeLimiter> timeLimiterRegistryEventConsumer(Optional<List<RegistryEventConsumer<TimeLimiter>>> optionalRegistryEventConsumers) {
        return new CompositeRegistryEventConsumer(optionalRegistryEventConsumers.orElseGet(ArrayList::new));
    }

    @Bean
    @Conditional(value={AspectJOnClasspathCondition.class})
    public TimeLimiterAspect timeLimiterAspect(TimeLimiterConfigurationProperties timeLimiterConfigurationProperties, TimeLimiterRegistry timeLimiterRegistry, @Autowired(required=false) List<TimeLimiterAspectExt> timeLimiterAspectExtList, FallbackDecorators fallbackDecorators, SpelResolver spelResolver, @Autowired(required=false) ContextAwareScheduledThreadPoolExecutor contextAwareScheduledThreadPoolExecutor) {
        return new TimeLimiterAspect(timeLimiterRegistry, timeLimiterConfigurationProperties, timeLimiterAspectExtList, fallbackDecorators, spelResolver, contextAwareScheduledThreadPoolExecutor);
    }

    @Bean
    @Conditional(value={RxJava2OnClasspathCondition.class, AspectJOnClasspathCondition.class})
    public RxJava2TimeLimiterAspectExt rxJava2TimeLimiterAspectExt() {
        return new RxJava2TimeLimiterAspectExt();
    }

    @Bean
    @Conditional(value={ReactorOnClasspathCondition.class, AspectJOnClasspathCondition.class})
    public ReactorTimeLimiterAspectExt reactorTimeLimiterAspectExt() {
        return new ReactorTimeLimiterAspectExt();
    }

    @Bean
    public EventConsumerRegistry<TimeLimiterEvent> timeLimiterEventsConsumerRegistry() {
        return new DefaultEventConsumerRegistry();
    }

    private static TimeLimiterRegistry createTimeLimiterRegistry(TimeLimiterConfigurationProperties timeLimiterConfigurationProperties, RegistryEventConsumer<TimeLimiter> timeLimiterRegistryEventConsumer, CompositeCustomizer<TimeLimiterConfigCustomizer> compositeTimeLimiterCustomizer) {
        java.util.Map<String, TimeLimiterConfig> configs = timeLimiterConfigurationProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> timeLimiterConfigurationProperties.createTimeLimiterConfig((String)entry.getKey(), (TimeLimiterConfigurationProperties.InstanceProperties)entry.getValue(), compositeTimeLimiterCustomizer)));
        return TimeLimiterRegistry.of(configs, timeLimiterRegistryEventConsumer, (Map)HashMap.ofAll((java.util.Map)timeLimiterConfigurationProperties.getTags()));
    }

    void initTimeLimiterRegistry(TimeLimiterRegistry timeLimiterRegistry, TimeLimiterConfigurationProperties timeLimiterConfigurationProperties, CompositeCustomizer<TimeLimiterConfigCustomizer> compositeTimeLimiterCustomizer) {
        timeLimiterConfigurationProperties.getInstances().forEach((name, properties) -> timeLimiterRegistry.timeLimiter(name, timeLimiterConfigurationProperties.createTimeLimiterConfig((String)name, (TimeLimiterConfigurationProperties.InstanceProperties)properties, (CompositeCustomizer)compositeTimeLimiterCustomizer)));
    }

    private static void registerEventConsumer(TimeLimiterRegistry timeLimiterRegistry, EventConsumerRegistry<TimeLimiterEvent> eventConsumerRegistry, TimeLimiterConfigurationProperties properties) {
        timeLimiterRegistry.getEventPublisher().onEntryAdded(event -> TimeLimiterConfiguration.registerEventConsumer(eventConsumerRegistry, (TimeLimiter)event.getAddedEntry(), properties)).onEntryReplaced(event -> TimeLimiterConfiguration.registerEventConsumer(eventConsumerRegistry, (TimeLimiter)event.getNewEntry(), properties));
    }

    private static void registerEventConsumer(EventConsumerRegistry<TimeLimiterEvent> eventConsumerRegistry, TimeLimiter timeLimiter, TimeLimiterConfigurationProperties timeLimiterConfigurationProperties) {
        int eventConsumerBufferSize = Optional.ofNullable(timeLimiterConfigurationProperties.getInstanceProperties(timeLimiter.getName())).map(TimeLimiterConfigurationProperties.InstanceProperties::getEventConsumerBufferSize).orElse(100);
        timeLimiter.getEventPublisher().onEvent((EventConsumer)eventConsumerRegistry.createEventConsumer(timeLimiter.getName(), eventConsumerBufferSize));
    }
}

