/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.advice;

import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.exception.NotFoundException;
import org.apache.kylin.rest.exception.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;

@ControllerAdvice
public class BaseExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(BaseExceptionHandler.class);

    @ExceptionHandler(value={ForbiddenException.class})
    public final ResponseEntity<Void> handle(ForbiddenException ex, WebRequest request) {
        logger.error("uncaught exception", (Throwable)ex);
        return new ResponseEntity(HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={InternalErrorException.class})
    public final ResponseEntity<Void> handle(InternalErrorException ex, WebRequest request) {
        logger.error("uncaught exception", (Throwable)ex);
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={NotFoundException.class})
    public final ResponseEntity<Void> handle(NotFoundException ex, WebRequest request) {
        logger.error("uncaught exception", (Throwable)ex);
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    public final ResponseEntity<Void> handle(UnauthorizedException ex, WebRequest request) {
        logger.error("uncaught exception", (Throwable)ex);
        return new ResponseEntity(HttpStatus.UNAUTHORIZED);
    }
}

