/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
public class CorsConfig {
    @Value(value="${kylin.server.cors.allowed-origin:*}")
    private String corsAllowedOrigins;

    @ConditionalOnProperty(name={"kylin.server.cors.allow-all"}, havingValue="true")
    @Bean
    public CorsFilter corsFilter() {
        String[] stringArray;
        if (StringUtils.isBlank((CharSequence)this.corsAllowedOrigins)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "*";
        } else {
            stringArray = this.corsAllowedOrigins.split(",");
        }
        String[] corsAllowedOriginArray = stringArray;
        CorsConfiguration config = new CorsConfiguration();
        for (String allowedOrigin : corsAllowedOriginArray) {
            config.addAllowedOrigin(allowedOrigin);
        }
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedMethod("*");
        config.addAllowedHeader("*");
        UrlBasedCorsConfigurationSource configSource = new UrlBasedCorsConfigurationSource();
        configSource.registerCorsConfiguration("/**", config);
        return new CorsFilter((CorsConfigurationSource)configSource);
    }
}

