/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.app;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.response.RestResponse;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.streaming.app.StreamingMergeApplication;
import org.apache.kylin.streaming.common.MergeJobEntry;
import org.apache.kylin.streaming.jobs.StreamingDFMergeJob;
import org.apache.kylin.streaming.jobs.SyncMerger;
import org.apache.kylin.streaming.merge.CatchupMergePolicy;
import org.apache.kylin.streaming.merge.MergePolicy;
import org.apache.kylin.streaming.merge.NormalMergePolicy;
import org.apache.kylin.streaming.merge.PeakMergePolicy;
import org.apache.kylin.streaming.request.StreamingSegmentRequest;
import org.apache.kylin.streaming.rest.RestSupport;
import org.apache.kylin.streaming.util.JobExecutionIdHolder;
import org.apache.kylin.streaming.util.JobKiller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingMergeEntry
extends StreamingMergeApplication {
    private static final Logger logger = LoggerFactory.getLogger(StreamingMergeEntry.class);
    private static final AtomicLong globalMergeTime = new AtomicLong(0L);
    private static AtomicBoolean gracefulStop = new AtomicBoolean(false);
    private static CountDownLatch latch = new CountDownLatch(1);
    private StreamingDFMergeJob merger = new StreamingDFMergeJob();
    private CatchupMergePolicy catchupMergePolicy = new CatchupMergePolicy();
    private NormalMergePolicy normalMergePolicy = new NormalMergePolicy();
    private PeakMergePolicy peakMergePolicy = new PeakMergePolicy();
    private AtomicLong hdfsFileScanStartTime = new AtomicLong(System.currentTimeMillis());

    public static void main(String[] args) {
        StreamingMergeEntry entry = new StreamingMergeEntry();
        entry.execute(args);
    }

    public static void stop() {
        gracefulStop.set(true);
    }

    @Override
    public void doExecute() throws ExecuteException {
        this.setStopFlag(false);
        logger.info("StreamingMergeEntry:{},{},{},{},{}", new Object[]{this.project, this.dataflowId, this.thresholdOfSegSize, this.numberOfSeg, this.distMetaUrl});
        boolean isError = false;
        try {
            while (this.isRunning()) {
                this.process(this.project, this.dataflowId);
                if (!this.isGracefulShutdown(this.project, this.jobId)) {
                    StreamingUtils.sleep((long)(this.kylinConfig.getStreamingSegmentMergeInterval() * 1000L));
                    continue;
                }
                this.setStopFlag(true);
                logger.info("begin to shutdown streaming merge job ({}:{})", (Object)this.project, (Object)this.dataflowId);
            }
            this.closeSparkSession();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            isError = true;
            JobKiller.killApplication(this.jobId);
            throw new ExecuteException("streaming merging segment error occured: ", (Throwable)e);
        }
        finally {
            this.close(isError);
        }
    }

    @Override
    public boolean getStopFlag() {
        return gracefulStop.get();
    }

    @Override
    public void setStopFlag(boolean stopFlag) {
        gracefulStop.set(stopFlag);
    }

    public void process(String project, String dataflowId) {
        StreamingUtils.replayAuditlog();
        NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        NDataflow dataflow = dfMgr.getDataflow(dataflowId);
        Segments segments = dataflow.getSegments().getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.READY, SegmentStatusEnum.WARNING});
        Collections.sort(segments);
        this.removeLastL0Segment((Segments<NDataSegment>)segments);
        AtomicInteger currLayer = new AtomicInteger(0);
        MergePolicy policy = this.selectPolicy((Segments<NDataSegment>)segments, currLayer.get());
        while (policy != null && policy.matchMergeCondition(this.thresholdOfSegSize)) {
            List<NDataSegment> segList = policy.getMatchSegList();
            NDataSegment afterMergeSeg = this.mergeSegments(project, dataflowId, segList, currLayer.get());
            policy.next(currLayer);
            dataflow = dfMgr.getDataflow(dataflowId);
            segments = dataflow.getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.READY, SegmentStatusEnum.WARNING, SegmentStatusEnum.NEW});
            this.removeLastL0Segment((Segments<NDataSegment>)segments);
            NDataSegment seg = this.getSegment((Segments<NDataSegment>)segments, afterMergeSeg, project, dataflowId);
            if (seg.getStatus() == SegmentStatusEnum.NEW) break;
            if (seg.getStorageBytesSize() > this.thresholdOfSegSize) {
                logger.info("SegmentId={} size ({}) exceeds threshold", (Object)seg.getId(), (Object)seg.getStorageBytesSize());
                break;
            }
            for (NDataSegment item : segList) {
                this.putHdfsFile(item.getId(), (Pair<String, Long>)new Pair((Object)dataflow.getSegmentHdfsPath(item.getId()), (Object)System.currentTimeMillis()));
            }
            policy = this.selectPolicy((Segments<NDataSegment>)segments, currLayer.get());
            this.clearHdfsFiles(dfMgr.getDataflow(dataflowId), this.hdfsFileScanStartTime);
        }
    }

    public NDataSegment mergeSegments(String project, String dataflowId, List<NDataSegment> retainSegments, int currLayer) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        int retry = 0;
        while (retry++ < 3) {
            try {
                return this.allocateSegment(project, dataflowId, retainSegments, currLayer);
            }
            catch (KylinException e) {
                logger.error(e.getMessage(), (Throwable)e);
                StreamingUtils.sleep((long)(config.getStreamingSegmentMergeInterval() * 1000L * (long)retry));
            }
        }
        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.SEGMENT_MERGE_FAILURE, project + "/" + dataflowId);
    }

    public NDataSegment getSegment(Segments<NDataSegment> segments, NDataSegment afterMergeSeg, String project, String dataflowId) {
        NDataSegment seg = (NDataSegment)segments.getSegment(afterMergeSeg.getName(), SegmentStatusEnum.READY);
        if (seg == null) {
            seg = (NDataSegment)segments.getSegment(afterMergeSeg.getName(), SegmentStatusEnum.WARNING);
        }
        if (seg == null) {
            seg = (NDataSegment)segments.getSegment(afterMergeSeg.getName(), SegmentStatusEnum.NEW);
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            if (seg != null && !config.isUTEnv()) {
                this.removeSegment(project, dataflowId, seg);
            }
        }
        if (seg == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.SEGMENT_MERGE_FAILURE, "segment is null");
        }
        return seg;
    }

    public void removeSegment(String project, String dataflowId, NDataSegment seg) {
        String url = "/streaming_jobs/dataflow/segment/deletion";
        StreamingSegmentRequest req = new StreamingSegmentRequest(project, dataflowId);
        req.setRemoveSegment(Arrays.asList(seg));
        req.setJobType(this.jobType.name());
        req.setJobExecutionId(JobExecutionIdHolder.getJobExecutionId(this.jobId));
        try (RestSupport rest = this.createRestSupport(KylinConfig.getInstanceFromEnv());){
            rest.execute((HttpRequestBase)rest.createHttpPost(url), req);
        }
        StreamingUtils.replayAuditlog();
    }

    public NDataSegment allocateSegment(String project, String dataflowId, List<NDataSegment> retainSegments, int currLayer) {
        HashMap sourcePartitionOffsetStart = Maps.newHashMap();
        HashMap sourcePartitionOffsetEnd = Maps.newHashMap();
        AtomicLong minTime = new AtomicLong(Long.MAX_VALUE);
        AtomicLong maxTime = new AtomicLong(0L);
        retainSegments.forEach(seg -> {
            SegmentRange.KafkaOffsetPartitionedSegmentRange range = seg.getKSRange();
            if (range.getStart() != null && range.getStart() < minTime.get()) {
                minTime.set(range.getStart());
            }
            if (range.getEnd() != null && range.getEnd() > maxTime.get()) {
                maxTime.set(range.getEnd());
            }
            range.getSourcePartitionOffsetStart().forEach((partition, offset) -> {
                if (!sourcePartitionOffsetStart.containsKey(partition) || (Long)sourcePartitionOffsetStart.get(partition) > offset) {
                    sourcePartitionOffsetStart.put(partition, offset);
                }
            });
            range.getSourcePartitionOffsetEnd().forEach((partition, offset) -> {
                if (!sourcePartitionOffsetEnd.containsKey(partition) || (Long)sourcePartitionOffsetEnd.get(partition) < offset) {
                    sourcePartitionOffsetEnd.put(partition, offset);
                }
            });
        });
        SegmentRange.KafkaOffsetPartitionedSegmentRange rangeToMerge = new SegmentRange.KafkaOffsetPartitionedSegmentRange(Long.valueOf(minTime.get()), Long.valueOf(maxTime.get()), (Map)sourcePartitionOffsetStart, (Map)sourcePartitionOffsetEnd);
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataSegment afterMergeSeg = config.isUTEnv() ? (NDataSegment)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            return dfMgr.mergeSegments(dfMgr.getDataflow(dataflowId), (SegmentRange)rangeToMerge, true, Integer.valueOf(currLayer + 1), null);
        }, (String)project) : this.doMergeStreamingSegment(project, dataflowId, rangeToMerge, currLayer);
        logger.info("start sync thread for merge");
        List<NDataSegment> updatedSegments = null;
        NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)config, (String)project);
        NDataflow df = dfMgr.getDataflow(dataflowId);
        updatedSegments = retainSegments.stream().map(seg -> df.getSegment(seg.getId())).collect(Collectors.toList());
        long afterMergeSegSourceCount = retainSegments.stream().mapToLong(NDataSegment::getSourceCount).sum();
        logger.info("afterMergeSegment[{}] layer={}  from {}", new Object[]{afterMergeSeg, currLayer, updatedSegments});
        MergeJobEntry mergeJobEntry = new MergeJobEntry(this.ss, project, dataflowId, afterMergeSegSourceCount, globalMergeTime, updatedSegments, afterMergeSeg);
        SyncMerger syncMerge = new SyncMerger(mergeJobEntry);
        syncMerge.run(this.merger);
        return afterMergeSeg;
    }

    public NDataSegment doMergeStreamingSegment(String project, String dataflowId, SegmentRange.KafkaOffsetPartitionedSegmentRange rangeToMerge, int currLayer) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String url = "/streaming_jobs/dataflow/segment";
        StreamingSegmentRequest req = new StreamingSegmentRequest(project, dataflowId);
        req.setSegmentRange((SegmentRange)rangeToMerge);
        req.setLayer(String.valueOf(currLayer));
        req.setNewSegId(RandomUtil.randomUUIDStr());
        req.setJobType(this.jobType.name());
        req.setJobExecutionId(JobExecutionIdHolder.getJobExecutionId(this.jobId));
        try (RestSupport rest = this.createRestSupport(config);){
            RestResponse<String> restResponse = rest.execute((HttpRequestBase)rest.createHttpPost(url), req);
            String newSegId = (String)restResponse.getData();
            StreamingUtils.replayAuditlog();
            NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            NDataSegment nDataSegment = dfMgr.getDataflow(dataflowId).getSegment(newSegId);
            return nDataSegment;
        }
    }

    private MergePolicy selectPolicy(Segments<NDataSegment> segments, int layer) {
        Collections.sort(segments);
        if (!this.peakMergePolicy.selectMatchedSegList((List<NDataSegment>)segments, layer, this.thresholdOfSegSize, this.numberOfSeg).isEmpty()) {
            return this.peakMergePolicy;
        }
        if (!this.catchupMergePolicy.selectMatchedSegList((List<NDataSegment>)segments, layer, this.thresholdOfSegSize, this.numberOfSeg).isEmpty()) {
            return this.catchupMergePolicy;
        }
        if (!this.normalMergePolicy.selectMatchedSegList((List<NDataSegment>)segments, layer, this.thresholdOfSegSize, this.numberOfSeg).isEmpty()) {
            return this.normalMergePolicy;
        }
        return null;
    }

    private void removeLastL0Segment(Segments<NDataSegment> segments) {
        Map additionInfo;
        if (!segments.isEmpty() && (additionInfo = ((NDataSegment)segments.get(segments.size() - 1)).getAdditionalInfo()) != null && !additionInfo.containsKey("file_layer")) {
            segments.remove(segments.size() - 1);
        }
    }

    private void close(boolean isError) {
        this.merger.shutdown();
        latch.countDown();
        this.closeAuditLogStore(this.ss);
        if (!isError) {
            this.systemExit(0);
        }
    }
}

