/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.dict;

import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.spark.dict.NGlobalDictStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NGlobalDictStoreFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NGlobalDictStoreFactory.class);

    private NGlobalDictStoreFactory() {
    }

    public static NGlobalDictStore getResourceStore(String baseDir) {
        try {
            Class clz = ClassUtil.forName((String)NGlobalDictStoreFactory.getGlobalDictStoreImpl(), NGlobalDictStore.class);
            log.trace("Use global dict store impl {}", (Object)clz.getCanonicalName());
            return (NGlobalDictStore)clz.getConstructor(String.class).newInstance(baseDir);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create global dict store", e);
        }
    }

    private static String getGlobalDictStoreImpl() {
        try {
            return KylinConfig.getInstanceFromEnv().getGlobalDictV2StoreImpl();
        }
        catch (Exception e) {
            return System.getProperty("kylin.engine.global-dict.store.impl", "org.apache.spark.dict.NGlobalDictHDFSStore");
        }
    }
}

