/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasource;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.exception.TargetSegmentNotFoundException;
import org.apache.kylin.engine.spark.utils.LogUtils$;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasource.FilePruner;
import org.apache.spark.sql.execution.datasource.SegmentDirectory;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FilePruner$
implements scala.Serializable {
    public static FilePruner$ MODULE$;

    static {
        new FilePruner$();
    }

    /*
     * WARNING - void declaration
     */
    public int getPartitionId(Path p) {
        void var2_2;
        int partitionId = new StringOps(Predef$.MODULE$.augmentString(p.getName().split("-", 3)[1])).toInt();
        return (int)var2_2;
    }

    public String prunedSegmentInfo(Seq<SegmentDirectory> segDirs, Seq<SegmentDirectory> prunedDirs) {
        String string;
        Function1 & Serializable & scala.Serializable files = (Function1 & Serializable & scala.Serializable)x$18 -> (Seq)((TraversableLike)x$18.flatMap((Function1 & Serializable & scala.Serializable)s -> s.files() == null ? Nil$.MODULE$ : s.files(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToLong((long)x$19.getLen()), Seq$.MODULE$.canBuildFrom());
        Seq all = (Seq)files.apply(segDirs);
        Seq pruned = (Seq)files.apply(prunedDirs);
        String summary = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(45).append("\"nums\":\"").append(prunedDirs.size()).append("/").append(segDirs.size()).append("\",\"files\":\"").append(pruned.size()).append("/").append(all.size()).append("\",\n         |\"bytes\":\"").append(pruned.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)).append("/").append(all.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)).append("\"").toString())).stripMargin().replaceAll("\\n", " ");
        if (prunedDirs.nonEmpty() && prunedDirs.size() < segDirs.size()) {
            String prunedDetails = LogUtils$.MODULE$.jsonArray(prunedDirs, (Function1 & Serializable & scala.Serializable)x$20 -> x$20.segmentID(), ClassTag$.MODULE$.apply(String.class));
            String detail = new StringBuilder(9).append("\"pruned\":").append(prunedDetails).toString();
            string = new StringBuilder(3).append("{").append(summary).append(",").append(detail).append("}").toString();
        } else {
            string = new StringBuilder(2).append("{").append(summary).append("}").toString();
        }
        return string;
    }

    public void checkSegmentStatus(HashSet<String> prunedSegmentIds, NDataflow dataflow) {
        Set filterSegmentIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)dataflow.getSegments(prunedSegmentIds)).asScala()).map((Function1 & Serializable & scala.Serializable)e -> e.getId(), Buffer$.MODULE$.canBuildFrom())).toSet();
        if (prunedSegmentIds.size() != filterSegmentIds.size()) {
            scala.collection.mutable.StringBuilder missSegId = new scala.collection.mutable.StringBuilder();
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(prunedSegmentIds).asScala()).foreach((Function1 & Serializable & scala.Serializable)e -> !filterSegmentIds.contains(e) ? missSegId.append(e).append(";") : BoxedUnit.UNIT);
            throw new TargetSegmentNotFoundException(missSegId.toString());
        }
    }

    public boolean isHadoopMakeFile(FileStatus fileStatus) {
        boolean bl;
        block3: {
            try {
                if (fileStatus.getPath().getName().equals("_SUCCESS") || fileStatus.getPath().getName().equals("_temporary")) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public FilePruner apply(SparkSession session, Map<String, String> options, StructType dataSchema) {
        return new FilePruner(session, options, dataSchema);
    }

    public Option<Tuple3<SparkSession, Map<String, String>, StructType>> unapply(FilePruner x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.session(), x$0.options(), (Object)x$0.dataSchema()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private FilePruner$() {
        MODULE$ = this;
    }
}

