/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.celeborn.client.write.PushTask;

public class SendBufferPool {
    private static volatile SendBufferPool _instance;
    private final int capacity;
    private final LinkedList<byte[][]> buffers;
    private final LinkedList<LinkedBlockingQueue<PushTask>> pushTaskQueues;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SendBufferPool get(int capacity) {
        if (_instance != null) return _instance;
        Class<SendBufferPool> clazz = SendBufferPool.class;
        synchronized (SendBufferPool.class) {
            if (_instance != null) return _instance;
            _instance = new SendBufferPool(capacity);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _instance;
        }
    }

    private SendBufferPool(int capacity) {
        assert (capacity > 0);
        this.capacity = capacity;
        this.buffers = new LinkedList();
        this.pushTaskQueues = new LinkedList();
    }

    public synchronized byte[][] acquireBuffer(int numPartitions) {
        Iterator iterator = this.buffers.iterator();
        while (iterator.hasNext()) {
            byte[][] candidate = (byte[][])iterator.next();
            if (candidate.length != numPartitions) continue;
            iterator.remove();
            return candidate;
        }
        if (this.buffers.size() > 0) {
            this.buffers.removeFirst();
        }
        return new byte[numPartitions][];
    }

    public synchronized LinkedBlockingQueue<PushTask> acquirePushTaskQueue() {
        if (!this.pushTaskQueues.isEmpty()) {
            return this.pushTaskQueues.removeFirst();
        }
        return null;
    }

    public synchronized void returnBuffer(byte[][] buffer) {
        if (this.buffers.size() == this.capacity) {
            this.buffers.removeFirst();
        }
        this.buffers.addLast(buffer);
    }

    public synchronized void returnPushTaskQueue(LinkedBlockingQueue<PushTask> pushTaskQueue) {
        if (this.pushTaskQueues.size() == this.capacity) {
            this.pushTaskQueues.removeFirst();
        }
        this.pushTaskQueues.addLast(pushTaskQueue);
    }
}

