/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.inmemory;

import java.util.Map;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.inmemory.InMemoryInputFile;
import org.apache.iceberg.inmemory.InMemoryOutputFile;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class InMemoryFileIO
implements FileIO {
    private final Map<String, byte[]> inMemoryFiles = Maps.newConcurrentMap();
    private boolean closed = false;

    public void addFile(String location, byte[] contents) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cannot call addFile after calling close()");
        this.inMemoryFiles.put(location, contents);
    }

    public boolean fileExists(String location) {
        return this.inMemoryFiles.containsKey(location);
    }

    public InputFile newInputFile(String location) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cannot call newInputFile after calling close()");
        byte[] contents = this.inMemoryFiles.get(location);
        if (null == contents) {
            throw new NotFoundException("No in-memory file found for location: %s", new Object[]{location});
        }
        return new InMemoryInputFile(location, contents);
    }

    public OutputFile newOutputFile(String location) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cannot call newOutputFile after calling close()");
        return new InMemoryOutputFile(location, this);
    }

    public void deleteFile(String location) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cannot call deleteFile after calling close()");
        if (null == this.inMemoryFiles.remove(location)) {
            throw new NotFoundException("No in-memory file found for location: %s", new Object[]{location});
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
    }
}

