/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.monitoring.health;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerConfigurationProperties;
import io.github.resilience4j.common.circuitbreaker.configuration.CircuitBreakerConfigurationProperties;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.actuate.health.StatusAggregator;

public class CircuitBreakersHealthIndicator
implements HealthIndicator {
    private static final String FAILURE_RATE = "failureRate";
    private static final String SLOW_CALL_RATE = "slowCallRate";
    private static final String FAILURE_RATE_THRESHOLD = "failureRateThreshold";
    private static final String SLOW_CALL_RATE_THRESHOLD = "slowCallRateThreshold";
    private static final String BUFFERED_CALLS = "bufferedCalls";
    private static final String FAILED_CALLS = "failedCalls";
    private static final String SLOW_CALLS = "slowCalls";
    private static final String SLOW_FAILED_CALLS = "slowFailedCalls";
    private static final String NOT_PERMITTED = "notPermittedCalls";
    private static final String STATE = "state";
    private final CircuitBreakerRegistry circuitBreakerRegistry;
    private final CircuitBreakerConfigurationProperties circuitBreakerProperties;
    private final StatusAggregator statusAggregator;

    public CircuitBreakersHealthIndicator(CircuitBreakerRegistry circuitBreakerRegistry, CircuitBreakerConfigurationProperties circuitBreakerProperties, StatusAggregator statusAggregator) {
        this.circuitBreakerRegistry = circuitBreakerRegistry;
        this.circuitBreakerProperties = circuitBreakerProperties;
        this.statusAggregator = statusAggregator;
    }

    private static Health.Builder addDetails(Health.Builder builder, CircuitBreaker circuitBreaker) {
        CircuitBreaker.Metrics metrics = circuitBreaker.getMetrics();
        CircuitBreakerConfig config = circuitBreaker.getCircuitBreakerConfig();
        builder.withDetail(FAILURE_RATE, (Object)(metrics.getFailureRate() + "%")).withDetail(FAILURE_RATE_THRESHOLD, (Object)(config.getFailureRateThreshold() + "%")).withDetail(SLOW_CALL_RATE, (Object)(metrics.getSlowCallRate() + "%")).withDetail(SLOW_CALL_RATE_THRESHOLD, (Object)(config.getSlowCallRateThreshold() + "%")).withDetail(BUFFERED_CALLS, (Object)metrics.getNumberOfBufferedCalls()).withDetail(SLOW_CALLS, (Object)metrics.getNumberOfSlowCalls()).withDetail(SLOW_FAILED_CALLS, (Object)metrics.getNumberOfSlowFailedCalls()).withDetail(FAILED_CALLS, (Object)metrics.getNumberOfFailedCalls()).withDetail(NOT_PERMITTED, (Object)metrics.getNumberOfNotPermittedCalls()).withDetail(STATE, (Object)circuitBreaker.getState());
        return builder;
    }

    private boolean allowHealthIndicatorToFail(CircuitBreaker circuitBreaker) {
        return this.circuitBreakerProperties.findCircuitBreakerProperties(circuitBreaker.getName()).map(CircuitBreakerConfigurationProperties.InstanceProperties::getAllowHealthIndicatorToFail).orElse(false);
    }

    private Health mapBackendMonitorState(CircuitBreaker circuitBreaker) {
        switch (circuitBreaker.getState()) {
            case CLOSED: {
                return CircuitBreakersHealthIndicator.addDetails(Health.up(), circuitBreaker).build();
            }
            case OPEN: {
                boolean allowHealthIndicatorToFail = this.allowHealthIndicatorToFail(circuitBreaker);
                return CircuitBreakersHealthIndicator.addDetails(allowHealthIndicatorToFail ? Health.down() : Health.status((String)"CIRCUIT_OPEN"), circuitBreaker).build();
            }
            case HALF_OPEN: {
                return CircuitBreakersHealthIndicator.addDetails(Health.status((String)"CIRCUIT_HALF_OPEN"), circuitBreaker).build();
            }
        }
        return CircuitBreakersHealthIndicator.addDetails(Health.unknown(), circuitBreaker).build();
    }

    private boolean isRegisterHealthIndicator(CircuitBreaker circuitBreaker) {
        return this.circuitBreakerProperties.findCircuitBreakerProperties(circuitBreaker.getName()).map(CircuitBreakerConfigurationProperties.InstanceProperties::getRegisterHealthIndicator).orElse(false);
    }

    public Health health() {
        Map<String, Health> healths = this.circuitBreakerRegistry.getAllCircuitBreakers().toJavaStream().filter(this::isRegisterHealthIndicator).collect(Collectors.toMap(CircuitBreaker::getName, this::mapBackendMonitorState));
        Status status = this.statusAggregator.getAggregateStatus(healths.values().stream().map(Health::getStatus).collect(Collectors.toSet()));
        return Health.status((Status)status).withDetails(healths).build();
    }
}

