/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.kylin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.cache.fs.AbstractCacheFileSystem;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinCacheFileSystem
extends AbstractCacheFileSystem {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KylinCacheFileSystem.class);
    private static final Pattern ACCEPT_CACHE_TIME_PATTERN = Pattern.compile("ACCEPT_CACHE_TIME\\([^()]*\\)");

    @Override
    protected boolean isUseLocalCacheForCurrentExecutor() {
        if (null == TaskContext.get()) {
            log.warn("Task Context is null.");
            return false;
        }
        String localCacheForCurrExecutor = TaskContext.get().getLocalProperty("spark.kylin.local-cache.for.current.files");
        if (StringUtils.isBlank((CharSequence)localCacheForCurrExecutor)) {
            return true;
        }
        return Boolean.parseBoolean(localCacheForCurrExecutor);
    }

    @Override
    protected long getAcceptCacheTime() {
        return KylinCacheFileSystem.getAcceptCacheTimeLocally();
    }

    public static String processAcceptCacheTimeInHintStr(String hintStr) {
        String time = KylinCacheFileSystem.extractAcceptCacheTime(hintStr);
        KylinCacheFileSystem.setAcceptCacheTimeLocally(time);
        return time;
    }

    public static String extractAcceptCacheTime(String hintStr) {
        Matcher matcher;
        String time = null;
        if (StringUtils.isNotBlank((CharSequence)hintStr) && (matcher = ACCEPT_CACHE_TIME_PATTERN.matcher(hintStr)).find(0)) {
            String acceptCacheTimeHint = matcher.group();
            time = KylinCacheFileSystem.extractTime(acceptCacheTimeHint);
        }
        return time;
    }

    public static String extractTime(String hint) {
        if (StringUtils.isBlank((CharSequence)hint) || hint.indexOf("ACCEPT_CACHE_TIME(") != 0) {
            return null;
        }
        String[] parts = hint.replace("ACCEPT_CACHE_TIME(", "").replace(")", "").split(",");
        if (parts.length < 1) {
            return null;
        }
        return parts[0];
    }

    public static void setAcceptCacheTimeLocally(String acceptCacheTime) {
        KylinCacheFileSystem.setAcceptCacheTimeLocally(acceptCacheTime == null ? System.currentTimeMillis() : Long.parseLong(acceptCacheTime));
    }

    public static void setAcceptCacheTimeLocally(long acceptCacheTime) {
        Preconditions.checkState((boolean)SparkSession.getDefaultSession().isDefined());
        SparkContext sparkContext = ((SparkSession)SparkSession.getDefaultSession().get()).sparkContext();
        String key = "spark.kylin.local-cache.accept-cache-time";
        long now = System.currentTimeMillis();
        if (acceptCacheTime > now + 1000L) {
            log.error("Accept-cache-time {} is later than clock time {}. Please check the time sync across machines.", (Object)acceptCacheTime, (Object)now);
            acceptCacheTime = now;
        }
        if (sparkContext.getLocalProperty(key) != null) {
            acceptCacheTime = Math.max(acceptCacheTime, Long.parseLong(sparkContext.getLocalProperty(key)));
        }
        sparkContext.setLocalProperty(key, Long.toString(acceptCacheTime));
        sparkContext.setLocalProperty("spark.gluten.sql.columnar.backend.ch.runtime_settings.spark.kylin.local-cache.accept-cache-time", Long.toString(acceptCacheTime));
    }

    public static void clearAcceptCacheTimeLocally() {
        Preconditions.checkState((boolean)SparkSession.getDefaultSession().isDefined());
        SparkContext sparkContext = ((SparkSession)SparkSession.getDefaultSession().get()).sparkContext();
        sparkContext.setLocalProperty("spark.kylin.local-cache.accept-cache-time", null);
        sparkContext.setLocalProperty("spark.gluten.sql.columnar.backend.ch.runtime_settings.spark.kylin.local-cache.accept-cache-time", null);
        if (TaskContext.get() != null) {
            TaskContext.get().getLocalProperties().remove("spark.kylin.local-cache.accept-cache-time");
            TaskContext.get().getLocalProperties().remove("spark.gluten.sql.columnar.backend.ch.runtime_settings.spark.kylin.local-cache.accept-cache-time");
        }
    }

    public static long getAcceptCacheTimeLocally() {
        SparkContext ctx;
        String prop;
        String key = "spark.kylin.local-cache.accept-cache-time";
        long ret = System.currentTimeMillis();
        if (TaskContext.get() != null) {
            String prop2 = TaskContext.get().getLocalProperty(key);
            if (prop2 != null) {
                ret = Long.parseLong(prop2);
            }
        } else if (SparkSession.getDefaultSession().isDefined() && (prop = (ctx = ((SparkSession)SparkSession.getDefaultSession().get()).sparkContext()).getLocalProperty(key)) != null) {
            ret = Long.parseLong(prop);
        }
        return ret;
    }
}

