/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.rest.BaseFilter;
import org.apache.kylin.rest.service.RouteService;
import org.glassfish.jersey.uri.UriTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@Order(value=-2147483644)
public class MultiTenantModeFilter
extends BaseFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiTenantModeFilter.class);
    private static final Set<String> NOT_ROUTE_APIS = Sets.newHashSet();
    private static final Set<String> ASYNC_QUERY_APIS = Sets.newHashSet();
    private static final Set<String> ROUTES_APIS = Sets.newHashSet();
    private static final Set<String> JOB_APIS = Sets.newHashSet();
    private static final Set<String> V2_CUBES_APIS = Sets.newHashSet();
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RouteService routeService;

    public void init(FilterConfig filterConfig) throws ServletException {
        log.info("init multi tenant mode filter");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            if (this.routeService.needRoute()) {
                String uri = StringUtils.stripEnd((String)httpServletRequest.getRequestURI(), (String)"/");
                if (this.checkIsRoutedApi(httpServletRequest, uri)) {
                    chain.doFilter(servletRequest, servletResponse);
                    return;
                }
                Pair result = this.checkNeedToRouteAndGetProject(httpServletRequest, uri);
                if (((Boolean)result.getFirst()).booleanValue()) {
                    String project = (String)result.getSecond();
                    if (StringUtils.isNotBlank((CharSequence)project)) {
                        httpServletRequest.setAttribute("project", (Object)project);
                    }
                    log.debug("proxy {} {} to all", (Object)httpServletRequest.getMethod(), (Object)httpServletRequest.getRequestURI());
                    this.routeAPI(this.restTemplate, servletRequest, servletResponse, project);
                    return;
                }
            }
            chain.doFilter(servletRequest, servletResponse);
            return;
        }
        throw new KylinRuntimeException("unknown status");
    }

    public void destroy() {
    }

    private boolean checkIsRoutedApi(HttpServletRequest servletRequest, String uri) {
        return "true".equalsIgnoreCase(servletRequest.getHeader("routed")) || NOT_ROUTE_APIS.contains(uri);
    }

    private Pair<Boolean, String> checkNeedToRouteAndGetProject(HttpServletRequest servletRequest, String uri) {
        Pair matchAsyncQueryApis = this.matchAsyncQueryApis(uri);
        if (Objects.nonNull(matchAsyncQueryApis)) {
            return matchAsyncQueryApis;
        }
        Pair matchRoutesApis = this.matchRoutesApis(servletRequest, uri);
        if (Objects.nonNull(matchRoutesApis)) {
            return matchRoutesApis;
        }
        Pair matchJobApis = this.matchJobApis(servletRequest, uri);
        if (Objects.nonNull(matchJobApis)) {
            return matchJobApis;
        }
        Pair matchV2CubesApis = this.matchV2CubesApis(servletRequest, uri);
        if (Objects.nonNull(matchV2CubesApis)) {
            return matchV2CubesApis;
        }
        return Pair.newPair((Object)false, (Object)"");
    }

    private Pair<Boolean, String> matchAsyncQueryApis(String uri) {
        for (String needParserUrl : ASYNC_QUERY_APIS) {
            HashMap kvMap;
            UriTemplate uriTemplate = new UriTemplate(needParserUrl);
            if (!uriTemplate.match((CharSequence)uri, kvMap = new HashMap())) continue;
            return Pair.newPair((Object)true, (Object)"");
        }
        return null;
    }

    private Pair<Boolean, String> matchRoutesApis(HttpServletRequest servletRequest, String uri) {
        for (String needParserUrl : ROUTES_APIS) {
            HashMap kvMap;
            UriTemplate uriTemplate = new UriTemplate(needParserUrl);
            if (!uriTemplate.match((CharSequence)uri, kvMap = new HashMap())) continue;
            String accept = servletRequest.getHeader("Accept");
            return Pair.newPair((Object)StringUtils.equals((CharSequence)accept, (CharSequence)"application/vnd.apache.kylin-v2+json"), (Object)"");
        }
        return null;
    }

    private Pair<Boolean, String> matchJobApis(HttpServletRequest servletRequest, String uri) {
        for (String needParserUrl : JOB_APIS) {
            HashMap kvMap;
            UriTemplate uriTemplate = new UriTemplate(needParserUrl);
            if (!uriTemplate.match((CharSequence)uri, kvMap = new HashMap())) continue;
            return this.getJobApisProject(servletRequest, kvMap);
        }
        return null;
    }

    private Pair<Boolean, String> matchV2CubesApis(HttpServletRequest servletRequest, String uri) {
        for (String needParserUrl : V2_CUBES_APIS) {
            HashMap kvMap;
            UriTemplate uriTemplate = new UriTemplate(needParserUrl);
            if (!uriTemplate.match((CharSequence)uri, kvMap = new HashMap())) continue;
            return this.getV2CubesApisProject(servletRequest, kvMap);
        }
        return null;
    }

    private Pair<Boolean, String> getJobApisProject(HttpServletRequest request, HashMap<String, String> kvMap) {
        String accept = request.getHeader("Accept");
        if (StringUtils.equals((CharSequence)accept, (CharSequence)"application/vnd.apache.kylin-v2+json")) {
            String jobId = kvMap.get("jobId");
            String project = this.routeService.getProjectByJobIdUseInFilter(jobId);
            return Pair.newPair((Object)true, (Object)project);
        }
        return Pair.newPair((Object)false, (Object)"");
    }

    private Pair<Boolean, String> getV2CubesApisProject(HttpServletRequest request, HashMap<String, String> kvMap) {
        String accept = request.getHeader("Accept");
        if (StringUtils.equals((CharSequence)accept, (CharSequence)"application/vnd.apache.kylin-v2+json")) {
            String project = request.getParameter("project");
            if (StringUtils.isNotEmpty((CharSequence)project)) {
                return Pair.newPair((Object)true, (Object)project);
            }
            String cubeName = kvMap.get("cubeName");
            String projectName = this.routeService.getProjectByModelNameUseInFilter(cubeName);
            return Pair.newPair((Object)true, (Object)projectName);
        }
        return Pair.newPair((Object)false, (Object)"");
    }

    static {
        NOT_ROUTE_APIS.add("/kylin/api/access/all/users");
        NOT_ROUTE_APIS.add("/kylin/api/access/all/groups");
        List<String> asyncQuerySubUris = Arrays.asList("status", "file_status", "metadata", "result_download", "result_path");
        asyncQuerySubUris.forEach(asyncQuerySubUri -> ASYNC_QUERY_APIS.add(String.format(Locale.ROOT, "/kylin/api/async_query/{query_id}/%s", asyncQuerySubUri)));
        ROUTES_APIS.add("/kylin/api/access/{type}/{project}");
        ROUTES_APIS.add("/kylin/api/cube_desc/{projectName}/{cubeName}");
        ROUTES_APIS.add("/kylin/api/cubes");
        JOB_APIS.add("/kylin/api/jobs/{jobId}");
        JOB_APIS.add("/kylin/api/jobs/{jobId}/resume");
        JOB_APIS.add("/kylin/api/jobs/{jobId}/steps/{step_id}/output");
        V2_CUBES_APIS.add("/kylin/api/cubes/{cubeName}");
        V2_CUBES_APIS.add("/kylin/api/cubes/{cubeName}/rebuild");
        V2_CUBES_APIS.add("/kylin/api/cubes/{cubeName}/segments");
        V2_CUBES_APIS.add("/kylin/api/cubes/{cubeName}/holes");
        V2_CUBES_APIS.add("/kylin/api/cubes/{cubeName}/sql");
    }
}

