/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.calcite;

import java.util.Locale;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.metadata.project.NProjectManager;
import org.checkerframework.checker.nullness.qual.Nullable;

public class KylinRelDataTypeSystem
extends RelDataTypeSystemImpl {
    private static final int MINIMUM_ADJUSTED_SCALE = 6;
    private static final int MAX_PRECISION = 38;
    private static final int MAX_SCALE = 38;
    public static final int SUM_RESULT_PRECISION_INCREASE = 10;

    public RelDataType deriveAvgAggType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        if (argumentType instanceof BasicSqlType) {
            switch (argumentType.getSqlTypeName()) {
                case DECIMAL: {
                    return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL, argumentType.getPrecision() + 4, argumentType.getScale() + 4), argumentType.isNullable());
                }
            }
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), argumentType.isNullable());
        }
        return super.deriveAvgAggType(typeFactory, argumentType);
    }

    public RelDataType deriveSumType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        if (argumentType instanceof BasicSqlType) {
            switch (argumentType.getSqlTypeName()) {
                case INTEGER: 
                case SMALLINT: 
                case TINYINT: {
                    return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), argumentType.isNullable());
                }
                case DECIMAL: {
                    int precision = Math.max(19, argumentType.getPrecision());
                    if (KylinRelDataTypeSystem.getProjectConfig().isImprovedSumDecimalPrecisionEnabled()) {
                        precision = Math.min(38, argumentType.getPrecision() + 10);
                    }
                    return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL, precision, argumentType.getScale()), argumentType.isNullable());
                }
            }
        }
        return argumentType;
    }

    public @Nullable RelDataType deriveDecimalDivideType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        if (SqlTypeUtil.isExactNumeric((RelDataType)type1) && SqlTypeUtil.isExactNumeric((RelDataType)type2) && (SqlTypeUtil.isDecimal((RelDataType)type1) || SqlTypeUtil.isDecimal((RelDataType)type2))) {
            RelDataType ret;
            type1 = RelDataTypeFactoryImpl.isJavaType((RelDataType)type1) ? typeFactory.decimalOf(type1) : type1;
            type2 = RelDataTypeFactoryImpl.isJavaType((RelDataType)type2) ? typeFactory.decimalOf(type2) : type2;
            int p1 = type1.getPrecision();
            int p2 = type2.getPrecision();
            int s1 = type1.getScale();
            int s2 = type2.getScale();
            boolean decimalOperationsAllowPrecisionLoss = KylinConfig.getInstanceFromEnv().decimalOperationsAllowPrecisionLoss();
            if (decimalOperationsAllowPrecisionLoss) {
                int intDig = p1 - s1 + s2;
                int scale = Math.max(6, s1 + p2 + 1);
                int prec = intDig + scale;
                ret = this.adjustPrecisionScale(typeFactory, prec, scale);
            } else {
                int decDig;
                int intDig = Math.min(38, p1 - s1 + s2);
                int diff = intDig + (decDig = Math.min(38, Math.max(6, s1 + p2 + 1))) - 38;
                if (diff > 0) {
                    intDig = 38 - (decDig -= diff / 2 + 1);
                }
                ret = this.bounded(typeFactory, intDig + decDig, decDig);
            }
            return ret;
        }
        return null;
    }

    private void checkNegativeScale(int scale) {
        if (scale < 0 && !KylinConfig.getInstanceFromEnv().allowNegativeScaleOfDecimalEnabled()) {
            throw new KylinRuntimeException(String.format(Locale.ROOT, "Negative scale is not allowed: %s. You can use %s=true to enable legacy mode to allow it.", scale, "kylin.storage.columnar.spark-conf.spark.sql.legacy.allowNegativeScaleOfDecimal"));
        }
    }

    private RelDataType adjustPrecisionScale(RelDataTypeFactory typeFactory, int precision, int scale) {
        this.checkNegativeScale(scale);
        assert (precision >= scale);
        if (precision <= 38) {
            return typeFactory.createSqlType(SqlTypeName.DECIMAL, precision, scale);
        }
        if (scale < 0) {
            return typeFactory.createSqlType(SqlTypeName.DECIMAL, 38, scale);
        }
        int intDigits = precision - scale;
        int minScaleValue = Math.min(scale, 6);
        int adjustedScale = Math.max(38 - intDigits, minScaleValue);
        return typeFactory.createSqlType(SqlTypeName.DECIMAL, 38, adjustedScale);
    }

    private RelDataType bounded(RelDataTypeFactory typeFactory, int precision, int scale) {
        return typeFactory.createSqlType(SqlTypeName.DECIMAL, Math.min(precision, 38), Math.min(scale, 38));
    }

    public @Nullable RelDataType deriveDecimalMultiplyType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        if (SqlTypeUtil.isExactNumeric((RelDataType)type1) && SqlTypeUtil.isExactNumeric((RelDataType)type2) && (SqlTypeUtil.isDecimal((RelDataType)type1) || SqlTypeUtil.isDecimal((RelDataType)type2))) {
            type1 = RelDataTypeFactoryImpl.isJavaType((RelDataType)type1) ? typeFactory.decimalOf(type1) : type1;
            type2 = RelDataTypeFactoryImpl.isJavaType((RelDataType)type2) ? typeFactory.decimalOf(type2) : type2;
            int p1 = type1.getPrecision();
            int p2 = type2.getPrecision();
            int s1 = type1.getScale();
            int s2 = type2.getScale();
            boolean decimalOperationsAllowPrecisionLoss = KylinConfig.getInstanceFromEnv().decimalOperationsAllowPrecisionLoss();
            int resultScale = s1 + s2;
            int resultPrecision = p1 + p2 + 1;
            RelDataType ret = decimalOperationsAllowPrecisionLoss ? this.adjustPrecisionScale(typeFactory, resultPrecision, resultScale) : this.bounded(typeFactory, resultPrecision, resultScale);
            return ret;
        }
        return null;
    }

    public int getMaxNumericPrecision() {
        return 38;
    }

    public boolean shouldConvertRaggedUnionTypesToVarying() {
        return true;
    }

    public int getDefaultScale(SqlTypeName typeName) {
        switch (typeName) {
            case DECIMAL: {
                return KapConfig.getInstanceFromEnv().defaultDecimalScale();
            }
        }
        return super.getDefaultScale(typeName);
    }

    public static KylinConfig getProjectConfig() {
        return NProjectManager.getProjectConfig((String)QueryContext.current().getProject());
    }
}

