/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.security;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AccessDeniedException
extends RuntimeException {
    public AccessDeniedException(String s) {
        super("Query failed, access " + s + " denied");
    }

    public AccessDeniedException(Set<String> unautorizedTables, Set<String> unautorizedColumns) {
        super(AccessDeniedException.pasteToErrorMsg(unautorizedTables, unautorizedColumns));
    }

    private static String pasteToErrorMsg(Set<String> unautorizedTables, Set<String> unautorizedColumns) {
        StringBuilder errMsg = new StringBuilder("Query failed. You are not authorized to ");
        if (!unautorizedTables.isEmpty()) {
            String unautorizedTableStr = StringUtils.join(unautorizedTables, (String)",");
            errMsg.append("tables ");
            errMsg.append(unautorizedTableStr);
        }
        if (!unautorizedColumns.isEmpty()) {
            if (!unautorizedTables.isEmpty()) {
                errMsg.append(", ");
            }
            String unautorizedColumnStr = StringUtils.join(unautorizedColumns, (String)",");
            errMsg.append("columns ");
            errMsg.append(unautorizedColumnStr);
        }
        errMsg.append(".");
        return errMsg.toString();
    }
}

