/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import lombok.Generated;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.alias.ExpressionComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelViewSqlNodeComparator
extends ExpressionComparator.SqlNodeComparator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelViewSqlNodeComparator.class);
    private final NDataModel model;

    public ModelViewSqlNodeComparator(NDataModel model) {
        this.model = model;
    }

    protected boolean isSqlIdentifierEqual(SqlIdentifier querySqlIdentifier, SqlIdentifier exprSqlIdentifier) {
        if (querySqlIdentifier.isStar()) {
            return exprSqlIdentifier.isStar();
        }
        if (exprSqlIdentifier.isStar()) {
            return false;
        }
        try {
            String queryCol = null;
            if (querySqlIdentifier.names.size() == 1) {
                queryCol = (String)querySqlIdentifier.names.get(0);
            } else if (querySqlIdentifier.names.size() == 2) {
                queryCol = (String)querySqlIdentifier.names.get(1);
            }
            NDataModel.NamedColumn modelCol = this.model.getColumnByColumnNameInModel(queryCol);
            String modelColTableAlias = modelCol.getAliasDotColumn().split("\\.")[0];
            String modelColName = modelCol.getAliasDotColumn().split("\\.")[1];
            return StringUtils.equalsIgnoreCase((CharSequence)modelColTableAlias, (CharSequence)((CharSequence)exprSqlIdentifier.names.get(0))) && StringUtils.equalsIgnoreCase((CharSequence)modelColName, (CharSequence)((CharSequence)exprSqlIdentifier.names.get(1)));
        }
        catch (IllegalStateException | NullPointerException e) {
            log.trace("met exception when doing expressions[{}, {}] comparison", new Object[]{querySqlIdentifier, exprSqlIdentifier, e});
            return false;
        }
    }
}

