/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.query.util.ParseException;
import org.apache.kylin.query.util.RawSql;
import org.apache.kylin.query.util.RawSqlBlock;
import org.apache.kylin.query.util.RawSqlParserConstants;
import org.apache.kylin.query.util.RawSqlParserTokenManager;
import org.apache.kylin.query.util.SimpleCharStream;
import org.apache.kylin.query.util.Token;

public class RawSqlParser
implements RawSqlParserConstants {
    private String sql;
    public RawSqlParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[6];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static void main(String[] args) throws Exception {
        String SQL = "select /*+ MODEL_PRIORITY(model1, model2), ACCEPT_CACHE_TIME(123123) */ 'col1-;1', col2 -- comment1;\nfrom table -- comment2\n/* comment3\n   comment4;\n   comment5\n*/\nlimit /* comment6 */ 10; -- comment7;";
        System.out.println("--------------Input Sql---------------");
        System.out.println("select /*+ MODEL_PRIORITY(model1, model2), ACCEPT_CACHE_TIME(123123) */ 'col1-;1', col2 -- comment1;\nfrom table -- comment2\n/* comment3\n   comment4;\n   comment5\n*/\nlimit /* comment6 */ 10; -- comment7;");
        RawSqlParser parser = new RawSqlParser(new StringReader("select /*+ MODEL_PRIORITY(model1, model2), ACCEPT_CACHE_TIME(123123) */ 'col1-;1', col2 -- comment1;\nfrom table -- comment2\n/* comment3\n   comment4;\n   comment5\n*/\nlimit /* comment6 */ 10; -- comment7;"));
        ArrayList<RawSqlBlock> stmtBlockList = new ArrayList<RawSqlBlock>();
        ArrayList<RawSqlBlock> allBlockList = new ArrayList<RawSqlBlock>();
        parser.DoParse(stmtBlockList, allBlockList);
        System.out.println();
        System.out.println("--------------Statements Only---------------");
        StringBuilder stmt = new StringBuilder();
        int prevEndLine = -1;
        for (int i = 0; i < stmtBlockList.size(); ++i) {
            RawSqlBlock block = (RawSqlBlock)stmtBlockList.get(i);
            String text = block.getText().trim();
            if (i == stmtBlockList.size() - 1 && ";".equals(text.substring(text.length() - 1))) {
                text = text.substring(0, text.length() - 1);
            }
            if (block.getBeginLine() > prevEndLine) {
                if (prevEndLine != -1) {
                    stmt.append("\n");
                }
                stmt.append(text);
            } else if (block.getBeginLine() == prevEndLine) {
                stmt.append(" ");
                stmt.append(text);
            }
            prevEndLine = block.getEndLine();
        }
        System.out.println(stmt);
        System.out.println();
        System.out.println("--------------Full Text---------------");
        StringBuilder fullText = new StringBuilder();
        for (RawSqlBlock block : allBlockList) {
            String text = block.getText();
            if (block.getType() == RawSqlBlock.Type.STATEMENT && block.equals(stmtBlockList.get(stmtBlockList.size() - 1))) {
                char c;
                for (int i = text.length() - 1; i >= 0 && (c = text.charAt(i)) != '\'' && c != '\"'; --i) {
                    if (c != ';') continue;
                    text = text.substring(0, i) + text.substring(i + 1);
                }
            }
            fullText.append(text);
        }
        System.out.println(fullText);
    }

    public RawSqlParser(String sql) {
        this(new StringReader(sql.trim()));
        this.sql = sql.trim();
    }

    public RawSql parse() throws ParseException {
        ArrayList<RawSqlBlock> stmtBlockList = new ArrayList<RawSqlBlock>();
        ArrayList<RawSqlBlock> allBlockList = new ArrayList<RawSqlBlock>();
        this.DoParse(stmtBlockList, allBlockList);
        return new RawSql(this.sql, stmtBlockList, allBlockList);
    }

    private final void DoParse(List<RawSqlBlock> stmtBlockList, List<RawSqlBlock> allBlockList) throws ParseException {
        block10: while (true) {
            RawSqlBlock block;
            if (this.jj_2_1(2)) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new ParseException("RawSqlParser is interrupted");
                }
                block = this.Comment();
                if (block.getText().contains("CubePriority(")) {
                    stmtBlockList.add(block);
                }
                allBlockList.add(block);
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 2: 
                    case 3: 
                    case 6: 
                    case 13: 
                    case 15: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 6: {
                                block = this.Hint();
                                break;
                            }
                            case 2: 
                            case 3: 
                            case 13: 
                            case 15: {
                                block = this.Stmt();
                                break;
                            }
                            default: {
                                this.jj_la1[0] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        stmtBlockList.add(block);
                        allBlockList.add(block);
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 11: 
                case 13: 
                case 15: {
                    continue block10;
                }
            }
            break;
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(0);
    }

    private final RawSqlBlock Comment() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                t = this.jj_consume_token(1);
                break;
            }
            case 11: {
                t = this.jj_consume_token(11);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new RawSqlBlock(t.image, RawSqlBlock.Type.COMMENT, t.beginLine, t.beginColumn, t.endLine, t.endColumn);
    }

    private final RawSqlBlock Hint() throws ParseException {
        Token t = this.jj_consume_token(6);
        return new RawSqlBlock(t.image, RawSqlBlock.Type.HINT, t.beginLine, t.beginColumn, t.endLine, t.endColumn);
    }

    private final RawSqlBlock Stmt() throws ParseException {
        StringBuilder stmtBuilder = new StringBuilder();
        int beginLine = -1;
        int beginColumn = -1;
        int endLine = -1;
        int endColumn = -1;
        block9: while (true) {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    t = this.jj_consume_token(13);
                    break;
                }
                case 15: {
                    t = this.jj_consume_token(15);
                    break;
                }
                case 2: {
                    t = this.jj_consume_token(2);
                    break;
                }
                case 3: {
                    t = this.jj_consume_token(3);
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            stmtBuilder.append(t.image);
            beginLine = beginLine == -1 ? t.beginLine : Math.min(beginLine, t.beginLine);
            beginColumn = beginColumn == -1 ? t.beginColumn : Math.min(beginColumn, t.beginColumn);
            endLine = Math.max(endLine, t.endLine);
            endColumn = Math.max(endColumn, t.endColumn);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: 
                case 3: 
                case 13: 
                case 15: {
                    continue block9;
                }
            }
            break;
        }
        this.jj_la1[5] = this.jj_gen;
        return new RawSqlBlock(stmtBuilder.toString(), RawSqlBlock.Type.STATEMENT, beginLine, beginColumn, endLine, endColumn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private boolean jj_3R_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(1)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(11)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_3R_3();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{41036, 41036, 43086, 2050, 40972, 40972};
    }

    public RawSqlParser(InputStream stream) {
        this(stream, null);
    }

    public RawSqlParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new RawSqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public RawSqlParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new RawSqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public RawSqlParser(RawSqlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(RawSqlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[16];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 6; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 16; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        RawSqlParser.jj_la1_init_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

