/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.execution.datasources.FakeRow;
import org.apache.spark.sql.execution.datasources.FileFormatDataWriter;
import org.apache.spark.sql.execution.datasources.SingleDirectoryDataWriter$;
import org.apache.spark.sql.execution.datasources.WriteJobDescription;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\n\u0015\u0001\u0005B\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011%Q\u0006\u00011AA\u0002\u0013%1\fC\u0005a\u0001\u0001\u0007\t\u0019!C\u0005C\"Iq\r\u0001a\u0001\u0002\u0003\u0006K\u0001\u0018\u0005\nQ\u0002\u0001\r\u00111A\u0005\n%D\u0011\"\u001c\u0001A\u0002\u0003\u0007I\u0011\u00028\t\u0013A\u0004\u0001\u0019!A!B\u0013Q\u0007\"B9\u0001\t\u0013\u0011\b\"B:\u0001\t\u0013!\b\"B?\u0001\t\u0003rx!CA\u0001)\u0005\u0005\t\u0012AA\u0002\r!\u0019B#!A\t\u0002\u0005\u0015\u0001BB*\u0011\t\u0003\ti\u0001C\u0005\u0002\u0010A\t\n\u0011\"\u0001\u0002\u0012\tI2+\u001b8hY\u0016$\u0015N]3di>\u0014\u0018\u0010R1uC^\u0013\u0018\u000e^3s\u0015\t)b#A\u0006eCR\f7o\\;sG\u0016\u001c(BA\f\u0019\u0003%)\u00070Z2vi&|gN\u0003\u0002\u001a5\u0005\u00191/\u001d7\u000b\u0005ma\u0012!B:qCJ\\'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001EA\u00111\u0005J\u0007\u0002)%\u0011Q\u0005\u0006\u0002\u0015\r&dWMR8s[\u0006$H)\u0019;b/JLG/\u001a:\u0002\u0017\u0011,7o\u0019:jaRLwN\u001c\t\u0003G!J!!\u000b\u000b\u0003']\u0013\u0018\u000e^3K_\n$Um]2sSB$\u0018n\u001c8\u0002%Q\f7o[!ui\u0016l\u0007\u000f^\"p]R,\u0007\u0010\u001e\t\u0003YEj\u0011!\f\u0006\u0003]=\n\u0011\"\\1qe\u0016$WoY3\u000b\u0005Ab\u0012A\u00025bI>|\u0007/\u0003\u00023[\t\u0011B+Y:l\u0003R$X-\u001c9u\u0007>tG/\u001a=u\u0003%\u0019w.\\7jiR,'\u000f\u0005\u00026u5\taG\u0003\u00028q\u0005\u0011\u0011n\u001c\u0006\u0003si\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003wY\u0012!CR5mK\u000e{W.\\5u!J|Go\\2pY\u0006i1-^:u_6lU\r\u001e:jGN\u0004BAP$K\u001b:\u0011q(\u0012\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u0002\na\u0001\u0010:p_Rt$\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b\u0015A\u0002)sK\u0012,g-\u0003\u0002I\u0013\n\u0019Q*\u00199\u000b\u0005\u0019\u001b\u0005C\u0001 L\u0013\ta\u0015J\u0001\u0004TiJLgn\u001a\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!Z\ta!\\3ue&\u001c\u0017B\u0001*P\u0005%\u0019\u0016\u000bT'fiJL7-\u0001\u0004=S:LGO\u0010\u000b\u0006+Z;\u0006,\u0017\t\u0003G\u0001AQAJ\u0003A\u0002\u001dBQAK\u0003A\u0002-BQaM\u0003A\u0002QBq\u0001P\u0003\u0011\u0002\u0003\u0007Q(A\u0006gS2,7i\\;oi\u0016\u0014X#\u0001/\u0011\u0005usV\"A\"\n\u0005}\u001b%aA%oi\u0006ya-\u001b7f\u0007>,h\u000e^3s?\u0012*\u0017\u000f\u0006\u0002cKB\u0011QlY\u0005\u0003I\u000e\u0013A!\u00168ji\"9amBA\u0001\u0002\u0004a\u0016a\u0001=%c\u0005aa-\u001b7f\u0007>,h\u000e^3sA\u0005i!/Z2pe\u0012\u001c\u0018J\u001c$jY\u0016,\u0012A\u001b\t\u0003;.L!\u0001\\\"\u0003\t1{gnZ\u0001\u0012e\u0016\u001cwN\u001d3t\u0013:4\u0015\u000e\\3`I\u0015\fHC\u00012p\u0011\u001d1'\"!AA\u0002)\faB]3d_J$7/\u00138GS2,\u0007%A\boK^|U\u000f\u001e9vi^\u0013\u0018\u000e^3s)\u0005\u0011\u0017aE;qI\u0006$XMU3d_J$7/\u00138GS2,GC\u00012v\u0011\u00151X\u00021\u0001x\u0003\u0019\u0011XmY8sIB\u0011\u0001p_\u0007\u0002s*\u0011!\u0010G\u0001\tG\u0006$\u0018\r\\=ti&\u0011A0\u001f\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0003xe&$X\r\u0006\u0002c\u007f\")aO\u0004a\u0001o\u0006I2+\u001b8hY\u0016$\u0015N]3di>\u0014\u0018\u0010R1uC^\u0013\u0018\u000e^3s!\t\u0019\u0003cE\u0002\u0011\u0003\u000f\u00012!XA\u0005\u0013\r\tYa\u0011\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005\r\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u0014)\u001aQ(!\u0006,\u0005\u0005]\u0001\u0003BA\r\u0003Gi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\tD\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\tYBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class SingleDirectoryDataWriter
extends FileFormatDataWriter {
    private final WriteJobDescription description;
    private final TaskAttemptContext taskAttemptContext;
    private final FileCommitProtocol committer;
    private int fileCounter;
    private long recordsInFile;

    public static Map<String, SQLMetric> $lessinit$greater$default$4() {
        return SingleDirectoryDataWriter$.MODULE$.$lessinit$greater$default$4();
    }

    private int fileCounter() {
        return this.fileCounter;
    }

    private void fileCounter_$eq(int x$1) {
        this.fileCounter = x$1;
    }

    private long recordsInFile() {
        return this.recordsInFile;
    }

    private void recordsInFile_$eq(long x$1) {
        this.recordsInFile = x$1;
    }

    private void newOutputWriter() {
        this.recordsInFile_$eq(0L);
        this.releaseResources();
        String ext = this.description.outputWriterFactory().getFileExtension(this.taskAttemptContext);
        int arg$macro$1 = this.fileCounter();
        String currentPath = this.committer.newTaskTempFile(this.taskAttemptContext, (Option)None$.MODULE$, new StringBuilder(0).append(new StringOps("-c%03d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)}))).append(ext).toString());
        this.currentWriter_$eq(this.description.outputWriterFactory().newInstance(currentPath, package$.MODULE$.AttributeSeq(this.description.dataColumns()).toStructType(), this.taskAttemptContext));
        this.statsTrackers().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.newFile(currentPath);
            return BoxedUnit.UNIT;
        });
    }

    private void updateRecordsInFile(InternalRow record) {
        InternalRow internalRow = record;
        if (internalRow instanceof FakeRow) {
            FakeRow fakeRow = (FakeRow)internalRow;
            this.recordsInFile_$eq(this.recordsInFile() + (long)fakeRow.batch().numRows());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.recordsInFile_$eq(this.recordsInFile() + 1L);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void write(InternalRow record) {
        if (this.description.maxRecordsPerFile() > 0L && this.recordsInFile() >= this.description.maxRecordsPerFile()) {
            this.fileCounter_$eq(this.fileCounter() + 1);
            Predef$.MODULE$.assert(this.fileCounter() < this.MAX_FILE_COUNTER(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("File counter ").append(this.fileCounter()).append(" is beyond max value ").append(this.MAX_FILE_COUNTER()).toString());
            this.newOutputWriter();
        }
        this.currentWriter().write(record);
        this.statsTrackers().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.newRow(this.currentWriter().path(), record);
            return BoxedUnit.UNIT;
        });
        this.updateRecordsInFile(record);
    }

    public SingleDirectoryDataWriter(WriteJobDescription description, TaskAttemptContext taskAttemptContext, FileCommitProtocol committer, Map<String, SQLMetric> customMetrics) {
        this.description = description;
        this.taskAttemptContext = taskAttemptContext;
        this.committer = committer;
        super(description, taskAttemptContext, committer, customMetrics);
        this.newOutputWriter();
    }
}

