/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.helper;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeTool;
import org.apache.kylin.common.metrics.MetricsCategory;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.metrics.MetricsName;
import org.apache.kylin.common.persistence.ImageDesc;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.metadata.AuditLogStore;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.MetadataChecker;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.tool.CancelableTask;
import org.apache.kylin.tool.HDFSMetadataTool;
import org.apache.kylin.tool.constant.StringConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataToolHelper
extends CancelableTask {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = StringConstant.DATE_TIME_FORMATTER;
    private static final String GLOBAL = "global";
    private static final String HDFS_METADATA_URL_FORMATTER = "kylin_metadata@hdfs,path=%s";
    private static final Logger logger = LoggerFactory.getLogger(MetadataToolHelper.class);

    public void rotateAuditLog() {
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
        AuditLogStore auditLogStore = resourceStore.getAuditLogStore();
        auditLogStore.rotate();
    }

    public void backup(KylinConfig kylinConfig) throws Exception {
        HDFSMetadataTool.cleanBeforeBackup(kylinConfig);
        new MetadataToolHelper().backup(kylinConfig, null, HadoopUtil.getBackupFolder((KylinConfig)kylinConfig), null, true, false);
    }

    public void backup(KylinConfig kylinConfig, String dir, String folder) throws Exception {
        HDFSMetadataTool.cleanBeforeBackup(kylinConfig);
        new MetadataToolHelper().backup(kylinConfig, null, dir, folder, true, false);
    }

    public void backupToDirectPath(KylinConfig kylinConfig, String backupPath) throws Exception {
        HDFSMetadataTool.cleanBeforeBackup(kylinConfig);
        new MetadataToolHelper().backup(kylinConfig, null, backupPath, true, false);
    }

    public void backup(KylinConfig kylinConfig, String dir, String folder, String project) throws Exception {
        HDFSMetadataTool.cleanBeforeBackup(kylinConfig);
        new MetadataToolHelper().backup(kylinConfig, project, dir, folder, true, false);
    }

    public void backupToDirectPath(KylinConfig kylinConfig, String backupPath, String project) throws Exception {
        HDFSMetadataTool.cleanBeforeBackup(kylinConfig);
        new MetadataToolHelper().backup(kylinConfig, project, backupPath, true, false);
    }

    public Pair<String, String> backup(KylinConfig kylinConfig, String project, String path, String folder, boolean compress, boolean excludeTableExd) throws Exception {
        Pair<String, String> pair = this.getBackupPath(path, folder);
        String coreMetadataBackupPath = StringUtils.appendIfMissing((String)((String)pair.getFirst()), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "core_meta";
        this.backup(kylinConfig, project, coreMetadataBackupPath, compress, excludeTableExd);
        return pair;
    }

    public void backup(KylinConfig kylinConfig, String project, String backupPath, boolean compress, boolean excludeTableExd) throws Exception {
        boolean isGlobal = null == project;
        long startAt = System.currentTimeMillis();
        try {
            this.doBackup(kylinConfig, project, backupPath, compress, excludeTableExd);
        }
        catch (Exception be) {
            if (isGlobal) {
                MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.METADATA_BACKUP_FAILED, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL);
            } else {
                MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.METADATA_BACKUP_FAILED, (MetricsCategory)MetricsCategory.PROJECT, (String)project);
            }
            throw be;
        }
        finally {
            if (isGlobal) {
                MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.METADATA_BACKUP, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL);
                MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.METADATA_BACKUP_DURATION, (MetricsCategory)MetricsCategory.GLOBAL, (String)GLOBAL, (long)(System.currentTimeMillis() - startAt));
            } else {
                MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.METADATA_BACKUP, (MetricsCategory)MetricsCategory.PROJECT, (String)project);
                MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.METADATA_BACKUP_DURATION, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (long)(System.currentTimeMillis() - startAt));
            }
        }
    }

    private Pair<String, String> getBackupPath(String path, String folder) {
        if (StringUtils.isBlank((CharSequence)path)) {
            path = KylinConfigBase.getKylinHome() + File.separator + "meta_backups";
        }
        if (StringUtils.isEmpty((CharSequence)folder)) {
            folder = LocalDateTime.now(Clock.systemDefaultZone()).format(DATE_TIME_FORMATTER) + "_backup";
        }
        String backupPath = StringUtils.appendIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + folder;
        return Pair.newPair((Object)backupPath, (Object)folder);
    }

    void doBackup(KylinConfig kylinConfig, String project, String backupPath, boolean compress, boolean excludeTableExd) throws Exception {
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)kylinConfig);
        boolean isUTEnv = kylinConfig.isUTEnv();
        System.out.printf(Locale.ROOT, "The metadata backup path is %s.%n", backupPath);
        String backupMetadataUrl = this.getMetadataUrl(backupPath, compress, kylinConfig);
        KylinConfig backupConfig = KylinConfig.createKylinConfig((KylinConfig)kylinConfig);
        backupConfig.setMetadataUrl(backupMetadataUrl);
        this.abortIfAlreadyExists(backupPath);
        logger.info("The backup metadataUrl is {} and backup path is {}", (Object)backupMetadataUrl, (Object)backupPath);
        try (ResourceStore backupResourceStore = ResourceStore.getKylinMetaStore((KylinConfig)backupConfig);){
            RawResource uuid;
            MetadataStore backupMetadataStore = backupResourceStore.getMetadataStore();
            String projectMsg = StringUtils.isBlank((CharSequence)project) ? "all projects" : "project " + project;
            logger.info("start to copy {} from ResourceStore.", (Object)projectMsg);
            long finalOffset = this.getOffset(isUTEnv, resourceStore);
            backupResourceStore.putResourceWithoutCheck(ResourceStore.METASTORE_IMAGE, ByteSource.wrap((byte[])JsonUtil.writeValueAsBytes((Object)new ImageDesc(Long.valueOf(finalOffset)))), System.currentTimeMillis(), -1L);
            NavigableSet backupItems = StringUtils.isBlank((CharSequence)project) ? resourceStore.listResourcesRecursively(MetadataType.ALL.name()) : resourceStore.listResourcesRecursivelyByProject(project);
            if (backupItems == null || backupItems.isEmpty()) {
                return;
            }
            UnitOfWork.doInTransactionWithRetry(() -> {
                this.backupMetadata(backupItems, resourceStore, backupResourceStore, excludeTableExd);
                return null;
            }, (String)"_global");
            if (!StringUtils.isBlank((CharSequence)project) && (uuid = resourceStore.getResource(ResourceStore.METASTORE_UUID_TAG)) != null) {
                backupResourceStore.putResourceWithoutCheck(ResourceStore.METASTORE_UUID_TAG, uuid.getByteSource(), uuid.getTs().longValue(), -1L);
            }
            logger.info("start to backup {}", (Object)projectMsg);
            backupResourceStore.deleteResource(ResourceStore.METASTORE_TRASH_RECORD);
            backupMetadataStore.dump(backupResourceStore);
            logger.info("backup successfully at {}", (Object)backupPath);
        }
    }

    public String getMetadataUrl(String rootPath, boolean compressed, KylinConfig kylinConfig) {
        if (HadoopUtil.isHdfsCompatibleSchema((String)rootPath, (KylinConfig)kylinConfig)) {
            String url = String.format(Locale.ROOT, HDFS_METADATA_URL_FORMATTER, Path.getPathWithoutSchemeAndAuthority((Path)new Path(rootPath)).toString() + "/");
            return compressed ? url + ",zip=1" : url;
        }
        if (rootPath.startsWith("file://")) {
            rootPath = rootPath.replace("file://", "");
            return StringUtils.appendIfMissing((String)rootPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return StringUtils.appendIfMissing((String)rootPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    private void backupMetadata(NavigableSet<String> items, ResourceStore resourceStore, ResourceStore backupResourceStore, boolean excludeTableExd) throws InterruptedException {
        for (String item : items) {
            if (excludeTableExd && item.startsWith(MetadataType.TABLE_EXD.name())) continue;
            resourceStore.copy(item, backupResourceStore);
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("metadata task is interrupt");
            }
            if (!this.isCanceled()) continue;
            logger.info("core metadata backup was canceled.");
            return;
        }
    }

    private long getOffset(boolean isUTEnv, ResourceStore resourceStore) {
        AuditLogStore auditLogStore = resourceStore.getAuditLogStore();
        if (isUTEnv) {
            return auditLogStore.getMaxId();
        }
        return auditLogStore.getLogOffset() == 0L ? resourceStore.getOffset() : auditLogStore.getLogOffset();
    }

    private void abortIfAlreadyExists(String path) throws IOException {
        URI uri = HadoopUtil.makeURI((String)path);
        if (!uri.isAbsolute()) {
            logger.info("no scheme specified for {}, try local file system file://", (Object)path);
            File localFile = new File(path);
            if (localFile.exists()) {
                logger.error("[UNEXPECTED_THINGS_HAPPENED] local file {} already exists ", (Object)path);
                throw new KylinException((ErrorCodeProducer)ErrorCodeTool.FILE_ALREADY_EXISTS, new Object[]{path});
            }
            return;
        }
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        if (fs.exists(new Path(path))) {
            logger.error("[UNEXPECTED_THINGS_HAPPENED] specified file {} already exists ", (Object)path);
            throw new KylinException((ErrorCodeProducer)ErrorCodeTool.FILE_ALREADY_EXISTS, new Object[]{path});
        }
    }

    public void restore(KylinConfig kylinConfig, String project, String path, boolean delete, boolean backup) throws Exception {
        logger.info("Restore metadata with delete : {}", (Object)delete);
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)kylinConfig);
        String restoreMetadataUrl = this.getMetadataUrl(path, false, kylinConfig);
        KylinConfig restoreConfig = KylinConfig.createKylinConfig((KylinConfig)kylinConfig);
        restoreConfig.setMetadataUrl(restoreMetadataUrl);
        logger.info("The restore metadataUrl is {} and restore path is {} ", (Object)restoreMetadataUrl, (Object)path);
        ResourceStore restoreResourceStore = ResourceStore.getKylinMetaStore((KylinConfig)restoreConfig);
        MetadataStore restoreMetadataStore = restoreResourceStore.getMetadataStore();
        MetadataChecker metadataChecker = new MetadataChecker(restoreMetadataStore);
        MetadataChecker.VerifyResult verifyResult = metadataChecker.verify();
        Preconditions.checkState((boolean)verifyResult.isQualified(), (Object)(verifyResult.getResultMessage() + "\n the metadata dir is not qualified"));
        this.restore(resourceStore, restoreResourceStore, project, delete);
        if (backup) {
            if (UnitOfWork.isAlreadyInTransaction()) {
                UnitOfWork.get().doAfterUnit(() -> this.backup(kylinConfig));
            } else {
                this.backup(kylinConfig);
            }
        }
    }

    public void restore(ResourceStore currentResourceStore, ResourceStore restoreResourceStore, String project, boolean delete) {
        this.checkDuplicateUuidModel(currentResourceStore, restoreResourceStore, project, delete);
        if (StringUtils.isBlank((CharSequence)project)) {
            logger.info("start to restore all projects");
            NavigableSet destResources = currentResourceStore.listResourcesRecursively(MetadataType.ALL.name());
            NavigableSet srcResources = restoreResourceStore.listResourcesRecursively(MetadataType.ALL.name());
            srcResources.remove(ResourceStore.METASTORE_IMAGE);
            UnitOfWorkParams params = UnitOfWorkParams.builder().unitName("_global").maxRetry(1).useProjectLock(true).processor(() -> this.doRestore(restoreResourceStore, destResources, srcResources, delete)).build();
            UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)params);
        } else {
            logger.info("start to restore project {}", (Object)project);
            NavigableSet destResources = currentResourceStore.listResourcesRecursivelyByProject(project);
            NavigableSet srcResources = restoreResourceStore.listResourcesRecursivelyByProject(project);
            UnitOfWorkParams params = UnitOfWorkParams.builder().unitName(project).maxRetry(1).useProjectLock(true).processor(() -> this.doRestore(restoreResourceStore, destResources, srcResources, delete)).build();
            UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)params);
        }
        logger.info("restore successfully");
    }

    public void checkDuplicateUuidModel(ResourceStore currentResourceStore, ResourceStore restoreResourceStore, String project, boolean delete) {
        logger.info("start check duplicate uuid model");
        if (delete) {
            return;
        }
        Map<String, List<String>> duplicateUuidModelByProject = this.getDuplicateUuidModelByProject(currentResourceStore, restoreResourceStore, project);
        if (!duplicateUuidModelByProject.isEmpty()) {
            String errorMsg = duplicateUuidModelByProject.entrySet().stream().map(m -> "[" + (String)m.getKey() + "]:" + String.join((CharSequence)",", (Iterable)m.getValue())).collect(Collectors.joining(";"));
            String info = String.format(Locale.ROOT, "[UNEXPECTED_THINGS_HAPPENED] There will be models with the same name after recovery, please rename these models first:[project]:models: %s ", errorMsg);
            logger.error(info);
            System.out.println("\u001b[31m" + info + "\u001b[0m");
            throw new KylinException((ErrorCodeProducer)ErrorCodeTool.MODEL_DUPLICATE_UUID_FAILED, new Object[]{errorMsg});
        }
        logger.info("end check duplicate uuid model");
    }

    private Map<String, List<String>> getDuplicateUuidModelByProject(ResourceStore currentResourceStore, ResourceStore restoreResourceStore, String project) {
        Map<Object, Object> duplicateUuidModelByProject = Maps.newHashMap();
        if (StringUtils.isBlank((CharSequence)project)) {
            duplicateUuidModelByProject = this.getDuplicateUuidModelByAllProject(currentResourceStore, restoreResourceStore);
        } else {
            List<String> duplicateUuidModel = this.getDuplicateUuidModel(currentResourceStore, restoreResourceStore, project);
            if (!duplicateUuidModel.isEmpty()) {
                duplicateUuidModelByProject.put(project, duplicateUuidModel);
            }
        }
        return duplicateUuidModelByProject;
    }

    private Map<String, List<String>> getDuplicateUuidModelByAllProject(ResourceStore currentResourceStore, ResourceStore restoreResourceStore) {
        NavigableSet destProjectFolders = currentResourceStore.listResources(MetadataType.PROJECT.name());
        NavigableSet srcProjectFolders = restoreResourceStore.listResources(MetadataType.PROJECT.name());
        destProjectFolders = destProjectFolders == null ? Sets.newTreeSet() : destProjectFolders;
        srcProjectFolders = srcProjectFolders == null ? Sets.newTreeSet() : srcProjectFolders;
        Sets.SetView projectFolders = Sets.union((Set)srcProjectFolders, (Set)destProjectFolders);
        HashMap duplicateUuidModelByProject = Maps.newHashMap();
        for (String projectPath : projectFolders) {
            String projectName = (String)MetadataType.splitKeyWithType((String)projectPath).getSecond();
            List<String> duplicateUuidModel = this.getDuplicateUuidModel(currentResourceStore, restoreResourceStore, projectName);
            if (duplicateUuidModel.isEmpty()) continue;
            duplicateUuidModelByProject.put(projectName, duplicateUuidModel);
        }
        return duplicateUuidModelByProject;
    }

    private List<String> getDuplicateUuidModel(ResourceStore currentResourceStore, ResourceStore restoreResourceStore, String projectName) {
        RawResourceFilter filter = RawResourceFilter.equalFilter((String)"project", (String)projectName);
        NavigableSet destModelResource = currentResourceStore.listResources(MetadataType.MODEL.name(), filter);
        NavigableSet srcModelResource = restoreResourceStore.listResources(MetadataType.MODEL.name(), filter);
        destModelResource = destModelResource == null ? Collections.emptySet() : destModelResource;
        srcModelResource = srcModelResource == null ? Collections.emptySet() : srcModelResource;
        Sets.SetView insertsModelResource = Sets.difference((Set)srcModelResource, (Set)destModelResource);
        ArrayList<NDataModel> allModels = new ArrayList<NDataModel>(this.getModelListFromResource(projectName, destModelResource, currentResourceStore));
        List<NDataModel> insertsModels = this.getModelListFromResource(projectName, new HashSet<String>((Collection<String>)insertsModelResource), restoreResourceStore);
        allModels.addAll(insertsModels);
        HashMap nameUuids = Maps.newHashMap();
        for (NDataModel model : allModels) {
            String modelAlias = model.getAlias();
            nameUuids.putIfAbsent(modelAlias, Sets.newHashSet());
            ((Set)nameUuids.get(modelAlias)).add(model.getUuid());
        }
        return nameUuids.entrySet().stream().filter(m -> ((Set)m.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public List<NDataModel> getModelListFromResource(String projectName, Set<String> modelResource, ResourceStore resourceStore) {
        if (modelResource == null) {
            return new ArrayList<NDataModel>();
        }
        ArrayList<NDataModel> models = new ArrayList<NDataModel>();
        for (String resource : modelResource) {
            try {
                NDataModel nDataModel = (NDataModel)JsonUtil.readValue((byte[])resourceStore.getResource(resource).getByteSource().read(), NDataModel.class);
                nDataModel.setProject(projectName);
                models.add(nDataModel);
            }
            catch (IOException e) {
                if (KylinConfig.getInstanceFromEnv().isUTEnv()) continue;
                throw new IllegalStateException(e);
            }
        }
        return models;
    }

    private int doRestore(ResourceStore restoreResourceStore, Set<String> destResources, Set<String> srcResources, boolean delete) throws IOException {
        ResourceStore transparentRS = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
        destResources = destResources == null ? Collections.emptySet() : destResources;
        srcResources = srcResources == null ? Collections.emptySet() : srcResources;
        logger.info("Start insert metadata resource...");
        Sets.SetView insertRes = Sets.difference(srcResources, destResources);
        for (String res : insertRes) {
            transparentRS.getResource(res, true);
            RawResource metadataRaw = restoreResourceStore.getResource(res);
            UnitOfWork.get().getCopyForWriteItems().add(res);
            transparentRS.checkAndPutResource(res, metadataRaw.getByteSource(), -1L);
        }
        logger.info("Start update metadata resource...");
        Sets.SetView updateRes = Sets.intersection(destResources, srcResources);
        for (String res : updateRes) {
            RawResource raw = transparentRS.getResource(res, true);
            RawResource metadataRaw = restoreResourceStore.getResource(res);
            UnitOfWork.get().getCopyForWriteItems().add(res);
            transparentRS.checkAndPutResource(res, metadataRaw.getByteSource(), raw.getMvcc());
        }
        if (delete) {
            logger.info("Start delete metadata resource...");
            Sets.SetView deleteRes = Sets.difference(destResources, srcResources);
            for (String res : deleteRes) {
                UnitOfWork.get().getCopyForWriteItems().add(res);
                transparentRS.deleteResource(res);
            }
        }
        return 0;
    }
}

