/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.File;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.tool.AbstractInfoExtractorTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientEnvTool
extends AbstractInfoExtractorTool {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final String CLI_VERSION = "version";
    private static final String LINUX_DEFRAG = "/sys/kernel/mm/transparent_hugepage/defrag";
    private static final String LINUX_SWAP = "/proc/sys/vm/swappiness";
    private static final String LINUX_CPU = "/proc/cpuinfo";

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) {
        this.addFile(new File(LINUX_DEFRAG), new File(exportDir, "linux/transparent_hugepage"));
        this.addFile(new File(LINUX_SWAP), new File(exportDir, "linux/swappiness"));
        this.addFile(new File(LINUX_CPU), new File(exportDir, "linux"));
        File linuxDir = new File(exportDir, "linux");
        this.addShellOutput("lsb_release -a", linuxDir, "lsb_release");
        this.addShellOutput("df -h", linuxDir, "disk_usage");
        this.addShellOutput("free -m", linuxDir, "mem_usage_mb");
        this.addShellOutput("top -b -n 1 | head -n 30", linuxDir, "top");
        this.addShellOutput("ps aux|grep kylin", linuxDir, "kylin_processes");
        if (!this.getKapConfig().isCloud()) {
            this.addShellOutput("hadoop version", new File(exportDir, "hadoop"), CLI_VERSION);
            this.addShellOutput("hive --version", new File(exportDir, "hive"), CLI_VERSION, false, true);
            this.addShellOutput("beeline -n1 -p1 -e\"select 1;\"", new File(exportDir, "hive"), "beeline_version", false, true);
            this.addShellOutput("klist", new File(exportDir, "kerberos"), "klist", false, true);
        }
    }

    protected void extractInfoByCmd(String cmd, File destFile) {
        try {
            if (!destFile.exists() && !destFile.createNewFile()) {
                logger.error("Failed to createNewFile destFile.");
            }
            logger.info("The command is: {}", (Object)cmd);
            this.getCmdExecutor().execute(cmd, null);
        }
        catch (Exception e) {
            logger.error("Failed to execute copyCmd", (Throwable)e);
        }
    }
}

