/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.File;
import java.util.Locale;
import org.apache.kylin.tool.ClientEnvTool;
import org.apache.kylin.tool.util.ToolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonInfoTool {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static ClientEnvTool clientEnvTool = new ClientEnvTool();

    private CommonInfoTool() {
    }

    public static void exportClientInfo(File exportDir) {
        try {
            String[] clientArgs = new String[]{"-destDir", new File(exportDir, "client").getAbsolutePath(), "-compress", "false", "-submodule", "true"};
            clientEnvTool.execute(clientArgs);
        }
        catch (Exception e) {
            logger.error("Failed to extract client env, ", (Throwable)e);
        }
    }

    public static void exportHadoopEnv(File exportDir) {
        try {
            File file = new File(exportDir, "hadoop_env");
            clientEnvTool.extractInfoByCmd("env>" + file.getAbsolutePath(), file);
        }
        catch (Exception e) {
            logger.warn("Error in export hadoop env, ", (Throwable)e);
        }
    }

    public static void exportKylinHomeDir(File exportDir) {
        try {
            File file = new File(exportDir, "catalog_info");
            String cmd = String.format(Locale.ROOT, "ls -lR %s>%s", ToolUtil.getKylinHome(), file.getAbsolutePath());
            clientEnvTool.extractInfoByCmd(cmd, file);
        }
        catch (Exception e) {
            logger.error("Error in export KYLIN_HOME dir, ", (Throwable)e);
        }
    }
}

