/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.base.MoreObjects;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.query.RDBMSQueryHistoryDAO;
import org.apache.kylin.metadata.sourceusage.SourceUsageManager;
import org.apache.kylin.metadata.sourceusage.SourceUsageRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemUsageTool {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final String QUERY_DAILY_FILE_NAME = "query_daily.csv";
    private static final String BUILD_DAILY_FILE_NAME = "build_daily.csv";
    private static final String BASE_FILE_NAME = "base";

    private SystemUsageTool() {
    }

    public static void extractUseInfo(File exportDir, long startTime, long endTime) {
        File destDir = new File(exportDir, "system_usage");
        try {
            FileUtils.forceMkdir((File)destDir);
            SystemUsageTool.baseInfo(destDir);
            SystemUsageTool.queryDailyInfo(destDir, startTime, endTime);
            SystemUsageTool.buildDailyInfo(destDir, startTime, endTime);
        }
        catch (Exception e) {
            logger.error("Failed to extract system usage", (Throwable)e);
        }
    }

    private static void queryDailyInfo(File exportDir, long startTime, long endTime) throws IOException {
        RDBMSQueryHistoryDAO queryHistoryDAO = RDBMSQueryHistoryDAO.getInstance();
        List queryDailyStatisticList = queryHistoryDAO.getQueryDailyStatistic(startTime, endTime);
        ArrayList lines = Lists.newArrayList();
        lines.add("date,active_users,number_of_queries,number_of_successful_queries,average_time_spent_seconds,number_of_queries_within_1s,number_of_queries_within_3s,number_of_queries_within_5s,number_of_queries_within_10s,number_of_queries_within_15s");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault(Locale.Category.FORMAT));
        queryDailyStatisticList.forEach(e -> lines.add(String.format(Locale.ROOT, "%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", simpleDateFormat.format(new Date(e.getQueryDay())), e.getActiveUserNum(), e.getTotalNum(), e.getSucceedNum(), SystemUsageTool.divide(e.getTotalDuration(), (double)e.getSucceedNum() * 1000.0, "%.1f"), e.getLt1sNum(), e.getLt3sNum(), e.getLt5sNum(), e.getLt10sNum(), e.getLt15sNum())));
        FileUtils.writeLines((File)new File(exportDir, QUERY_DAILY_FILE_NAME), (Collection)lines, (boolean)false);
    }

    private static void buildDailyInfo(File exportDir, long startTime, long endTime) throws IOException {
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        ArrayList allJobs = Lists.newArrayList();
        projectManager.listAllProjects().forEach(projectInstance -> {
            ExecutableManager executableManager = (ExecutableManager)KylinConfig.getInstanceFromEnv().getManager(projectInstance.getName(), ExecutableManager.class);
            allJobs.addAll(executableManager.getAllJobs(startTime, endTime));
        });
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault(Locale.Category.FORMAT));
        Map<String, List<ExecutablePO>> dailyBuildExecutableMap = allJobs.stream().filter(e -> "BUILD".equals(e.getJobType().getCategory())).collect(Collectors.groupingBy(e -> simpleDateFormat.format(new Date(e.getLastModified()))));
        ArrayList lines = Lists.newArrayList();
        lines.add("date,number_of_build_tasks,average_build_time_minutes,build_success_rate");
        dailyBuildExecutableMap.entrySet().stream().sorted(Map.Entry.comparingByKey().reversed()).forEachOrdered(entry -> {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            int buildNum = CollectionUtils.size((Object)value);
            long buildSucceedNum = value.stream().filter(e -> ExecutableState.SUCCEED.name().equals(e.getOutput().getStatus())).count();
            double totalDuration = value.stream().filter(e -> ExecutableState.SUCCEED.name().equals(e.getOutput().getStatus())).mapToDouble(e -> {
                AbstractExecutable executable = ((ExecutableManager)KylinConfig.getInstanceFromEnv().getManager(e.getProject(), ExecutableManager.class)).fromPO(e);
                return executable.getDurationFromStepOrStageDurationSum(e);
            }).sum();
            lines.add(String.format(Locale.ROOT, "%s,%s,%s,%s", key, buildNum, SystemUsageTool.divide(totalDuration, (double)buildSucceedNum * 60.0 * 1000.0, "%.2f"), SystemUsageTool.divide((double)buildSucceedNum * 1.0, buildNum, "%.3f")));
        });
        FileUtils.writeLines((File)new File(exportDir, BUILD_DAILY_FILE_NAME), (Collection)lines, (boolean)false);
    }

    public static String divide(double molecular, double denominator, String format) {
        return String.format(Locale.ROOT, format, denominator == 0.0 ? 0.0 : molecular / denominator);
    }

    private static void baseInfo(File exportDir) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        List allProjects = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects();
        stringBuilder.append("project_num : ").append(CollectionUtils.size((Object)allProjects)).append("\n");
        long modelNum = allProjects.stream().map(e -> NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)e.getName()).listAllModels()).mapToLong(Collection::size).sum();
        stringBuilder.append("model_num : ").append(modelNum).append("\n");
        SourceUsageRecord latestRecord = SourceUsageManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getLatestRecord();
        stringBuilder.append("license_capacity : ").append(FileUtils.byteCountToDisplaySize((long)((SourceUsageRecord)MoreObjects.firstNonNull((Object)latestRecord, (Object)new SourceUsageRecord())).getLicenseCapacity())).append("\n");
        stringBuilder.append("license_used_capacity : ").append(FileUtils.byteCountToDisplaySize((long)((SourceUsageRecord)MoreObjects.firstNonNull((Object)latestRecord, (Object)new SourceUsageRecord())).getCurrentCapacity())).append("\n");
        FileUtils.writeStringToFile((File)new File(exportDir, BASE_FILE_NAME), (String)stringBuilder.toString(), (Charset)StandardCharsets.UTF_8, (boolean)false);
    }
}

