/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.garbage;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.kylin.common.util.DaemonThreadFactory;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;

public class PriorityExecutor
extends ThreadPoolExecutor {
    private PriorityExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public static PriorityExecutor newWorkingThreadPool(String name, int maxPoolSize) {
        return new PriorityExecutor(maxPoolSize, maxPoolSize, 60L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(), (ThreadFactory)new DaemonThreadFactory(name));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new ComparableFutureTask(runnable, null);
    }

    public static class ComparableFutureTask<T extends Comparable<?>, R>
    extends FutureTask<R>
    implements Comparable<ComparableFutureTask<T, R>> {
        private final Comparable<T> task;

        public ComparableFutureTask(Runnable runnable, R result) {
            super(runnable, result);
            Preconditions.checkArgument((boolean)(runnable instanceof Comparable), (Object)"runnable should also be comparable!");
            this.task = (Comparable)((Object)runnable);
        }

        @Override
        public int compareTo(ComparableFutureTask<T, R> o) {
            return this.task.compareTo(o.task);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComparableFutureTask)) {
                return false;
            }
            ComparableFutureTask other = (ComparableFutureTask)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Comparable<T> this$task = this.task;
            Comparable<T> other$task = other.task;
            return !(this$task == null ? other$task != null : !this$task.equals(other$task));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ComparableFutureTask;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Comparable<T> $task = this.task;
            result = result * 59 + ($task == null ? 43 : $task.hashCode());
            return result;
        }
    }
}

