/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.upgrade;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.DatatypeConverter;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.persistence.ImageDesc;
import org.apache.kylin.common.persistence.InMemResourceStore;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.persistence.VersionedRawResource;
import org.apache.kylin.common.persistence.metadata.FileSystemMetadataStore;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.persistence.resources.CcModelRelationRawResource;
import org.apache.kylin.common.persistence.resources.ComputeColumnRawResource;
import org.apache.kylin.common.persistence.resources.DataParserRawResource;
import org.apache.kylin.common.persistence.resources.LayoutRawResource;
import org.apache.kylin.common.persistence.resources.RecRawResource;
import org.apache.kylin.common.persistence.resources.SegmentRawResource;
import org.apache.kylin.common.persistence.resources.SegmentRawResourceWrap;
import org.apache.kylin.common.persistence.resources.SystemRawResource;
import org.apache.kylin.common.persistence.resources.TableModelRelationRawResource;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.util.ComputedColumnUtil;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.util.ComputedColumnRewriter;
import org.apache.kylin.tool.util.HashFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple3;

public class MigrateKEMetadataTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrateKEMetadataTool.class);
    public static final String ZIP_SUFFIX = ".zip";
    public static final String PROJECT_KEY = "project";
    public static final String SEPRATOR = "/";
    public final Map<String, Map<String, String>> modelUuidMap = new ConcurrentHashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> segUuidMap = new ConcurrentHashMap<String, Map<String, String>>();
    private final Map<String, String> ccUuidMap = new ConcurrentHashMap<String, String>();
    public static final Serializer<StringEntity> serializer = new Serializer<StringEntity>(){

        public void serialize(StringEntity obj, DataOutputStream out) throws IOException {
            out.writeUTF(obj.getStr());
        }

        public StringEntity deserialize(DataInputStream in) throws IOException {
            String str = in.readUTF();
            return new StringEntity(str);
        }
    };

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            log.error("Usage: MigrateKEMetadataTool <inputPath> <outputPath>");
            return;
        }
        String inputPath = args[0];
        String outputPath = null;
        if (args.length > 1) {
            outputPath = args[1];
        }
        MigrateKEMetadataTool tool = new MigrateKEMetadataTool();
        tool.doMigrate(inputPath, outputPath);
    }

    public MetadataStore.MemoryMetaData loadOldMetaData(FileSystemMetadataStore metadataStore, String inputPath, String type) {
        Path path = new Path(inputPath);
        if (FileSystemMetadataStore.Type.DIR.name().equals(type)) {
            return this.getAllFile(path, metadataStore);
        }
        return this.fillMetaDataFromCompressedFile(path, metadataStore);
    }

    private MetadataStore.MemoryMetaData getAllFile(Path filePath, FileSystemMetadataStore store) {
        Date startTime = new Date();
        FileSystem fs = store.getFs();
        MetadataStore.MemoryMetaData data = MetadataStore.MemoryMetaData.createEmpty();
        BiConsumer<FileStatus, MetadataStore.MemoryMetaData> loadMetadataProcess = (innerStat, dataHelper) -> {
            try {
                RawResource innerRaw = this.loadOne((FileStatus)innerStat, (MetadataStore.MemoryMetaData)dataHelper, store, filePath);
                if (innerRaw != null) {
                    dataHelper.put(innerRaw.getMetaType(), new VersionedRawResource(innerRaw));
                }
            }
            catch (IOException e) {
                Throwables.throwIfUnchecked((Throwable)e);
            }
        };
        try {
            FileStatus[] fileStatuses = fs.listStatus(filePath);
            log.info("getAllFile from {} started...", (Object)filePath);
            ArrayList futures = new ArrayList();
            for (FileStatus childStatus : fileStatuses) {
                store.getAndPutAllFileRecursion(childStatus, fs, data, futures, loadMetadataProcess);
            }
            for (Future future : futures) {
                future.get();
            }
            log.info("getAllFile cost {} ms", (Object)(new Date().getTime() - startTime.getTime()));
            return data;
        }
        catch (IOException | ExecutionException e) {
            throw new KylinRuntimeException((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KylinRuntimeException((Throwable)e);
        }
    }

    private MetadataStore.MemoryMetaData fillMetaDataFromCompressedFile(Path compressedFile, FileSystemMetadataStore store) {
        log.info("reloadAll from zip");
        FileSystem fs = store.getFs();
        MetadataStore.MemoryMetaData data = MetadataStore.MemoryMetaData.createEmpty();
        try {
            if (!fs.exists(compressedFile) || !fs.isFile(compressedFile)) {
                return data;
            }
        }
        catch (IOException ignored) {
            log.warn("Check zip file failed, return empty.");
            return data;
        }
        try (FSDataInputStream in = fs.open(compressedFile);
             ZipInputStream zipIn = new ZipInputStream((InputStream)in);){
            ZipEntry zipEntry;
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                String resPath = zipEntry.getName();
                if (MigrateKEMetadataTool.verifyNonMetadataFile(resPath)) {
                    log.info("not a metadata file: " + resPath + ", skip it!");
                    continue;
                }
                long t = zipEntry.getTime();
                RawResource raw = this.loadByStream(resPath, t, data, new DataInputStream(zipIn));
                if (raw == null) continue;
                data.put(raw.getMetaType(), new VersionedRawResource(raw));
            }
        }
        catch (Exception e) {
            log.warn("get file from compressed file error", (Throwable)e);
        }
        return data;
    }

    private RawResource loadOne(FileStatus status, MetadataStore.MemoryMetaData data, FileSystemMetadataStore metadataStore, Path parentPath) throws IOException {
        Path curPath = status.getPath();
        FileSystem fs = metadataStore.getFs();
        long ts = fs.getFileStatus(curPath).getModificationTime();
        Path replacedPath = Path.getPathWithoutSchemeAndAuthority((Path)parentPath);
        String replacedValue = fs.makeQualified(replacedPath).toString();
        String resourcePath = curPath.toString().replace(replacedValue, "");
        if (MigrateKEMetadataTool.verifyNonMetadataFile(resourcePath)) {
            return null;
        }
        try (FSDataInputStream in = fs.open(curPath);){
            RawResource rawResource = this.loadByStream(resourcePath, ts, data, new DataInputStream((InputStream)in));
            return rawResource;
        }
    }

    RawResource loadByStream(String resourcePath, long ts, MetadataStore.MemoryMetaData data, DataInputStream in) throws IOException {
        RawResource res;
        if (in.available() == 0) {
            return null;
        }
        MigrateRawResourceFactory factory = new MigrateRawResourceFactory();
        if (resourcePath.endsWith("UUID")) {
            return factory.createSystemRawResource("UUID", ts, in);
        }
        if (resourcePath.endsWith("VERSION")) {
            return factory.createSystemRawResource("VERSION", ts, in);
        }
        if (resourcePath.endsWith("_image")) {
            return factory.createSystemRawResource("_image", ts, in);
        }
        if (resourcePath.startsWith("/_global/upgrade/")) {
            return factory.createSystemRawResource("acl_version", ts, in);
        }
        if (resourcePath.contains("trash_record")) {
            return null;
        }
        if (resourcePath.contains("/rec/")) {
            return factory.createRecResource(resourcePath, ts, in);
        }
        byte[] byteArray = IOUtils.toByteArray((InputStream)in);
        Tuple3<String, MetadataType, String> resPathPair = MigrateKEMetadataTool.splitFilePath(resourcePath);
        switch ((MetadataType)resPathPair._2()) {
            case DATAFLOW: {
                res = factory.createDataflowResource((Tuple3<String, MetadataType, String>)resPathPair, ts, byteArray, data);
                break;
            }
            case MODEL: {
                res = factory.createModelResource((Tuple3<String, MetadataType, String>)resPathPair, ts, byteArray, data);
                break;
            }
            case LAYOUT: {
                res = factory.createLayoutResource((Tuple3<String, MetadataType, String>)resPathPair, byteArray);
                break;
            }
            case DATA_PARSER: {
                res = factory.createDataParserResource(resPathPair, byteArray);
                break;
            }
            case INDEX_PLAN: {
                res = factory.createIndexPlanResource((Tuple3<String, MetadataType, String>)resPathPair, byteArray);
                break;
            }
            default: {
                res = factory.createDefaultResource((Tuple3<String, MetadataType, String>)resPathPair, byteArray);
            }
        }
        if (res.getMetaKey() == null) {
            res.setMetaKey(MigrateKEMetadataTool.generateMetaKey(resPathPair, res));
        }
        res.setMvcc(0L);
        res.setTs(Long.valueOf(ts));
        return res;
    }

    private static String generateMetaKey(Tuple3<String, MetadataType, String> resPathPair, RawResource res) {
        String resourceName;
        String string = resourceName = ((String)resPathPair._3()).endsWith(".json") ? ((String)resPathPair._3()).substring(0, ((String)resPathPair._3()).length() - 5) : (String)resPathPair._3();
        if (resPathPair._2() == MetadataType.TABLE_EXD || resPathPair._2() == MetadataType.TABLE_INFO || resPathPair._2() == MetadataType.KAFKA_CONFIG || resPathPair._2() == MetadataType.JAR_INFO) {
            return res.getProject() + "." + resourceName;
        }
        return resourceName;
    }

    public static Tuple3<String, MetadataType, String> splitFilePath(String resourcePath) {
        if (SEPRATOR.equals(resourcePath)) {
            return new Tuple3((Object)resourcePath, (Object)MetadataType.ALL, null);
        }
        if (resourcePath.startsWith(SEPRATOR) && resourcePath.length() > 1) {
            resourcePath = resourcePath.substring(1);
        }
        if (resourcePath.contains("_global/sys_acl/user")) {
            String[] split = resourcePath.split(SEPRATOR);
            return new Tuple3((Object)split[0], (Object)MetadataType.USER_GLOBAL_ACL, (Object)split[3]);
        }
        if (resourcePath.contains("_global/acl")) {
            String[] split = resourcePath.split(SEPRATOR);
            return new Tuple3((Object)split[0], (Object)MetadataType.OBJECT_ACL, (Object)split[2]);
        }
        if (resourcePath.contains("/acl/user")) {
            String[] split = resourcePath.split(SEPRATOR);
            return new Tuple3((Object)split[0], (Object)MetadataType.ACL, (Object)(split[0] + ".u." + split[3]));
        }
        if (resourcePath.contains("/acl/group")) {
            String[] split = resourcePath.split(SEPRATOR);
            return new Tuple3((Object)split[0], (Object)MetadataType.ACL, (Object)(split[0] + ".g." + split[3]));
        }
        String[] split = resourcePath.split(SEPRATOR, 3);
        if (split.length < 3) {
            throw new KylinRuntimeException("resourcePath is invalid: " + resourcePath);
        }
        String typeStr = MigrateKEMetadataTool.convertToMigrateMetadataType(split[1].toUpperCase(Locale.ROOT));
        return new Tuple3((Object)split[0], (Object)MetadataType.create((String)typeStr), (Object)split[2]);
    }

    private static String convertToMigrateMetadataType(String type) {
        switch (type) {
            case "DATAFLOW_DETAILS": {
                type = "LAYOUT";
                break;
            }
            case "MODEL_DESC": {
                type = "MODEL";
                break;
            }
            case "TABLE": 
            case "USER": 
            case "JAR": {
                type = type + "_INFO";
                break;
            }
            case "KAFKA": {
                type = "KAFKA_CONFIG";
                break;
            }
            case "STREAMING": {
                type = "STREAMING_JOB";
                break;
            }
            case "QUERY": {
                type = "QUERY_RECORD";
                break;
            }
            case "PARSER": {
                type = "DATA_PARSER";
                break;
            }
        }
        return type;
    }

    public static void migrateMetaFromJsonList(String inputFile, String outFile, boolean isAuditLog) throws Exception {
        String metaKey = isAuditLog ? "meta_key" : "meta_table_key";
        String metaContent = isAuditLog ? "meta_content" : "meta_table_content";
        String metaTs = isAuditLog ? "meta_ts" : "meta_table_ts";
        MigrateKEMetadataTool tool = new MigrateKEMetadataTool();
        MetadataStore.MemoryMetaData data = MetadataStore.MemoryMetaData.createEmpty();
        List items = (List)JsonUtil.readValue((File)Paths.get(inputFile, new String[0]).toFile(), (TypeReference)new TypeReference<List<JsonNode>>(){});
        ArrayList<ObjectNode> result = new ArrayList<ObjectNode>();
        for (JsonNode item : items) {
            String originMetaKey = item.get(metaKey).asText();
            long originMetaTs = item.get(metaTs).asLong();
            byte[] originContent = JsonUtil.writeValueAsBytes((Object)item.get(metaContent));
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(originContent);
                Throwable throwable = null;
                try {
                    DataInputStream in = new DataInputStream(bis);
                    Throwable throwable2 = null;
                    try {
                        RawResource raw = tool.loadByStream(originMetaKey, originMetaTs, data, in);
                        if (raw == null) continue;
                        ObjectNode node = JsonUtil.valueToTree((Object)item);
                        node.put(metaKey, raw.generateKeyWithType());
                        node.set(metaContent, (JsonNode)JsonUtil.readValue((byte[])raw.getContent(), JsonNode.class));
                        result.add(node);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable2 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (bis == null) continue;
                    if (throwable != null) {
                        try {
                            bis.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    bis.close();
                }
            }
            catch (Exception e) {
                log.warn("Migrate failed for metadata: {}, just ignore it. ", (Object)originMetaKey, (Object)e);
            }
        }
        File output = Paths.get(outFile, new String[0]).toFile();
        if (!output.getParentFile().exists()) {
            output.getParentFile().mkdirs();
        }
        JsonUtil.writeValueIndent((OutputStream)Files.newOutputStream(output.toPath(), new OpenOption[0]), result);
    }

    public static void migrateUtMetaZipFiles(String inputPath, String outputPath) throws Exception {
        KylinConfig inputConfig = KylinConfig.getInstanceFromEnv();
        KapConfig kapConf = KapConfig.wrap((KylinConfig)inputConfig);
        inputPath = inputPath != null ? StringUtils.appendIfMissing((String)inputPath, (CharSequence)SEPRATOR, (CharSequence[])new CharSequence[0]) : inputConfig.getMetadataUrl().getIdentifier();
        if (outputPath == null) {
            outputPath = kapConf.getReadHdfsWorkingDirectory() + "migrated/";
        }
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        log.info("ut-meta metadataPath: " + outputPath);
        String finalOutputPath = outputPath;
        Path inputFilePath = new Path(inputPath);
        TreeSet allFilePath = FileSystemMetadataStore.getAllFilePath((Path)inputFilePath, (FileSystem)fs);
        allFilePath.forEach(path -> {
            if (!path.getName().endsWith(ZIP_SUFFIX)) {
                log.info("skip file: {}", path);
                return;
            }
            long date = System.currentTimeMillis();
            log.info("start migrate file: {}", path);
            try {
                Path replacedPath = Path.getPathWithoutSchemeAndAuthority((Path)inputFilePath);
                String replacedValue = fs.makeQualified(replacedPath).toString();
                MigrateKEMetadataTool migrateKEMetadataTool = new MigrateKEMetadataTool();
                migrateKEMetadataTool.doMigrate(path.toString(), path.toString().replace(replacedValue, finalOutputPath));
                log.info("end migrate file: {}, cost: {}", path, (Object)(System.currentTimeMillis() - date));
            }
            catch (Exception e) {
                throw new KylinRuntimeException((Throwable)e);
            }
        });
        MigrateKEMetadataTool.fixSignatureForZipFiles(outputPath);
    }

    private static void fixSignatureForZipFiles(String outputPath) {
        File folder = new File(outputPath);
        Arrays.stream(folder.listFiles()).forEach(file -> {
            try {
                if (!file.getName().endsWith(ZIP_SUFFIX)) {
                    return;
                }
                if (file.getName().length() - file.getName().lastIndexOf("_") != 37) {
                    return;
                }
                InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
                byte[] md5 = HashFunction.MD5.checksum(is);
                String signature = DatatypeConverter.printHexBinary((byte[])md5);
                String newFileName = file.getName().substring(0, file.getName().length() - 36) + signature + ZIP_SUFFIX;
                Files.move(file.toPath(), new File(outputPath, newFileName).toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new KylinRuntimeException((Throwable)e);
            }
        });
    }

    public void doMigrate(String inputPath, String outputPath) throws Exception {
        Path metadataPath;
        FileSystem fs;
        String type;
        ComputedColumnUtil.setEXTRACTOR(ComputedColumnRewriter::extractCcRexNode);
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        KapConfig kapConf = KapConfig.wrap((KylinConfig)config);
        if (inputPath == null) {
            inputPath = config.getMetadataUrl().getIdentifier();
        }
        Properties props = config.exportToProperties();
        KylinConfig dstConfig = KylinConfig.createKylinConfig((Properties)props);
        String string = type = inputPath.endsWith(ZIP_SUFFIX) ? FileSystemMetadataStore.Type.ZIP.name() : FileSystemMetadataStore.Type.DIR.name();
        if (outputPath == null) {
            outputPath = type.equals("ZIP") ? inputPath.replace(ZIP_SUFFIX, "_migrated.zip") : kapConf.getReadHdfsWorkingDirectory() + "migrated/";
            log.info("outputPath is not set, use default: " + outputPath);
        } else {
            log.info("outputPath: " + outputPath);
        }
        String outputZipFile = null;
        if (outputPath.endsWith(ZIP_SUFFIX)) {
            outputZipFile = outputPath;
            outputPath = outputPath.substring(0, outputPath.lastIndexOf(SEPRATOR));
        }
        if (!(fs = HadoopUtil.getWorkingFileSystem((Path)(metadataPath = new Path(outputPath)))).exists(metadataPath)) {
            fs.mkdirs(metadataPath);
        }
        if (type.equals(FileSystemMetadataStore.Type.ZIP.name())) {
            dstConfig.setMetadataUrl(outputPath + "@file,zip=1");
        } else {
            dstConfig.setMetadataUrl(outputPath);
        }
        InMemResourceStore dstResourceStore = (InMemResourceStore)ResourceStore.getKylinMetaStore((KylinConfig)dstConfig);
        FileSystemMetadataStore outputMetadataStore = (FileSystemMetadataStore)MetadataStore.createMetadataStore((KylinConfig)dstConfig);
        MetadataStore.MemoryMetaData memoryMetaData = this.loadOldMetaData(outputMetadataStore, inputPath, type);
        dstResourceStore.resetData(memoryMetaData);
        this.refreshComputeColumns(dstConfig);
        this.dumpToNewFormat(outputMetadataStore, (ResourceStore)dstResourceStore, type, outputZipFile);
    }

    private void refreshComputeColumns(KylinConfig config) {
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)config);
        projectManager.listAllProjects().forEach(project -> {
            NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)config, (String)project.getName());
            ComputedColumnManager ccManager = ComputedColumnManager.getInstance((KylinConfig)config, (String)project.getName());
            HashMap ccMap = new HashMap();
            modelManager.listAllModels().stream().filter(model -> !model.isBroken()).forEach(model -> model.getComputedColumnDescs().forEach(cc -> {
                String uniqueKey;
                if (cc.getExpressionMD5() == null) {
                    try {
                        ComputedColumnUtil.computeMd5((KylinConfig)config, (NDataModel)model, (ComputedColumnDesc)cc);
                    }
                    catch (Exception e) {
                        log.warn("Refresh md5 for compute column failed!", (Throwable)e);
                        return;
                    }
                }
                if (ccMap.containsKey(uniqueKey = cc.getTableIdentity() + "_" + cc.getExpressionMD5())) {
                    ComputedColumnDesc existing = (ComputedColumnDesc)ccMap.get(uniqueKey);
                    if (!existing.getColumnName().equals(cc.getColumnName())) {
                        log.warn("Different CCs share a same expressionMd5, which means these CCs have the same semantic. CCs: {}={}, {}={}", new Object[]{((ComputedColumnDesc)ccMap.get(uniqueKey)).getColumnName(), ((ComputedColumnDesc)ccMap.get(uniqueKey)).getInnerExpression(), cc.getColumnName(), cc.getInnerExpression()});
                        cc.setExpressionMD5(null);
                    }
                } else {
                    ccMap.put(uniqueKey, cc);
                    ccManager.updateMD5Manually(cc, cc.getExpressionMD5());
                }
            }));
        });
    }

    private void dumpToNewFormat(FileSystemMetadataStore fileStore, ResourceStore resourceStore, String type, String outputZipFile) throws IOException, InterruptedException, ExecutionException {
        NavigableSet resources = resourceStore.listResourcesRecursively(MetadataType.ALL.name());
        if (FileSystemMetadataStore.Type.ZIP.name().equals(type)) {
            fileStore.dumpToZip(resourceStore, (Collection)resources, new Path(outputZipFile));
        } else {
            fileStore.dumpToFile(resourceStore, (Collection)resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUniqueUuid(Map<String, Map<String, String>> globalMap, String scope, String originUuid) {
        Map projectMap = globalMap.computeIfAbsent(originUuid, k -> new ConcurrentHashMap());
        if (projectMap.get(scope) == null) {
            Map map = projectMap;
            synchronized (map) {
                if (projectMap.get(scope) == null) {
                    projectMap.put(scope, projectMap.isEmpty() ? originUuid : RandomUtil.randomUUIDStr());
                    if (!originUuid.equals(projectMap.get(scope))) {
                        log.info("Rename metadata uuid from {} to {} in scope {}", new Object[]{originUuid, projectMap.get(scope), scope});
                    }
                }
            }
        }
        return (String)projectMap.get(scope);
    }

    public static boolean verifyNonMetadataFile(String resourcePath) {
        if (resourcePath.startsWith(SEPRATOR)) {
            resourcePath = resourcePath.substring(1);
        }
        String[] nonMetadata = new String[]{"kylin.properties", ".DS_Store"};
        String[] metadataShouldBeIgnored = new String[]{"/rule/", "/query_history_id_offset/", "_global/epoch", "/execute/", "/recommendation/", "/accelerate_ratio/", "/favorite/", "/query_history_time_offset/", "/query_history/", "/query_history_time/", "/query_history_id/", "/event/", "/rec_items/", "/loading_range/", "/dataflow_detail/", "/async_task/"};
        String[] metadataWithoutJsonPostfix = new String[]{"UUID", "VERSION", "_image", "_global/user", "_global/user_group", "_global/sys_acl", "/streaming/", "_global/logical_view"};
        for (String s : nonMetadata) {
            if (!resourcePath.endsWith(s)) continue;
            return true;
        }
        for (String s : metadataShouldBeIgnored) {
            if (!(s.startsWith(SEPRATOR) ? resourcePath.contains(s) : resourcePath.startsWith(s))) continue;
            return true;
        }
        for (String s : metadataWithoutJsonPostfix) {
            if (!(s.startsWith(SEPRATOR) ? resourcePath.contains(s) : resourcePath.startsWith(s))) continue;
            return false;
        }
        return !resourcePath.endsWith(".json");
    }

    private class MigrateRawResourceFactory {
        private MigrateRawResourceFactory() {
        }

        private void createAndSaveCcRelations(JsonNode je, ObjectNode modelMap, String proj, String modelUuid, long ts, MetadataStore.MemoryMetaData data, ArrayNode ccUuids) throws IOException {
            if (je.has("computed_columns")) {
                JsonNode s = modelMap.get("computed_columns");
                JsonNode entries = (JsonNode)JsonUtil.readValue((byte[])JsonUtil.writeValueAsIndentBytes((Object)s), ArrayNode.class);
                for (JsonNode entry : entries) {
                    String ccUuid = this.checkAndCreateCC(entry, proj, ts, data);
                    ccUuids.add(ccUuid);
                    CcModelRelationRawResource ccRel = this.createCCRelation(ccUuid, proj, modelUuid, ts);
                    data.put(MetadataType.CC_MODEL_RELATION, new VersionedRawResource((RawResource)ccRel));
                }
                modelMap.remove("computed_columns");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String checkAndCreateCC(JsonNode entry, String proj, long ts, MetadataStore.MemoryMetaData data) throws IOException {
            LinkedHashMap contentJsonMap = (LinkedHashMap)JsonUtil.convert((Object)entry, (TypeReference)new TypeReference<LinkedHashMap<String, String>>(){});
            String uniqueKey = proj + "." + (String)contentJsonMap.get("tableIdentity") + "." + (String)contentJsonMap.get("columnName");
            String ccUuid = (String)MigrateKEMetadataTool.this.ccUuidMap.get(uniqueKey);
            boolean needCreate = false;
            if (ccUuid == null) {
                Map map = MigrateKEMetadataTool.this.ccUuidMap;
                synchronized (map) {
                    ccUuid = (String)MigrateKEMetadataTool.this.ccUuidMap.get(uniqueKey);
                    if (ccUuid == null) {
                        needCreate = true;
                        ccUuid = RandomUtil.randomUUIDStr();
                        MigrateKEMetadataTool.this.ccUuidMap.put(uniqueKey, ccUuid);
                    }
                }
            }
            if (needCreate) {
                contentJsonMap.put("uuid", ccUuid);
                contentJsonMap.put(MigrateKEMetadataTool.PROJECT_KEY, proj);
                ComputeColumnRawResource cc = (ComputeColumnRawResource)JsonUtil.convert((Object)entry, ComputeColumnRawResource.class);
                cc.setUuid(ccUuid);
                cc.setProject(proj);
                cc.setContent(JsonUtil.writeValueAsIndentBytes((Object)contentJsonMap));
                cc.setMetaKey(ccUuid);
                cc.setMvcc(0L);
                cc.setTs(Long.valueOf(ts));
                data.put(MetadataType.COMPUTE_COLUMN, new VersionedRawResource((RawResource)cc));
            }
            return ccUuid;
        }

        private CcModelRelationRawResource createCCRelation(String ccUuid, String proj, String modelUuid, long ts) throws JsonProcessingException {
            CcModelRelationRawResource ccRel = new CcModelRelationRawResource();
            String ccRelUuid = RandomUtil.randomUUIDStr();
            ccRel.setUuid(ccRelUuid);
            ccRel.setMetaKey(ccRelUuid);
            ccRel.setProject(proj);
            ccRel.setModelUuid(modelUuid);
            ccRel.setCcUuid(ccUuid);
            ccRel.setMvcc(0L);
            HashMap<String, String> ccRelMap = new HashMap<String, String>();
            ccRelMap.put("uuid", ccRelUuid);
            ccRelMap.put(MigrateKEMetadataTool.PROJECT_KEY, proj);
            ccRelMap.put("model_uuid", modelUuid);
            ccRelMap.put("cc_uuid", ccUuid);
            ccRel.setContent(JsonUtil.writeValueAsIndentBytes(ccRelMap));
            ccRel.setTs(Long.valueOf(ts));
            return ccRel;
        }

        private void createAndSaveTableRelations(JsonNode je, ObjectNode modelMap, String proj, String modelUuid, long ts, MetadataStore.MemoryMetaData data) throws IOException {
            String factTable;
            HashSet<String> refTables = new HashSet<String>();
            if (je.has("join_tables")) {
                JsonNode s = modelMap.get("join_tables");
                JsonNode entries = (JsonNode)JsonUtil.readValue((byte[])JsonUtil.writeValueAsIndentBytes((Object)s), ArrayNode.class);
                for (JsonNode entry : entries) {
                    String identifier = entry.get("table").asText();
                    if (refTables.contains(identifier)) continue;
                    refTables.add(identifier);
                    TableModelRelationRawResource relation = this.createTableModelRelation(modelUuid, proj, identifier, ts);
                    data.put(MetadataType.TABLE_MODEL_RELATION, new VersionedRawResource((RawResource)relation));
                }
            }
            if (!refTables.contains(factTable = je.get("fact_table").asText())) {
                TableModelRelationRawResource relation = this.createTableModelRelation(modelUuid, proj, factTable, ts);
                data.put(MetadataType.TABLE_MODEL_RELATION, new VersionedRawResource((RawResource)relation));
            }
        }

        private TableModelRelationRawResource createTableModelRelation(String modelUuid, String proj, String tableIdentity, long ts) throws JsonProcessingException {
            String uuid = RandomUtil.randomUUIDStr();
            TableModelRelationRawResource relation = new TableModelRelationRawResource();
            relation.setUuid(uuid);
            relation.setModelUuid(modelUuid);
            relation.setProject(proj);
            relation.setTableIdentity(tableIdentity);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("uuid", uuid);
            map.put("model_uuid", modelUuid);
            map.put(MigrateKEMetadataTool.PROJECT_KEY, proj);
            map.put("table_identity", tableIdentity);
            relation.setContent(JsonUtil.writeValueAsIndentBytes(map));
            relation.setMetaKey(uuid);
            relation.setMvcc(0L);
            relation.setTs(Long.valueOf(ts));
            return relation;
        }

        public RawResource createSystemRawResource(String tagName, long ts, DataInputStream in) throws IOException {
            SystemRawResource bs = new SystemRawResource();
            byte[] content = null;
            switch (tagName) {
                case "UUID": {
                    StringEntity deserialize;
                    try {
                        deserialize = (StringEntity)serializer.deserialize(in);
                    }
                    catch (Exception e) {
                        log.warn("loadZip error", (Throwable)e);
                        deserialize = new StringEntity(RandomUtil.randomUUIDStr());
                    }
                    deserialize.setName("UUID");
                    deserialize.setUuid(deserialize.getStr());
                    bs.setUuid(deserialize.getStr());
                    content = JsonUtil.writeValueAsIndentBytes((Object)deserialize);
                    break;
                }
                case "_image": {
                    ImageDesc image = (ImageDesc)JsonUtil.readValue((InputStream)in, ImageDesc.class);
                    content = JsonUtil.writeValueAsIndentBytes((Object)image);
                    break;
                }
                case "VERSION": {
                    String version = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8).trim();
                    StringEntity versionEntity = new StringEntity("VERSION", version);
                    content = JsonUtil.writeValueAsIndentBytes((Object)versionEntity);
                    break;
                }
                case "acl_version": {
                    Map aclVersionMap = JsonUtil.readValueAsMap((String)IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8).trim());
                    aclVersionMap.put("name", tagName);
                    content = JsonUtil.writeValueAsIndentBytes((Object)aclVersionMap);
                    break;
                }
            }
            bs.setName(tagName);
            bs.setMetaKey(tagName);
            bs.setMvcc(0L);
            bs.setTs(Long.valueOf(ts));
            bs.setContent(content);
            return bs;
        }

        public RawResource createRecResource(String resPath, long ts, DataInputStream in) throws IOException {
            if (resPath.startsWith(MigrateKEMetadataTool.SEPRATOR)) {
                resPath = resPath.substring(1);
            }
            String[] split = resPath.split(MigrateKEMetadataTool.SEPRATOR);
            String project = split[0];
            String uuid = split[2].replace(".json", "");
            byte[] byteArray = IOUtils.toByteArray((InputStream)in);
            JsonNode recItems = (JsonNode)JsonUtil.readValue((byte[])byteArray, JsonNode.class);
            ObjectNode recEntity = new ObjectNode(JsonNodeFactory.instance);
            recEntity.put("uuid", uuid);
            recEntity.put(MigrateKEMetadataTool.PROJECT_KEY, project);
            recEntity.set("rec_items", recItems);
            RecRawResource bs = new RecRawResource();
            bs.setProject(project);
            bs.setUuid(RandomUtil.randomUUIDStr());
            bs.setContent(JsonUtil.writeValueAsIndentBytes((Object)recEntity));
            bs.setMetaKey(project + "." + uuid);
            bs.setMvcc(0L);
            bs.setTs(Long.valueOf(ts));
            return bs;
        }

        private RawResource createDataflowResource(Tuple3<String, MetadataType, String> resPathPair, long ts, byte[] byteArray, MetadataStore.MemoryMetaData data) throws IOException {
            String uniqueUuid;
            JsonNode je = (JsonNode)JsonUtil.readValue((byte[])byteArray, JsonNode.class);
            ObjectNode contentJsonMap = JsonUtil.valueToTree((Object)je);
            String modelUuid = contentJsonMap.get("uuid").asText();
            String proj = (String)resPathPair._1();
            if (KylinConfig.getInstanceFromEnv().isUTEnv() && !modelUuid.equals(uniqueUuid = MigrateKEMetadataTool.getUniqueUuid(MigrateKEMetadataTool.this.modelUuidMap, proj, modelUuid))) {
                modelUuid = uniqueUuid;
                contentJsonMap.put("uuid", modelUuid);
                contentJsonMap.put("meta_key", modelUuid);
            }
            ArrayNode segmentUuids = JsonUtil.createArrayNode();
            if (je.has("segments")) {
                JsonNode entries = contentJsonMap.get("segments");
                for (JsonNode entry : entries) {
                    String uniqueUuid2;
                    SegmentRawResourceWrap segmentWrap = (SegmentRawResourceWrap)JsonUtil.convert((Object)entry, SegmentRawResourceWrap.class);
                    String uuid = segmentWrap.getId();
                    if (KylinConfig.getInstanceFromEnv().isUTEnv() && !uuid.equals(uniqueUuid2 = MigrateKEMetadataTool.getUniqueUuid(MigrateKEMetadataTool.this.segUuidMap, modelUuid, uuid))) {
                        uuid = uniqueUuid2;
                    }
                    segmentWrap.setId(null);
                    segmentWrap.setUuid(uuid);
                    byte[] wrapJson = JsonUtil.writeValueAsIndentBytes((Object)segmentWrap);
                    SegmentRawResource seg = (SegmentRawResource)JsonUtil.readValue((byte[])wrapJson, SegmentRawResource.class);
                    seg.setModelUuid(modelUuid);
                    seg.setProject(proj);
                    seg.setUuid(uuid);
                    LinkedHashMap segContentMap = (LinkedHashMap)JsonUtil.convert((Object)entry, (TypeReference)new TypeReference<LinkedHashMap<Object, Object>>(){});
                    segContentMap.remove("id");
                    segContentMap.put("uuid", uuid);
                    segContentMap.put("model_uuid", modelUuid);
                    segContentMap.put(MigrateKEMetadataTool.PROJECT_KEY, proj);
                    seg.setContent(JsonUtil.writeValueAsIndentBytes((Object)segContentMap));
                    seg.setMetaKey(uuid);
                    seg.setMvcc(0L);
                    seg.setTs(Long.valueOf(ts));
                    data.put(MetadataType.SEGMENT, new VersionedRawResource((RawResource)seg));
                    segmentUuids.add(uuid);
                }
                contentJsonMap.remove("segments");
            }
            contentJsonMap.put(MigrateKEMetadataTool.PROJECT_KEY, proj);
            contentJsonMap.set("segment_uuids", (JsonNode)segmentUuids);
            byte[] contentByte = JsonUtil.writeValueAsIndentBytes((Object)contentJsonMap);
            RawResource res = (RawResource)JsonUtil.readValue((byte[])contentByte, (Class)MetadataType.DATAFLOW.getResourceClass());
            res.setProject(proj);
            res.setContent(contentByte);
            return res;
        }

        private RawResource createModelResource(Tuple3<String, MetadataType, String> resPathPair, long ts, byte[] byteArray, MetadataStore.MemoryMetaData data) throws IOException {
            String uniqueUuid;
            JsonNode je = (JsonNode)JsonUtil.readValue((byte[])byteArray, JsonNode.class);
            ObjectNode modelMap = JsonUtil.valueToTree((Object)je);
            String modelUuid = modelMap.get("uuid").asText();
            String proj = (String)resPathPair._1();
            if (KylinConfig.getInstanceFromEnv().isUTEnv() && !modelUuid.equals(uniqueUuid = MigrateKEMetadataTool.getUniqueUuid(MigrateKEMetadataTool.this.modelUuidMap, proj, modelUuid))) {
                modelUuid = uniqueUuid;
                modelMap.put("uuid", modelUuid);
                modelMap.put("meta_key", modelUuid);
            }
            ArrayNode ccUuids = modelMap.putArray("computed_column_uuids");
            this.createAndSaveCcRelations(je, modelMap, proj, modelUuid, ts, data, ccUuids);
            this.createAndSaveTableRelations(je, modelMap, proj, modelUuid, ts, data);
            modelMap.put(MigrateKEMetadataTool.PROJECT_KEY, proj);
            byte[] bytes = JsonUtil.writeValueAsIndentBytes((Object)modelMap);
            RawResource res = (RawResource)JsonUtil.readValue((byte[])bytes, (Class)((MetadataType)resPathPair._2()).getResourceClass());
            res.setProject(proj);
            res.setContent(bytes);
            return res;
        }

        private RawResource createLayoutResource(Tuple3<String, MetadataType, String> resPathPair, byte[] byteArray) throws IOException {
            String proj = (String)resPathPair._1();
            String dataflowUuid = ((String)resPathPair._3()).split(MigrateKEMetadataTool.SEPRATOR)[0];
            String layoutUuid = ((String)resPathPair._3()).split(MigrateKEMetadataTool.SEPRATOR)[1].replace(".json", "");
            if (KylinConfig.getInstanceFromEnv().isUTEnv()) {
                String uniqueModelUuid = MigrateKEMetadataTool.getUniqueUuid(MigrateKEMetadataTool.this.modelUuidMap, proj, dataflowUuid);
                String uniqueSegUuid = MigrateKEMetadataTool.getUniqueUuid(MigrateKEMetadataTool.this.segUuidMap, uniqueModelUuid, layoutUuid);
                if (!dataflowUuid.equals(uniqueModelUuid)) {
                    dataflowUuid = uniqueModelUuid;
                }
                if (!layoutUuid.equals(uniqueSegUuid)) {
                    layoutUuid = uniqueSegUuid;
                }
            }
            LayoutRawResource resource = (LayoutRawResource)JsonUtil.readValue((byte[])byteArray, LayoutRawResource.class);
            resource.setDataflowId(dataflowUuid);
            resource.setMetaKey(layoutUuid);
            resource.setUuid(resource.getMetaKey());
            resource.setProject(proj);
            LinkedHashMap layoutMap = (LinkedHashMap)JsonUtil.readValue((InputStream)ByteSource.wrap((byte[])byteArray).openStream(), (TypeReference)new TypeReference<LinkedHashMap<Object, Object>>(){});
            layoutMap.put("dataflow", resource.getDataflowId());
            layoutMap.put("uuid", resource.getUuid());
            layoutMap.put(MigrateKEMetadataTool.PROJECT_KEY, proj);
            resource.setContent(JsonUtil.writeValueAsIndentBytes((Object)layoutMap));
            return resource;
        }

        private RawResource createIndexPlanResource(Tuple3<String, MetadataType, String> resPathPair, byte[] byteArray) throws IOException {
            String uniqueUuid;
            String proj = (String)resPathPair._1();
            LinkedHashMap otherMap = (LinkedHashMap)JsonUtil.readValue((InputStream)ByteSource.wrap((byte[])byteArray).openStream(), (TypeReference)new TypeReference<LinkedHashMap<Object, Object>>(){});
            String indexPlanUuid = otherMap.get("uuid").toString();
            if (KylinConfig.getInstanceFromEnv().isUTEnv() && !indexPlanUuid.equals(uniqueUuid = MigrateKEMetadataTool.getUniqueUuid(MigrateKEMetadataTool.this.modelUuidMap, proj, indexPlanUuid))) {
                indexPlanUuid = uniqueUuid;
            }
            otherMap.put(MigrateKEMetadataTool.PROJECT_KEY, proj);
            otherMap.put("uuid", indexPlanUuid);
            RawResource res = (RawResource)JsonUtil.readValue((byte[])byteArray, (Class)((MetadataType)resPathPair._2()).getResourceClass());
            res.setProject(proj);
            res.setUuid(indexPlanUuid);
            res.setMetaKey(indexPlanUuid);
            res.setContent(JsonUtil.writeValueAsIndentBytes((Object)otherMap));
            return res;
        }

        private RawResource createDefaultResource(Tuple3<String, MetadataType, String> resPathPair, byte[] byteArray) throws IOException {
            RawResource res = (RawResource)JsonUtil.readValue((byte[])byteArray, (Class)((MetadataType)resPathPair._2()).getResourceClass());
            if (resPathPair._2() != MetadataType.PROJECT) {
                String proj = (String)resPathPair._1();
                LinkedHashMap otherMap = (LinkedHashMap)JsonUtil.readValue((InputStream)ByteSource.wrap((byte[])byteArray).openStream(), (TypeReference)new TypeReference<LinkedHashMap<Object, Object>>(){});
                otherMap.put(MigrateKEMetadataTool.PROJECT_KEY, proj);
                res.setProject(proj);
                res.setContent(JsonUtil.writeValueAsIndentBytes((Object)otherMap));
            } else {
                res.setContent(byteArray);
            }
            return res;
        }

        public RawResource createDataParserResource(Tuple3<String, MetadataType, String> resPathPair, byte[] byteArray) throws IOException {
            String proj = (String)resPathPair._1();
            LinkedHashMap otherMap = (LinkedHashMap)JsonUtil.readValue((InputStream)ByteSource.wrap((byte[])byteArray).openStream(), (TypeReference)new TypeReference<LinkedHashMap<Object, Object>>(){});
            otherMap.put(MigrateKEMetadataTool.PROJECT_KEY, proj);
            DataParserRawResource res = (DataParserRawResource)JsonUtil.readValue((byte[])byteArray, DataParserRawResource.class);
            res.setProject(proj);
            res.setMetaKey(proj + "." + res.getClassName());
            res.setContent(JsonUtil.writeValueAsIndentBytes((Object)otherMap));
            return res;
        }
    }
}

